/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.loginserver;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.loginserver.LoginManager;
import net.sf.l2j.loginserver.LoginServer;
import net.sf.l2j.loginserver.serverpackets.Init;
import net.sf.l2j.util.Util;

public class GameServerListener
extends Thread {
    protected static Logger _log = Logger.getLogger(LoginServer.class.getName());
    protected ServerSocket gameServerSocket;
    protected LoginManager loginManager = LoginManager.getInstance();

    public GameServerListener() {
        try {
            this.gameServerSocket = new ServerSocket(9013);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isBannedGameserverIP(String ipAddress) {
        return false;
    }

    public void run() {
        do {
            try {
                Socket connection = this.gameServerSocket.accept();
                new GameServerRegistration(connection);
            }
            catch (IOException e) {
                // empty catch block
            }
        } while (!this.isInterrupted());
        try {
            this.gameServerSocket.close();
        }
        catch (IOException io) {
            _log.log(Level.INFO, "", io);
        }
    }

    public class GameServerRegistration
    implements Runnable {
        private Socket connection;
        private String connectionIpAddress;
        private String gameserverIpAddress;
        private String hostname = Config.EXTERNAL_HOSTNAME;
        private ByteBuffer readBuffer = ByteBuffer.allocate(65536);
        private InputStream in;
        private BufferedOutputStream out;

        public GameServerRegistration(Socket connection) {
            this.connection = connection;
            this.readBuffer.order(ByteOrder.LITTLE_ENDIAN);
            GameServerListener.this.start();
        }

        public void run() {
            this.connectionIpAddress = this.connection.getInetAddress().getHostAddress();
            this.setHostName();
            try {
                this.in = this.connection.getInputStream();
                this.out = new BufferedOutputStream(this.connection.getOutputStream());
                this.gameserverIpAddress = InetAddress.getByName(this.hostname).getHostAddress();
                if (GameServerListener.this.isBannedGameserverIP(this.connectionIpAddress)) {
                    _log.info("GameServerRegistration: IP Address " + this.connectionIpAddress + " is on Banned IP list.");
                }
                _log.fine("GameServerRegistration: Connected to GamerServer at " + this.connectionIpAddress);
                this.handleRegistrationProcess();
            }
            catch (IOException e) {
                _log.log(Level.FINE, "", e);
                e.printStackTrace();
            }
        }

        private void handleRegistrationProcess() throws IOException {
            Init startPacket = new Init();
            this.out.write(startPacket.getLength() & 0xFF);
            this.out.write(startPacket.getLength() >> 8 & 0xFF);
            this.out.write(startPacket.getContent());
            this.out.flush();
            this.readBuffer.put((byte)this.in.read());
            this.readBuffer.put((byte)this.in.read());
            short packetLength = this.readBuffer.getShort();
            if (packetLength < 1) {
                _log.warning("LoginServer: Gameserver terminated the connection.");
            }
            this.readBuffer.limit(packetLength);
            while (true) {
                this.readBuffer.put((byte)this.in.read());
            }
        }

        private void setHostName() {
            if (Util.isInternalIP(this.connectionIpAddress)) {
                if (Config.DEBUG) {
                    _log.fine("Using Internal IP as Server IP. Internal Hostname is " + Config.INTERNAL_HOSTNAME);
                }
                this.hostname = Config.INTERNAL_HOSTNAME;
            } else if (Config.DEBUG) {
                _log.fine("Using External IP as Server IP. External Hostname is " + Config.EXTERNAL_HOSTNAME);
            }
        }
    }
}

