/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.loginserver;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.loginserver.HackingException;
import net.sf.l2j.loginserver.LoginController;
import net.sf.l2j.loginserver.Logins;
import net.sf.l2j.loginserver.NewCrypt;
import net.sf.l2j.loginserver.clientpackets.RequestAuthLogin;
import net.sf.l2j.loginserver.clientpackets.RequestServerLogin;
import net.sf.l2j.loginserver.serverpackets.Init;
import net.sf.l2j.loginserver.serverpackets.LoginFail;
import net.sf.l2j.loginserver.serverpackets.LoginOk;
import net.sf.l2j.loginserver.serverpackets.PlayOk;
import net.sf.l2j.loginserver.serverpackets.ServerBasePacket;
import net.sf.l2j.loginserver.serverpackets.ServerList;

public class ClientThread
extends Thread {
    static Logger _log = Logger.getLogger(ClientThread.class.getName());
    private InputStream _in;
    private OutputStream _out;
    private NewCrypt _crypt;
    private Logins _logins;
    private Socket _csocket;
    private String _gameServerHost;
    private int _gameServerPort;
    protected static List<String> _bannedIPs = new ArrayList<String>();

    public ClientThread(Socket client, Logins logins, String host, int port) throws IOException {
        super("Login Client " + client.getInetAddress());
        this.setDaemon(true);
        this._csocket = client;
        String ip = client.getInetAddress().getHostAddress();
        this._in = client.getInputStream();
        this._out = new BufferedOutputStream(client.getOutputStream());
        this._crypt = new NewCrypt("[;'.]94-31==-%&@!^+]\u0000");
        this._logins = logins;
        this._gameServerHost = host;
        this._gameServerPort = port;
        if (_bannedIPs.contains(ip)) {
            LoginFail lok = new LoginFail(LoginFail.REASON_ACCOUNT_BANNED);
            this.sendPacket(lok);
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Config.DEBUG) {
            _log.fine("loginserver thread[C] started");
        }
        int lengthHi = 0;
        int lengthLo = 0;
        int length = 0;
        boolean checksumOk = false;
        int sessionKey = -1;
        String account = null;
        String gameServerIp = null;
        try {
            InetAddress adr = InetAddress.getByName(this._gameServerHost);
            gameServerIp = adr.getHostAddress();
            Init startPacket = new Init();
            this._out.write(startPacket.getLength() & 0xFF);
            this._out.write(startPacket.getLength() >> 8 & 0xFF);
            this._out.write(startPacket.getContent());
            this._out.flush();
            block24: while (true) {
                int receivedBytes;
                lengthLo = this._in.read();
                lengthHi = this._in.read();
                length = lengthHi * 256 + lengthLo;
                if (lengthHi < 0) {
                    _log.warning("LoginServer: Client terminated the connection.");
                    break;
                }
                byte[] incoming = new byte[length];
                incoming[0] = (byte)lengthLo;
                incoming[1] = (byte)lengthHi;
                int newBytes = 0;
                for (receivedBytes = 0; newBytes != -1 && receivedBytes < length - 2; receivedBytes += newBytes) {
                    newBytes = this._in.read(incoming, 2, length - 2);
                }
                if (receivedBytes != length - 2) {
                    _log.warning("Incomplete Packet is sent to the server, closing connection.");
                    break;
                }
                byte[] decrypt = new byte[length - 2];
                System.arraycopy(incoming, 2, decrypt, 0, decrypt.length);
                decrypt = this._crypt.decrypt(decrypt);
                checksumOk = this._crypt.checksum(decrypt);
                if (!checksumOk) {
                    _log.warning("Incorrect packet checksum, closing connection..");
                    break;
                }
                if (Config.DEBUG) {
                    _log.finest("[C]\n" + this.printData(decrypt, decrypt.length));
                }
                int packetType = decrypt[0] & 0xFF;
                switch (packetType) {
                    case 0: {
                        RequestAuthLogin ral = new RequestAuthLogin(decrypt);
                        account = ral.getUser().toLowerCase();
                        if (Config.DEBUG) {
                            _log.fine("RequestAuthLogin from user:" + account);
                        }
                        LoginController lc = LoginController.getInstance();
                        if (this._logins.loginValid(account, ral.getPassword(), this._csocket.getInetAddress())) {
                            if (this._logins.loginBanned(account)) {
                                LoginFail lok = new LoginFail(LoginFail.REASON_ACCOUNT_BANNED);
                                this.sendPacket(lok);
                                break;
                            }
                            if (!lc.isAccountInGameServer(account) && !lc.isAccountInLoginServer(account)) {
                                sessionKey = lc.assignSessionKeyToLogin(account, this._csocket);
                                if (Config.DEBUG) {
                                    _log.fine("assigned SessionKey:" + Integer.toHexString(sessionKey));
                                }
                                LoginOk lok = new LoginOk();
                                this.sendPacket(lok);
                                break;
                            }
                            if (Config.DEBUG) {
                                _log.fine("KICKING!");
                            }
                            if (lc.isAccountInLoginServer(account)) {
                                _log.warning("account is in use on Login server (kicking off):" + account);
                                lc.getLoginServerConnection(account).close();
                                lc.removeLoginServerLogin(account);
                            }
                            if (lc.isAccountInGameServer(account)) {
                                _log.warning("account is in use on Gamea server (kicking off):" + account);
                                lc.getClientConnection(account).close();
                                lc.removeGameServerLogin(account);
                            }
                            LoginFail lok = new LoginFail(LoginFail.REASON_ACCOUNT_IN_USE);
                            this.sendPacket(lok);
                            break;
                        }
                        LoginFail lok = new LoginFail(LoginFail.REASON_USER_OR_PASS_WRONG);
                        this.sendPacket(lok);
                        if (!Config.DEBUG) continue block24;
                        _log.fine("login failed sent");
                        break;
                    }
                    case 2: {
                        if (Config.DEBUG) {
                            _log.fine("RequestServerLogin");
                        }
                        RequestServerLogin rsl = new RequestServerLogin(decrypt);
                        if (Config.DEBUG) {
                            _log.fine("login to server:" + rsl.getData3());
                        }
                        PlayOk po = new PlayOk(sessionKey);
                        this.sendPacket(po);
                        break;
                    }
                    case 5: {
                        if (Config.DEBUG) {
                            _log.fine("RequestServerList");
                        }
                        ServerList sl = new ServerList();
                        int current2 = LoginController.getInstance().getOnlinePlayerCount();
                        int max = LoginController.getInstance().getMaxAllowedOnlinePlayers();
                        sl.addServer(gameServerIp, this._gameServerPort, true, true, current2, max);
                        sl.addServer(gameServerIp, this._gameServerPort, true, false, current2, max);
                        this.sendPacket(sl);
                        break;
                    }
                    default: {
                        _log.warning("Unknown Packet:" + packetType);
                        _log.warning(this.printData(decrypt, decrypt.length));
                    }
                }
            }
        }
        catch (SocketException e) {
            _log.fine("Connection closed unexpectedly.");
        }
        catch (HackingException e) {
            this.addBannedIP(e.getIP(), e.getConnects());
        }
        catch (Exception e) {
            _log.log(Level.INFO, "", e);
        }
        finally {
            try {
                this._csocket.close();
            }
            catch (Exception e1) {}
            LoginController.getInstance().removeLoginServerLogin(account);
            if (Config.DEBUG) {
                _log.fine("loginserver thread[C] stopped");
            }
        }
    }

    private void sendPacket(ServerBasePacket sl) throws IOException {
        byte[] data = sl.getContent();
        this._crypt.checksum(data);
        if (Config.DEBUG) {
            _log.finest("[S]\n" + this.printData(data, data.length));
        }
        data = this._crypt.crypt(data);
        int len = data.length + 2;
        this._out.write(len & 0xFF);
        this._out.write(len >> 8 & 0xFF);
        this._out.write(data);
        this._out.flush();
    }

    private String printData(byte[] data, int len) {
        byte t1;
        int a;
        int charpoint;
        StringBuffer result = new StringBuffer();
        int counter = 0;
        for (int i = 0; i < len; ++i) {
            if (counter % 16 == 0) {
                result.append(this.fillHex(i, 4) + ": ");
            }
            result.append(this.fillHex(data[i] & 0xFF, 2) + " ");
            if (++counter != 16) continue;
            result.append("   ");
            charpoint = i - 15;
            for (a = 0; a < 16; ++a) {
                if ((t1 = data[charpoint++]) > 31 && t1 < 128) {
                    result.append((char)t1);
                    continue;
                }
                result.append('.');
            }
            result.append("\n");
            counter = 0;
        }
        int rest = data.length % 16;
        if (rest > 0) {
            for (int i = 0; i < 17 - rest; ++i) {
                result.append("   ");
            }
            charpoint = data.length - rest;
            for (a = 0; a < rest; ++a) {
                if ((t1 = data[charpoint++]) > 31 && t1 < 128) {
                    result.append((char)t1);
                    continue;
                }
                result.append('.');
            }
            result.append("\n");
        }
        return result.toString();
    }

    private String fillHex(int data, int digits) {
        String number = Integer.toHexString(data);
        for (int i = number.length(); i < digits; ++i) {
            number = "0" + number;
        }
        return number;
    }

    private String getTerminatedString(byte[] data, int offset) {
        StringBuffer result = new StringBuffer();
        for (int i = offset; i < data.length && data[i] != 0; ++i) {
            result.append((char)data[i]);
        }
        return result.toString();
    }

    public void addBannedIP(String ip, int incorrectCount) {
        _bannedIPs.add(ip);
        int time = incorrectCount * incorrectCount * 1000;
        ClientScheduler.getInstance().scheduleMed(new UnbanTask(ip), time);
    }

    public static void addBannedIP(String ip) {
        _bannedIPs.add(ip);
    }

    public class UnbanTask
    implements Runnable {
        public String _ip;

        public UnbanTask(String IP) {
            this._ip = IP;
        }

        public void run() {
            _bannedIPs.remove(this._ip);
        }
    }
}

