/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.templates;

import java.util.ArrayList;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.ClassId;
import net.sf.l2j.gameserver.model.Race;
import net.sf.l2j.gameserver.templates.L2CharTemplate;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.StatsSet;

public class L2PcTemplate
extends L2CharTemplate {
    public final ClassId classId;
    public final Race race;
    public final String className;
    public final int baseLoad;
    public final int spawnX;
    public final int spawnY;
    public final int spawnZ;
    public final boolean isMale;
    public final int classBaseLevel;
    public final float lvlHpAdd;
    public final float lvlHpMod;
    public final float lvlMpAdd;
    public final float lvlMpMod;
    private ArrayList<L2Item> _items = new ArrayList();

    public L2PcTemplate(StatsSet set2) {
        super(set2);
        this.classId = ClassId.values()[set2.getInteger("classId")];
        this.race = Race.values()[set2.getInteger("raceId")];
        this.className = set2.getString("className");
        this.baseLoad = set2.getInteger("baseLoad");
        this.spawnX = set2.getInteger("spawnX");
        this.spawnY = set2.getInteger("spawnY");
        this.spawnZ = set2.getInteger("spawnZ");
        this.isMale = set2.getBool("isMale", true);
        this.classBaseLevel = set2.getInteger("classBaseLevel");
        this.lvlHpAdd = set2.getFloat("lvlHpAdd");
        this.lvlHpMod = set2.getFloat("lvlHpMod");
        this.lvlMpAdd = set2.getFloat("lvlMpAdd");
        this.lvlMpMod = set2.getFloat("lvlMpMod");
    }

    public void addItem(int itemId) {
        L2Item item = ItemTable.getInstance().getTemplate(itemId);
        if (item != null) {
            this._items.add(item);
        }
    }

    public L2Item[] getItems() {
        return this._items.toArray(new L2Item[this._items.size()]);
    }
}

