/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.templates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.l2j.gameserver.model.ClassId;
import net.sf.l2j.gameserver.model.L2DropData;
import net.sf.l2j.gameserver.model.L2MinionData;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.quest.Quest;
import net.sf.l2j.gameserver.templates.L2CharTemplate;
import net.sf.l2j.gameserver.templates.StatsSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class L2NpcTemplate
extends L2CharTemplate {
    public final int npcId;
    public final String type;
    public final String name;
    public final String sex;
    public final int level;
    public final int revardExp;
    public final int revardSp;
    public final int aggroRange;
    public final int rhand;
    public final int lhand;
    public final int armor;
    public final String factionId;
    public final int factionRange;
    public final boolean isUndead;
    private final List<L2DropData> _drops = new ArrayList<L2DropData>(0);
    private final List<L2MinionData> _minions = new ArrayList<L2MinionData>(0);
    private List<ClassId> _teachInfo;
    private HashMap<Integer, L2Skill> _skills;
    private Quest[] _questsStart;

    public L2NpcTemplate(StatsSet set2) {
        super(set2);
        this.npcId = set2.getInteger("npcId");
        this.type = set2.getString("type");
        this.name = set2.getString("name");
        this.sex = set2.getString("sex");
        this.level = set2.getInteger("level");
        this.revardExp = set2.getInteger("revardExp");
        this.revardSp = set2.getInteger("revardSp");
        this.aggroRange = set2.getInteger("aggroRange");
        this.rhand = set2.getInteger("rhand");
        this.lhand = set2.getInteger("lhand");
        this.armor = set2.getInteger("armor");
        String f = set2.getString("factionId", null);
        this.factionId = f == null ? null : f.intern();
        this.factionRange = set2.getInteger("factionRange");
        this.isUndead = set2.getInteger("isUndead", 0) == 1;
    }

    public void addTeachInfo(ClassId classId) {
        if (this._teachInfo == null) {
            this._teachInfo = new ArrayList<ClassId>();
        }
        this._teachInfo.add(classId);
    }

    public ClassId[] getTeachInfo() {
        if (this._teachInfo == null) {
            return null;
        }
        return this._teachInfo.toArray(new ClassId[this._teachInfo.size()]);
    }

    public void addDropData(L2DropData drop2) {
        if (!drop2.isQuestDrop()) {
            this._drops.add(drop2);
        }
    }

    public void addRaidData(L2MinionData minion) {
        this._minions.add(minion);
    }

    public void addSkill(L2Skill skill) {
        if (this._skills == null) {
            this._skills = new HashMap();
        }
        this._skills.put(skill.getId(), skill);
    }

    public List<L2DropData> getDropData() {
        return this._drops;
    }

    public List<L2MinionData> getMinionData() {
        return this._minions;
    }

    public HashMap<Integer, L2Skill> getSkills() {
        return this._skills;
    }

    public void addStartQuests(Quest q) {
        if (this._questsStart == null) {
            this._questsStart = new Quest[]{q};
        } else {
            int len = this._questsStart.length;
            Quest[] tmp = new Quest[len + 1];
            for (int i = 0; i < len; ++i) {
                if (this._questsStart[i].getName().equals(q.getName())) {
                    this._questsStart[i] = q;
                    return;
                }
                tmp[i] = this._questsStart[i];
            }
            tmp[len] = q;
            this._questsStart = tmp;
        }
    }

    public Quest[] getStartQuests() {
        return this._questsStart;
    }
}

