/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.Item;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.skills.DocumentItem;
import net.sf.l2j.gameserver.skills.DocumentSkill;
import net.sf.l2j.gameserver.templates.L2Armor;
import net.sf.l2j.gameserver.templates.L2EtcItem;
import net.sf.l2j.gameserver.templates.L2EtcItemType;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.L2Weapon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkillsEngine {
    protected static Logger _log = Logger.getLogger(SkillsEngine.class.getName());
    private static final SkillsEngine _instance = new SkillsEngine();
    private List<File> _armorFiles = new LinkedList<File>();
    private List<File> _weaponFiles = new LinkedList<File>();
    private List<File> _etcitemFiles = new LinkedList<File>();
    private List<File> _skillFiles = new LinkedList<File>();
    private HashMap<Integer, DocumentItem> _weaponDocuments = new HashMap();
    private HashMap<Integer, DocumentItem> _itemDocuments = new HashMap();
    private HashMap<Integer, DocumentItem> _armorDocuments = new HashMap();
    private HashMap<Integer, DocumentSkill> _skillDocuments = new HashMap();

    public static SkillsEngine getInstance() {
        return _instance;
    }

    private SkillsEngine() {
        this.hashFiles("data/stats/armor", this._armorFiles);
        this.hashFiles("data/stats/weapon", this._weaponFiles);
        this.hashFiles("data/stats/skills", this._skillFiles);
    }

    private void hashFiles(String dirname, List<File> hash) {
        File[] files;
        File dir = new File(Config.DATAPACK_ROOT, dirname);
        if (!dir.exists()) {
            _log.config("Dir " + dir.getAbsolutePath() + " not exists");
            return;
        }
        for (File f : files = dir.listFiles()) {
            if (!f.getName().endsWith(".xml")) continue;
            hash.add(f);
        }
    }

    public List<L2Skill> loadSkills(File file) {
        if (file == null) {
            _log.config("File not found: " + file.getName());
            return null;
        }
        DocumentSkill doc = new DocumentSkill(file);
        doc.parse();
        return doc.getSkills();
    }

    public void loadAllSkills(HashMap<Integer, L2Skill> allSkills) {
        int count = 0;
        for (File file : this._skillFiles) {
            List<L2Skill> s = this.loadSkills(file);
            if (s == null) continue;
            for (L2Skill skill : s) {
                allSkills.put(skill.getId() * 100 + skill.getLevel(), skill);
                ++count;
            }
        }
        _log.config("SkillsEngine: Loaded " + count + " Skill templates from XML files.");
    }

    public List<L2Armor> loadArmors(HashMap<Integer, Item> armorData) {
        LinkedList<L2Armor> list = new LinkedList<L2Armor>();
        for (L2Item item : this.loadData(armorData, this._armorFiles)) {
            list.add((L2Armor)item);
        }
        return list;
    }

    public List<L2Weapon> loadWeapons(HashMap<Integer, Item> weaponData) {
        LinkedList<L2Weapon> list = new LinkedList<L2Weapon>();
        for (L2Item item : this.loadData(weaponData, this._weaponFiles)) {
            list.add((L2Weapon)item);
        }
        return list;
    }

    public List<L2EtcItem> loadItems(HashMap<Integer, Item> itemData) {
        LinkedList<L2EtcItem> list = new LinkedList<L2EtcItem>();
        for (L2Item l2Item : this.loadData(itemData, this._etcitemFiles)) {
            list.add((L2EtcItem)l2Item);
        }
        if (list.size() == 0) {
            for (Item item : itemData.values()) {
                list.add(new L2EtcItem((L2EtcItemType)item.type, item.set));
            }
        }
        return list;
    }

    public List<L2Item> loadData(HashMap<Integer, Item> itemData, List<File> files) {
        LinkedList<L2Item> list = new LinkedList<L2Item>();
        for (File f : files) {
            DocumentItem document = new DocumentItem(itemData, f);
            document.parse();
            list.addAll(document.getItemList());
        }
        return list;
    }
}

