/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import java.io.IOException;
import java.util.logging.Level;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.handler.SkillHandler;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.templates.StatsSet;

public class L2SkillNegate
extends L2Skill {
    private final String[] _negateStats;
    private final float _negatePower;

    public L2SkillNegate(StatsSet set2) {
        super(set2);
        this._negateStats = set2.getString("negateStats", "").split(" ");
        this._negatePower = set2.getFloat("negatePower", 0.0f);
    }

    public void useSkill(L2Character caster, L2Object[] targets) {
        for (int index = 0; index < targets.length; ++index) {
            if (!(targets[index] instanceof L2Character)) continue;
            L2Character target = (L2Character)targets[index];
            for (String stat : this._negateStats) {
                if ((stat = stat.toLowerCase().intern()) == "stun") {
                    this.negateStun(target);
                }
                if (stat == "sleep") {
                    this.negateSleep(target);
                }
                if (stat == "confusion") {
                    this.negateConfusion(target);
                }
                if (stat == "mute") {
                    this.negateMute(target);
                }
                if (stat == "fear") {
                    this.negateFere(target);
                }
                if (stat == "poison") {
                    this.negatePoison(target, this._negatePower);
                }
                if (stat == "bleed") {
                    this.negateBleed(target, this._negatePower);
                }
                if (stat == "paralyze") {
                    this.negateParalyze(target, this._negatePower);
                }
                if (stat != "heal") continue;
                ISkillHandler handler = SkillHandler.getInstance().getSkillHandler(L2Skill.SkillType.HEAL);
                if (handler == null) {
                    _log.severe("Couldn't find skill handler for HEAL.");
                    continue;
                }
                L2Object[] tgts = new L2Object[]{target};
                try {
                    handler.useSkill(caster, this, tgts);
                }
                catch (IOException e) {
                    _log.log(Level.WARNING, "", e);
                }
            }
        }
    }

    private void negateBleed(L2Character target, double power) {
        L2Effect[] effects;
        for (L2Effect e : effects = target.getAllEffects()) {
            if (e.getSkill().getSkillType() != L2Skill.SkillType.BLEED || !(e.getSkill().getPower() <= power)) continue;
            e.exit();
        }
    }

    private void negatePoison(L2Character target, double power) {
        L2Effect[] effects;
        for (L2Effect e : effects = target.getAllEffects()) {
            if (e.getSkill().getSkillType() != L2Skill.SkillType.POISON || !(e.getSkill().getPower() <= power)) continue;
            e.exit();
        }
    }

    private void negateFere(L2Character target) {
        L2Effect[] effects;
        for (L2Effect e : effects = target.getAllEffects()) {
            if (e.getSkill().getSkillType() != L2Skill.SkillType.FEAR) continue;
            e.exit();
        }
    }

    private void negateMute(L2Character target) {
        L2Effect[] effects;
        for (L2Effect e : effects = target.getAllEffects()) {
            if (e.getSkill().getSkillType() != L2Skill.SkillType.MUTE) continue;
            e.exit();
        }
    }

    private void negateConfusion(L2Character target) {
        L2Effect[] effects;
        for (L2Effect e : effects = target.getAllEffects()) {
            if (e.getSkill().getSkillType() != L2Skill.SkillType.CONFUSION) continue;
            e.exit();
        }
    }

    private void negateSleep(L2Character target) {
        L2Effect[] effects;
        for (L2Effect e : effects = target.getAllEffects()) {
            if (e.getSkill().getSkillType() != L2Skill.SkillType.SLEEP) continue;
            e.exit();
        }
    }

    private void negateStun(L2Character target) {
        L2Effect[] effects;
        for (L2Effect e : effects = target.getAllEffects()) {
            if (e.getSkill().getSkillType() != L2Skill.SkillType.STUN) continue;
            e.exit();
        }
    }

    private void negateParalyze(L2Character target, double power) {
        L2Effect[] effects;
        for (L2Effect e : effects = target.getAllEffects()) {
            if (e.getSkill().getSkillType() != L2Skill.SkillType.PARALYZE || !(e.getSkill().getPower() <= power)) continue;
            e.exit();
        }
    }
}

