/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.Formulas;
import net.sf.l2j.gameserver.templates.StatsSet;

public class L2SkillElemental
extends L2Skill {
    private final int[] seeds = new int[3];
    private final boolean seed_any;

    public L2SkillElemental(StatsSet set2) {
        super(set2);
        this.seeds[0] = set2.getInteger("seed1", 0);
        this.seeds[1] = set2.getInteger("seed2", 0);
        this.seeds[2] = set2.getInteger("seed3", 0);
        this.seed_any = set2.getInteger("seed_any", 0) == 1;
    }

    public void useSkill(L2Character activeChar, L2Object[] targets) {
        if (activeChar.isAlikeDead()) {
            return;
        }
        boolean ss = false;
        boolean bss = false;
        L2ItemInstance weaponInst = activeChar.getActiveWeaponInstance();
        if (activeChar instanceof L2PcInstance && weaponInst == null) {
            SystemMessage sm2 = new SystemMessage(614);
            sm2.addString("You must equip one weapon before cast spell.");
            activeChar.sendPacket(sm2);
            return;
        }
        if (weaponInst != null) {
            if (weaponInst.getChargedSpiritshot() == 2) {
                bss = true;
                weaponInst.setChargedSpiritshot(0);
            } else if (weaponInst.getChargedSpiritshot() == 1) {
                ss = true;
                weaponInst.setChargedSpiritshot(0);
            }
        }
        for (int index = 0; index < targets.length; ++index) {
            int i;
            L2Character target = (L2Character)targets[index];
            if (target.isAlikeDead()) continue;
            boolean charged = true;
            if (!this.seed_any) {
                for (i = 0; i < this.seeds.length; ++i) {
                    L2Effect e;
                    if (this.seeds[i] == 0 || (e = target.getEffect(this.seeds[i])) != null && e.getInUse()) continue;
                    charged = false;
                    break;
                }
            } else {
                charged = false;
                for (i = 0; i < this.seeds.length; ++i) {
                    L2Effect e;
                    if (this.seeds[i] == 0 || (e = target.getEffect(this.seeds[i])) == null || !e.getInUse()) continue;
                    charged = true;
                    break;
                }
            }
            if (!charged) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Target is not charged by elements.");
                activeChar.sendPacket(sm);
                continue;
            }
            boolean mcrit = Formulas.getInstance().calcMCrit(activeChar.getMCriticalHit(target, this));
            int damage = (int)Formulas.getInstance().calcMagicDam(activeChar, target, this, ss, bss, mcrit);
            target.reduceCurrentHp(damage, activeChar);
            if (activeChar instanceof L2PcInstance) {
                SystemMessage sm = new SystemMessage(35);
                sm.addNumber(damage);
                activeChar.sendPacket(sm);
            }
            target.stopEffect(this.getId());
            if (target.getEffect(this.getId()) != null) {
                target.removeEffect(target.getEffect(this.getId()));
            }
            this.getEffects(activeChar, target);
        }
    }
}

