/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.skills.Env;
import net.sf.l2j.gameserver.skills.Func;
import net.sf.l2j.gameserver.skills.Lambda;
import net.sf.l2j.gameserver.skills.Stats;

public class FuncEnchant
extends Func {
    private final Lambda _lambda;

    public FuncEnchant(Stats stat, int order, Object owner, Lambda lambda) {
        super(stat, order, owner);
        this._lambda = lambda;
    }

    public void calc(Env env) {
        if (this._cond != null && !this._cond.test(env)) {
            return;
        }
        L2ItemInstance item = (L2ItemInstance)this._funcOwner;
        int cristall = item.getItem().getCrystalType();
        if (cristall == 0) {
            return;
        }
        int enchant = item.getEnchantLevel();
        if (enchant < 4) {
            env.value += (double)(4 * enchant);
            return;
        }
        switch (item.getItem().getCrystalType()) {
            case 4: {
                env.value += (double)(12 + 8 * item.getEnchantLevel());
                return;
            }
            case 3: {
                env.value += (double)(9 + 6 * item.getEnchantLevel());
                return;
            }
            case 2: {
                env.value += (double)(9 + 6 * item.getEnchantLevel());
                return;
            }
            case 1: {
                env.value += (double)(6 + 4 * item.getEnchantLevel());
                return;
            }
            case 5: {
                env.value += (double)(15 + 10 * item.getEnchantLevel());
                return;
            }
        }
    }
}

