/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import java.util.Random;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2DoorInstance;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2PlayableInstance;
import net.sf.l2j.gameserver.model.L2RaidBossInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2Summon;
import net.sf.l2j.gameserver.skills.Calculator;
import net.sf.l2j.gameserver.skills.ConditionPlayerState;
import net.sf.l2j.gameserver.skills.ConditionUsingItemType;
import net.sf.l2j.gameserver.skills.Env;
import net.sf.l2j.gameserver.skills.Func;
import net.sf.l2j.gameserver.skills.Stats;
import net.sf.l2j.gameserver.templates.L2PcTemplate;
import net.sf.l2j.gameserver.templates.L2Weapon;
import net.sf.l2j.gameserver.templates.L2WeaponType;

public final class Formulas {
    private static final int HP_REGENERATE_PERIOD = 3000;
    private static final double[] WITpolynomRuben;
    private static final double[] MENpolynomRuben;
    private static final double[] INTpolynomRuben;
    private static final double[] STRpolynomRuben;
    private static final double[] DEXpolynomRuben;
    private static final double[] CONpolynomRuben;
    protected static final double[] WITbonus;
    protected static final double[] MENbonus;
    protected static final double[] INTbonus;
    protected static final double[] STRbonus;
    protected static final double[] DEXbonus;
    protected static final double[] CONbonus;
    private static final Formulas _instance;
    private static final Random _rnd;

    private static double polynom(double[] p, int idx) {
        double val = 0.0;
        for (int i = 0; i < p.length; ++i) {
            val *= (double)idx;
            val += p[i];
        }
        return val;
    }

    public static Formulas getInstance() {
        return _instance;
    }

    private Formulas() {
    }

    public int getRegeneratePeriod(L2Character cha) {
        if (cha instanceof L2DoorInstance) {
            return 300000;
        }
        return 3000;
    }

    public Calculator[] getStdNPCCalculators() {
        Calculator[] std = new Calculator[Stats.NUM_STATS];
        std[Stats.ACCURACY_COMBAT.ordinal()] = new Calculator();
        std[Stats.ACCURACY_COMBAT.ordinal()].addFunc(FuncAtkAccuracy.getInstance());
        std[Stats.EVASION_RATE.ordinal()] = new Calculator();
        std[Stats.EVASION_RATE.ordinal()].addFunc(FuncAtkEvasion.getInstance());
        return std;
    }

    public void addFuncsToNewCharacter(L2Character cha) {
        if (cha instanceof L2PcInstance) {
            cha.addStatFunc(FuncMaxHpAdd.getInstance());
            cha.addStatFunc(FuncMaxHpMul.getInstance());
            cha.addStatFunc(FuncMaxMpAdd.getInstance());
            cha.addStatFunc(FuncMaxMpMul.getInstance());
            cha.addStatFunc(FuncMultRegenResting.getInstance(Stats.REGENERATE_HP_RATE));
            cha.addStatFunc(FuncMultRegenResting.getInstance(Stats.REGENERATE_MP_RATE));
            cha.addStatFunc(FuncBowAtkRange.getInstance());
            cha.addStatFunc(FuncMultLevelMod.getInstance(Stats.POWER_ATTACK));
            cha.addStatFunc(FuncMultLevelMod.getInstance(Stats.POWER_DEFENCE));
            cha.addStatFunc(FuncMultLevelMod.getInstance(Stats.MAGIC_DEFENCE));
            cha.addStatFunc(FuncPAtkMod.getInstance());
            cha.addStatFunc(FuncMAtkMod.getInstance());
            cha.addStatFunc(FuncAtkCritical.getInstance());
            cha.addStatFunc(FuncAtkAccuracy.getInstance());
            cha.addStatFunc(FuncAtkEvasion.getInstance());
            cha.addStatFunc(FuncPAtkSpeed.getInstance());
            cha.addStatFunc(FuncMAtkSpeed.getInstance());
            cha.addStatFunc(FuncMoveSpeed.getInstance());
            cha.addStatFunc(FuncHennaSTR.getInstance());
            cha.addStatFunc(FuncHennaDEX.getInstance());
            cha.addStatFunc(FuncHennaINT.getInstance());
            cha.addStatFunc(FuncHennaMEN.getInstance());
            cha.addStatFunc(FuncHennaCON.getInstance());
            cha.addStatFunc(FuncHennaWIT.getInstance());
        } else if (cha instanceof L2Summon) {
            cha.addStatFunc(FuncMultRegenResting.getInstance(Stats.REGENERATE_HP_RATE));
            cha.addStatFunc(FuncMultRegenResting.getInstance(Stats.REGENERATE_MP_RATE));
            cha.addStatFunc(FuncAtkCritical.getInstance());
            cha.addStatFunc(FuncAtkAccuracy.getInstance());
            cha.addStatFunc(FuncAtkEvasion.getInstance());
        }
    }

    public final double calcHpRegen(L2Character cha) {
        double init = (float)cha.getMaxHp() * cha.getTemplate().baseHpReg;
        return cha.calcStat(Stats.REGENERATE_HP_RATE, init, null, null);
    }

    public final double calcMpRegen(L2Character cha) {
        double init = (float)cha.getMaxMp() * cha.getTemplate().baseMpReg;
        return cha.calcStat(Stats.REGENERATE_MP_RATE, init, null, null);
    }

    public final double calcCpRegen(L2Character cha) {
        double init = (float)cha.getMaxHp() * cha.getTemplate().baseHpReg;
        return cha.calcStat(Stats.REGENERATE_HP_RATE, init, null, null);
    }

    public final double calcPhysDam(L2Character attacker, L2Character target, L2Skill skill, boolean shld, boolean crit, boolean dual, boolean ss) {
        int rDamage;
        int tLevel;
        int cLevel;
        double damage = attacker.getPAtk(target);
        double defence = target.getPDef(attacker);
        L2Weapon weapon = attacker.getActiveWeaponItem();
        if (weapon != null) {
            switch (weapon.getItemType()) {
                case BOW: {
                    defence = target.calcStat(Stats.BOW_WPN_RES, defence, target, null);
                    break;
                }
                case BLUNT: {
                    defence = target.calcStat(Stats.BLUNT_WPN_RES, defence, target, null);
                    break;
                }
                case DAGGER: {
                    defence = target.calcStat(Stats.DAGGER_WPN_RES, defence, target, null);
                    break;
                }
                case DUAL: {
                    defence = target.calcStat(Stats.DUAL_WPN_RES, defence, target, null);
                    break;
                }
                case DUALFIST: {
                    defence = target.calcStat(Stats.DUALFIST_WPN_RES, defence, target, null);
                    break;
                }
                case ETC: {
                    defence = target.calcStat(Stats.ETC_WPN_RES, defence, target, null);
                    break;
                }
                case FIST: {
                    defence = target.calcStat(Stats.FIST_WPN_RES, defence, target, null);
                    break;
                }
                case POLE: {
                    defence = target.calcStat(Stats.POLE_WPN_RES, defence, target, null);
                    break;
                }
                case SWORD: {
                    defence = target.calcStat(Stats.SWORD_WPN_RES, defence, target, null);
                }
            }
        }
        if (skill != null) {
            damage += skill.getPower();
        }
        if (ss) {
            damage = skill != null ? (damage *= 1.44) : (damage *= 2.0);
        }
        if (crit) {
            damage += attacker.getCriticalDmg(target, damage);
        }
        if (dual) {
            damage /= 1.5;
        }
        if (shld && !Config.ALT_GAME_SHIELD_BLOCKS) {
            defence += (double)target.getShldDef();
        }
        damage = damage * 70.0 / defence;
        damage += _rnd.nextDouble() * (double)attacker.getRandomDamage(target);
        if (shld && Config.ALT_GAME_SHIELD_BLOCKS && (damage -= (double)target.getShldDef()) < 0.0) {
            damage = 0.0;
        }
        if (target instanceof L2RaidBossInstance) {
            cLevel = attacker.getLevel();
            tLevel = target.getLevel();
            rDamage = 1;
            if (cLevel > tLevel) {
                rDamage = cLevel - tLevel;
                if (rDamage > 9) {
                    damage /= (double)rDamage;
                }
                if (damage < 1.0) {
                    damage = 1.0;
                }
            }
        }
        if (target instanceof L2PlayableInstance && attacker instanceof L2RaidBossInstance) {
            cLevel = attacker.getLevel();
            tLevel = target.getLevel();
            rDamage = 1;
            if (cLevel < tLevel && (rDamage = tLevel - cLevel) > 9) {
                damage *= (double)rDamage;
            }
        }
        if (attacker.isUndead()) {
            L2Skill[] skills = target.getAllSkills();
            for (int i = 0; i < skills.length; ++i) {
                if (skills[i].getId() != 197) continue;
                damage /= skills[i].getPower();
            }
            L2Effect[] effects = target.getAllEffects();
            for (int i = 0; i < effects.length; ++i) {
                if (effects[i].getSkill().getId() != 270) continue;
                damage /= effects[i].getSkill().getPower();
            }
        }
        if (damage > 0.0 && damage < 1.0) {
            damage = 1.0;
        } else if (damage < 0.0) {
            damage = 0.0;
        }
        return damage;
    }

    public final double calcMagicDam(L2Character attacker, L2Character target, L2Skill skill, boolean ss, boolean bss, boolean mcrit) {
        int rDamage;
        int tLevel;
        int cLevel;
        double mAtk = attacker.getMAtk(target, skill);
        double mDef = target.getMDef(attacker, skill);
        if (bss) {
            mAtk *= 4.0;
        } else if (ss) {
            mAtk *= 2.0;
        }
        double damage = 91.0 * skill.getPower() * Math.sqrt(mAtk) / mDef;
        if (mcrit) {
            damage *= 2.0;
        }
        if (target instanceof L2RaidBossInstance) {
            cLevel = attacker.getLevel();
            tLevel = target.getLevel();
            rDamage = 1;
            if (cLevel > tLevel) {
                rDamage = cLevel - tLevel;
                if (rDamage > 9) {
                    damage /= (double)rDamage;
                }
                if (damage < 1.0) {
                    damage = 1.0;
                }
            }
        }
        if (target instanceof L2PlayableInstance && attacker instanceof L2RaidBossInstance) {
            cLevel = attacker.getLevel();
            tLevel = target.getLevel();
            rDamage = 1;
            if (cLevel < tLevel && (rDamage = tLevel - cLevel) > 9) {
                damage *= (double)rDamage;
            }
        }
        return damage;
    }

    public final boolean calcCrit(double rate) {
        int critHit = _rnd.nextInt(1000);
        return rate > (double)critHit;
    }

    public final boolean calcMCrit(double mRate) {
        int mcritHit = _rnd.nextInt(1000);
        return mRate > (double)mcritHit;
    }

    public final boolean calcAtkBreak(L2Character cha, double cancel) {
        L2Weapon wpn;
        if (Config.ALT_GAME_CANCEL_ALL && cha.isAttackingNow()) {
            return cancel > (double)_rnd.nextInt(100);
        }
        if (Config.ALT_GAME_CANCEL_CAST && cha.isCastingNow()) {
            return cancel > (double)_rnd.nextInt(100);
        }
        if (Config.ALT_GAME_CANCEL_BOW && cha.isAttackingNow() && (wpn = cha.getActiveWeaponItem()) != null && wpn.getItemType() == L2WeaponType.BOW) {
            return cancel > (double)_rnd.nextInt(100);
        }
        return false;
    }

    public final int calcPAtkSpd(L2Character attacker, L2Character target, double rate) {
        return (int)(3.0 * Math.pow(rate, 2.0) / 2000.0 - 4.0 * rate + 2700.0);
    }

    public final int calcMAtkSpd(L2Character attacker, L2Character target, L2Skill skill, double skillTime) {
        if (skill.isMagic()) {
            return (int)(skillTime * 333.0 / (double)attacker.getMAtkSpd());
        }
        return (int)(skillTime * 333.0 / (double)attacker.getPAtkSpd());
    }

    public boolean calcHitMiss(L2Character attacker, L2Character target) {
        int evas_target;
        int acc_attacker = attacker.getAccuracy();
        int d = 85 + acc_attacker - (evas_target = target.getEvasionRate(attacker));
        return d < _rnd.nextInt(100);
    }

    public boolean calcShldUse(L2Character attacker, L2Character target) {
        double shldRate = target.calcStat(Stats.SHIELD_RATE, 0.0, attacker, null);
        return shldRate > (double)_rnd.nextInt(80);
    }

    public boolean calcMagicAffected(L2Character actor, L2Character target, L2Skill skill) {
        double defence = 0.0;
        if (skill.isActive() && skill.isOffensive()) {
            defence = target.getMDef(actor, skill);
        }
        double attack = 2 * actor.getMAtk(target, skill);
        double d = attack - defence;
        d /= attack + defence;
        return (d += 0.5 * _rnd.nextGaussian()) > 0.0;
    }

    public boolean calcSkillSuccess(L2Character player, L2Character target, L2Skill skill) {
        L2Skill.SkillType type = skill.getSkillType();
        boolean success = false;
        int rate = 0;
        int check = _rnd.nextInt(100);
        int skillPower = (int)skill.getPower() * 2;
        int skillLevelMod = (skill.getLevel() + 3) * 60;
        switch (type) {
            case STUN: {
                rate = player.getLevel() - target.getLevel() + skillLevelMod / target.getCON();
                break;
            }
            case SLEEP: {
                rate = player.getLevel() - target.getLevel() + skillLevelMod / target.getWIT();
                break;
            }
            case ROOT: {
                rate = player.getLevel() - target.getLevel() + skillLevelMod / target.getDEX();
                break;
            }
            default: {
                rate = player.getLevel() - target.getLevel() + skillPower / target.getCON();
            }
        }
        if (rate > 100) {
            rate = 100;
        } else if (rate < 0) {
            rate = 0;
        }
        success = check <= rate;
        return success;
    }

    public boolean calculateUnlockChance(L2Skill skill) {
        int level = skill.getLevel();
        int chance = 0;
        switch (level) {
            case 1: {
                chance = 30;
                break;
            }
            case 2: {
                chance = 50;
                break;
            }
            case 3: {
                chance = 75;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                chance = 100;
            }
        }
        return L2Character.getRnd().nextInt(120) <= chance;
    }

    static {
        int i;
        WITpolynomRuben = new double[]{9.92548106895706E-11, -1.74321566019637E-8, 1.62831147164817E-6, -5.69708354675472E-5, 0.00176297334574271, 0.00702047716898244, 0.40418544239349596};
        MENpolynomRuben = new double[]{6.55560506205942E-13, -1.86382246837638E-10, 2.00181636225728E-8, -7.21083753683517E-7, 6.32893046379994E-5, 0.0100292663412997, 0.9989824863185204};
        INTpolynomRuben = new double[]{1.14709015313616E-12, -2.95539170117078E-10, 3.70899733476748E-8, -1.0695713178072E-6, 1.52088680219214E-4, 0.0100503287843296, 0.539230992792213};
        STRpolynomRuben = new double[]{1.16135122081151E-13, -4.62705264321671E-11, 1.16589347868518E-8, -4.61010018318282E-7, 1.16867092599689E-4, 0.0094339883191995, 0.7099624265579301};
        DEXpolynomRuben = new double[]{-2.18802347456124E-13, 7.36326102324656E-11, -9.17638811630965E-9, 6.42979494626824E-7, 2.19770577253076E-5, 0.00753087829071482, 0.841705354174224};
        CONpolynomRuben = new double[]{-1.71860808123223E-14, 2.47931160956514E-11, -8.62836686242099E-10, 5.61696618376353E-7, 9.10664810051045E-5, 0.0123675715691994, 0.8303681251091279};
        WITbonus = new double[100];
        MENbonus = new double[100];
        INTbonus = new double[100];
        STRbonus = new double[100];
        DEXbonus = new double[100];
        CONbonus = new double[100];
        for (i = 0; i < WITbonus.length; ++i) {
            Formulas.WITbonus[i] = Formulas.polynom(WITpolynomRuben, i);
        }
        for (i = 0; i < MENbonus.length; ++i) {
            Formulas.MENbonus[i] = Formulas.polynom(MENpolynomRuben, i);
        }
        for (i = 0; i < INTbonus.length; ++i) {
            Formulas.INTbonus[i] = Formulas.polynom(INTpolynomRuben, i);
        }
        for (i = 0; i < STRbonus.length; ++i) {
            Formulas.STRbonus[i] = Formulas.polynom(STRpolynomRuben, i);
        }
        for (i = 0; i < DEXbonus.length; ++i) {
            Formulas.DEXbonus[i] = Formulas.polynom(DEXpolynomRuben, i);
        }
        for (i = 0; i < CONbonus.length; ++i) {
            Formulas.CONbonus[i] = Formulas.polynom(CONpolynomRuben, i);
        }
        _instance = new Formulas();
        _rnd = new Random();
    }

    static class FuncMaxMpMul
    extends Func {
        static final FuncMaxMpMul _fmmm_instance = new FuncMaxMpMul();

        static Func getInstance() {
            return _fmmm_instance;
        }

        private FuncMaxMpMul() {
            super(Stats.MAX_MP, 32, null);
        }

        public void calc(Env env) {
            L2PcInstance p = (L2PcInstance)env._player;
            env.value *= MENbonus[p.getMEN()];
        }
    }

    static class FuncMaxMpAdd
    extends Func {
        static final FuncMaxMpAdd _fmma_instance = new FuncMaxMpAdd();

        static Func getInstance() {
            return _fmma_instance;
        }

        private FuncMaxMpAdd() {
            super(Stats.MAX_MP, 16, null);
        }

        public void calc(Env env) {
            L2PcTemplate t = (L2PcTemplate)env._player.getTemplate();
            int lvl = env._player.getLevel() - t.classBaseLevel;
            double mpmod = t.lvlMpMod * (float)lvl;
            double mpmax = ((double)t.lvlMpAdd + mpmod) * (double)lvl;
            double mpmin = (double)(t.lvlMpAdd * (float)lvl) + mpmod;
            env.value += (mpmax + mpmin) / 2.0;
        }
    }

    static class FuncMaxHpMul
    extends Func {
        static final FuncMaxHpMul _fmhm_instance = new FuncMaxHpMul();

        static Func getInstance() {
            return _fmhm_instance;
        }

        private FuncMaxHpMul() {
            super(Stats.MAX_HP, 32, null);
        }

        public void calc(Env env) {
            L2PcInstance p = (L2PcInstance)env._player;
            env.value *= CONbonus[p.getCON()];
        }
    }

    static class FuncMaxHpAdd
    extends Func {
        static final FuncMaxHpAdd _fmha_instance = new FuncMaxHpAdd();

        static Func getInstance() {
            return _fmha_instance;
        }

        private FuncMaxHpAdd() {
            super(Stats.MAX_HP, 16, null);
        }

        public void calc(Env env) {
            L2PcTemplate t = (L2PcTemplate)env._player.getTemplate();
            int lvl = env._player.getLevel() - t.classBaseLevel;
            double hpmod = t.lvlHpMod * (float)lvl;
            double hpmax = ((double)t.lvlHpAdd + hpmod) * (double)lvl;
            double hpmin = (double)(t.lvlHpAdd * (float)lvl) + hpmod;
            env.value += (hpmax + hpmin) / 2.0;
        }
    }

    static class FuncHennaWIT
    extends Func {
        static final FuncHennaWIT _fh_instance = new FuncHennaWIT();

        static Func getInstance() {
            return _fh_instance;
        }

        private FuncHennaWIT() {
            super(Stats.STAT_WIT, 16, null);
        }

        public void calc(Env env) {
            L2PcInstance pc = (L2PcInstance)env._player;
            if (pc != null) {
                env.value += (double)pc.getHennaStatWIT();
            }
        }
    }

    static class FuncHennaCON
    extends Func {
        static final FuncHennaCON _fh_instance = new FuncHennaCON();

        static Func getInstance() {
            return _fh_instance;
        }

        private FuncHennaCON() {
            super(Stats.STAT_CON, 16, null);
        }

        public void calc(Env env) {
            L2PcInstance pc = (L2PcInstance)env._player;
            if (pc != null) {
                env.value += (double)pc.getHennaStatCON();
            }
        }
    }

    static class FuncHennaMEN
    extends Func {
        static final FuncHennaMEN _fh_instance = new FuncHennaMEN();

        static Func getInstance() {
            return _fh_instance;
        }

        private FuncHennaMEN() {
            super(Stats.STAT_MEN, 16, null);
        }

        public void calc(Env env) {
            L2PcInstance pc = (L2PcInstance)env._player;
            if (pc != null) {
                env.value += (double)pc.getHennaStatMEN();
            }
        }
    }

    static class FuncHennaINT
    extends Func {
        static final FuncHennaINT _fh_instance = new FuncHennaINT();

        static Func getInstance() {
            return _fh_instance;
        }

        private FuncHennaINT() {
            super(Stats.STAT_INT, 16, null);
        }

        public void calc(Env env) {
            L2PcInstance pc = (L2PcInstance)env._player;
            if (pc != null) {
                env.value += (double)pc.getHennaStatINT();
            }
        }
    }

    static class FuncHennaDEX
    extends Func {
        static final FuncHennaDEX _fh_instance = new FuncHennaDEX();

        static Func getInstance() {
            return _fh_instance;
        }

        private FuncHennaDEX() {
            super(Stats.STAT_DEX, 16, null);
        }

        public void calc(Env env) {
            L2PcInstance pc = (L2PcInstance)env._player;
            if (pc != null) {
                env.value += (double)pc.getHennaStatDEX();
            }
        }
    }

    static class FuncHennaSTR
    extends Func {
        static final FuncHennaSTR _fh_instance = new FuncHennaSTR();

        static Func getInstance() {
            return _fh_instance;
        }

        private FuncHennaSTR() {
            super(Stats.STAT_STR, 16, null);
        }

        public void calc(Env env) {
            L2PcInstance pc = (L2PcInstance)env._player;
            if (pc != null) {
                env.value += (double)pc.getHennaStatSTR();
            }
        }
    }

    static class FuncMAtkSpeed
    extends Func {
        static final FuncMAtkSpeed _fas_instance = new FuncMAtkSpeed();

        static Func getInstance() {
            return _fas_instance;
        }

        private FuncMAtkSpeed() {
            super(Stats.MAGIC_ATTACK_SPEED, 32, null);
        }

        public void calc(Env env) {
            L2PcInstance p = (L2PcInstance)env._player;
            env.value *= WITbonus[p.getWIT()];
        }
    }

    static class FuncPAtkSpeed
    extends Func {
        static final FuncPAtkSpeed _fas_instance = new FuncPAtkSpeed();

        static Func getInstance() {
            return _fas_instance;
        }

        private FuncPAtkSpeed() {
            super(Stats.POWER_ATTACK_SPEED, 32, null);
        }

        public void calc(Env env) {
            L2PcInstance p = (L2PcInstance)env._player;
            env.value *= DEXbonus[p.getDEX()];
        }
    }

    static class FuncMoveSpeed
    extends Func {
        static final FuncMoveSpeed _fms_instance = new FuncMoveSpeed();

        static Func getInstance() {
            return _fms_instance;
        }

        private FuncMoveSpeed() {
            super(Stats.RUN_SPEED, 48, null);
        }

        public void calc(Env env) {
            L2PcInstance p = (L2PcInstance)env._player;
            env.value *= DEXbonus[p.getDEX()];
        }
    }

    static class FuncAtkCritical
    extends Func {
        static final FuncAtkCritical _fac_instance = new FuncAtkCritical();

        static Func getInstance() {
            return _fac_instance;
        }

        private FuncAtkCritical() {
            super(Stats.CRITICAL_RATE, 48, null);
        }

        public void calc(Env env) {
            L2Character p = env._player;
            env.value *= DEXbonus[p.getDEX()];
            env.value *= 10.0;
        }
    }

    static class FuncAtkEvasion
    extends Func {
        static final FuncAtkEvasion _fae_instance = new FuncAtkEvasion();

        static Func getInstance() {
            return _fae_instance;
        }

        private FuncAtkEvasion() {
            super(Stats.EVASION_RATE, 16, null);
        }

        public void calc(Env env) {
            L2Character p = env._player;
            env.value += Math.sqrt(p.getDEX()) * 6.0;
            env.value += (double)p.getLevel();
        }
    }

    static class FuncAtkAccuracy
    extends Func {
        static final FuncAtkAccuracy _faa_instance = new FuncAtkAccuracy();

        static Func getInstance() {
            return _faa_instance;
        }

        private FuncAtkAccuracy() {
            super(Stats.ACCURACY_COMBAT, 16, null);
        }

        public void calc(Env env) {
            L2Character p = env._player;
            env.value += Math.sqrt(p.getDEX()) * 6.0;
            env.value += (double)p.getLevel();
        }
    }

    static class FuncBowAtkRange
    extends Func {
        private static final FuncBowAtkRange _fbar_instance = new FuncBowAtkRange();

        static Func getInstance() {
            return _fbar_instance;
        }

        private FuncBowAtkRange() {
            super(Stats.POWER_ATTACK_RANGE, 16, null);
            this.setCondition(new ConditionUsingItemType(L2WeaponType.BOW.mask()));
        }

        public void calc(Env env) {
            if (!this._cond.test(env)) {
                return;
            }
            env.value += 450.0;
        }
    }

    static class FuncPAtkMod
    extends Func {
        static final FuncPAtkMod _fpa_instance = new FuncPAtkMod();

        static Func getInstance() {
            return _fpa_instance;
        }

        private FuncPAtkMod() {
            super(Stats.POWER_ATTACK, 48, null);
        }

        public void calc(Env env) {
            L2PcInstance p = (L2PcInstance)env._player;
            env.value *= STRbonus[p.getSTR()];
        }
    }

    static class FuncMultRegenResting
    extends Func {
        static final FuncMultRegenResting[] _instancies = new FuncMultRegenResting[Stats.NUM_STATS];

        static Func getInstance(Stats stat) {
            int pos = stat.ordinal();
            if (_instancies[pos] == null) {
                FuncMultRegenResting._instancies[pos] = new FuncMultRegenResting(stat);
            }
            return _instancies[pos];
        }

        private FuncMultRegenResting(Stats stat) {
            super(stat, 32, null);
            this.setCondition(new ConditionPlayerState(ConditionPlayerState.CheckPlayerState.RESTING, true));
        }

        public void calc(Env env) {
            if (!this._cond.test(env)) {
                return;
            }
            env.value *= 1.45;
        }
    }

    static class FuncMAtkMod
    extends Func {
        static final FuncMAtkMod _fma_instance = new FuncMAtkMod();

        static Func getInstance() {
            return _fma_instance;
        }

        private FuncMAtkMod() {
            super(Stats.MAGIC_ATTACK, 48, null);
        }

        public void calc(Env env) {
            L2PcInstance p = (L2PcInstance)env._player;
            double ib = INTbonus[p.getINT()];
            double lvlb = env._player.getLevelMod();
            env.value *= lvlb * lvlb * (ib * ib);
        }
    }

    static class FuncMultLevelMod
    extends Func {
        static final FuncMultLevelMod[] _instancies = new FuncMultLevelMod[Stats.NUM_STATS];

        static Func getInstance(Stats stat) {
            int pos = stat.ordinal();
            if (_instancies[pos] == null) {
                FuncMultLevelMod._instancies[pos] = new FuncMultLevelMod(stat);
            }
            return _instancies[pos];
        }

        private FuncMultLevelMod(Stats stat) {
            super(stat, 48, null);
        }

        public void calc(Env env) {
            env.value *= env._player.getLevelMod();
        }
    }

    static class FuncAddLevel3
    extends Func {
        static final FuncAddLevel3[] _instancies = new FuncAddLevel3[Stats.NUM_STATS];

        static Func getInstance(Stats stat) {
            int pos = stat.ordinal();
            if (_instancies[pos] == null) {
                FuncAddLevel3._instancies[pos] = new FuncAddLevel3(stat);
            }
            return _instancies[pos];
        }

        private FuncAddLevel3(Stats stat) {
            super(stat, 16, null);
        }

        public void calc(Env env) {
            env.value += (double)(env._player.getLevel() / 3);
        }
    }
}

