/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.serverpackets.Revive;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.EffectTemplate;
import net.sf.l2j.gameserver.skills.Env;

final class EffectFakeDeath
extends L2Effect {
    public EffectFakeDeath(Env env, EffectTemplate template) {
        super(env, template);
    }

    public L2Effect.EffectType getEffectType() {
        return L2Effect.EffectType.FAKE_DEATH;
    }

    public void onStart() {
        this.getEffected().startFakeDeath();
    }

    public void onExit() {
        this.getEffected().stopFakeDeath(this);
        Revive revive = new Revive(this.getEffected());
        this.getEffected().broadcastPacket(revive);
    }

    public boolean onActionTime() {
        if (this.getEffected().isDead()) {
            return false;
        }
        double manaDam = this.calc();
        if (manaDam > this.getEffected().getCurrentMp() && this.getSkill().isToggle()) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Not enough mana. Effect of " + this.getSkill().getName() + " has been removed.");
            this.getEffected().sendPacket(sm);
            return false;
        }
        this.getEffected().reduceCurrentMp(manaDam);
        return true;
    }
}

