/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.EffectTemplate;
import net.sf.l2j.gameserver.skills.Env;

class EffectDamOverTime
extends L2Effect {
    public EffectDamOverTime(Env env, EffectTemplate template) {
        super(env, template);
    }

    public L2Effect.EffectType getEffectType() {
        return L2Effect.EffectType.DMG_OVER_TIME;
    }

    public boolean onActionTime() {
        if (this.getEffected().isDead()) {
            return false;
        }
        double damage = this.calc();
        if (damage > this.getEffected().getCurrentHp() && this.getSkill().isToggle()) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Not enough HP. Effect of " + this.getSkill().getName() + " has been removed.");
            this.getEffected().sendPacket(sm);
            return false;
        }
        if (this.getSkill().getTargetType() != L2Skill.SkillTargetType.TARGET_SELF) {
            SystemMessage sm;
            if (this.getEffector() instanceof L2PcInstance) {
                sm = new SystemMessage(614);
                sm.addString("Your " + this.getSkill().getName() + " did " + damage + " damage to " + this.getEffected().getName());
                this.getEffector().sendPacket(sm);
            }
            if (this.getEffected() instanceof L2PcInstance) {
                sm = new SystemMessage(614);
                sm.addString(this.getEffector().getName() + "'s " + this.getSkill().getName() + " did " + damage + " damage to you.");
                this.getEffected().sendPacket(sm);
            }
        }
        if (this.getEffected() instanceof L2Attackable) {
            this.getEffected().reduceCurrentHp(damage, this.getEffector(), false);
        } else {
            this.getEffected().reduceCurrentHp(damage, this.getEffector(), true);
        }
        return true;
    }
}

