/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.skills.Condition;
import net.sf.l2j.gameserver.skills.DocumentBase;
import net.sf.l2j.gameserver.templates.StatsSet;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DocumentSkill
extends DocumentBase {
    private Skill currentSkill;
    private List<L2Skill> skillsInFile = new LinkedList<L2Skill>();

    DocumentSkill(File file) {
        super(file);
    }

    private void setCurrentSkill(Skill skill) {
        this.currentSkill = skill;
    }

    @Override
    protected StatsSet getStatsSet() {
        return this.currentSkill.sets[this.currentSkill.currentLevel];
    }

    protected List<L2Skill> getSkills() {
        return this.skillsInFile;
    }

    @Override
    protected Number getTableValue(String name) {
        try {
            return ((Number[])this.tables.get(name))[this.currentSkill.currentLevel];
        }
        catch (RuntimeException e) {
            _log.log(Level.SEVERE, "error in table of skill Id " + this.currentSkill.id, e);
            return 0;
        }
    }

    @Override
    protected Number getTableValue(String name, int idx) {
        try {
            return ((Number[])this.tables.get(name))[idx - 1];
        }
        catch (RuntimeException e) {
            _log.log(Level.SEVERE, "wrong level count in skill Id " + this.currentSkill.id, e);
            return 0;
        }
    }

    @Override
    protected void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if ("list".equalsIgnoreCase(n.getNodeName())) {
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"skill".equalsIgnoreCase(d.getNodeName())) continue;
                    this.setCurrentSkill(new Skill());
                    this.parseSkill(d);
                    this.skillsInFile.addAll(this.currentSkill.skills);
                    this.resetTable();
                }
                continue;
            }
            if (!"skill".equalsIgnoreCase(n.getNodeName())) continue;
            this.setCurrentSkill(new Skill());
            this.parseSkill(n);
            this.skillsInFile.addAll(this.currentSkill.skills);
        }
    }

    protected void parseSkill(Node n) {
        int i;
        Node first;
        NamedNodeMap attrs = n.getAttributes();
        int skillId = Integer.parseInt(attrs.getNamedItem("id").getNodeValue());
        String skillName = attrs.getNamedItem("name").getNodeValue();
        String levels = attrs.getNamedItem("levels").getNodeValue();
        int lastLvl = Integer.parseInt(levels);
        this.currentSkill.id = skillId;
        this.currentSkill.name = skillName;
        this.currentSkill.sets = new StatsSet[lastLvl];
        for (int i2 = 0; i2 < lastLvl; ++i2) {
            this.currentSkill.sets[i2] = new StatsSet();
            this.currentSkill.sets[i2].set("skill_id", this.currentSkill.id);
            this.currentSkill.sets[i2].set("level", i2 + 1);
            this.currentSkill.sets[i2].set("name", this.currentSkill.name);
        }
        if (this.currentSkill.sets.length != lastLvl) {
            throw new RuntimeException("Skill id=" + skillId + " number of levels missmatch, " + lastLvl + " levels expected");
        }
        for (n = first = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"table".equalsIgnoreCase(n.getNodeName())) continue;
            this.parseTable(n);
        }
        for (i = 1; i <= lastLvl; ++i) {
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"set".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this.currentSkill.sets[i - 1], i);
            }
        }
        this.makeSkills();
        for (i = 0; i < lastLvl; ++i) {
            this.currentSkill.currentLevel = i;
            for (n = first; n != null; n = n.getNextSibling()) {
                if ("cond".equalsIgnoreCase(n.getNodeName())) {
                    Condition condition = this.parseCondition(n.getFirstChild(), this.currentSkill.currentSkills.get(i));
                    Node msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this.currentSkill.currentSkills.get(i).attach(condition);
                }
                if (!"for".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseTemplate(n, this.currentSkill.currentSkills.get(i));
            }
        }
        this.currentSkill.skills.addAll(this.currentSkill.currentSkills);
    }

    private void makeSkills() {
        this.currentSkill.currentSkills = new ArrayList(this.currentSkill.sets.length);
        for (int i = 0; i < this.currentSkill.sets.length; ++i) {
            this.currentSkill.currentSkills.add(i, this.currentSkill.sets[i].getEnum("skillType", L2Skill.SkillType.class).makeSkill(this.currentSkill.sets[i]));
        }
    }

    public class Skill {
        public int id;
        public String name;
        public StatsSet[] sets;
        public int currentLevel;
        public ArrayList<L2Skill> skills = new ArrayList();
        public ArrayList<L2Skill> currentSkills = new ArrayList();
    }
}

