/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.Race;
import net.sf.l2j.gameserver.skills.Condition;
import net.sf.l2j.gameserver.skills.ConditionGameTime;
import net.sf.l2j.gameserver.skills.ConditionLogicAnd;
import net.sf.l2j.gameserver.skills.ConditionLogicNot;
import net.sf.l2j.gameserver.skills.ConditionLogicOr;
import net.sf.l2j.gameserver.skills.ConditionPlayerLevel;
import net.sf.l2j.gameserver.skills.ConditionPlayerRace;
import net.sf.l2j.gameserver.skills.ConditionPlayerState;
import net.sf.l2j.gameserver.skills.ConditionSkillStats;
import net.sf.l2j.gameserver.skills.ConditionSlotItemId;
import net.sf.l2j.gameserver.skills.ConditionTargetAggro;
import net.sf.l2j.gameserver.skills.ConditionTargetLevel;
import net.sf.l2j.gameserver.skills.ConditionTargetUsesWeaponKind;
import net.sf.l2j.gameserver.skills.ConditionUsingItemType;
import net.sf.l2j.gameserver.skills.ConditionUsingSkill;
import net.sf.l2j.gameserver.skills.EffectTemplate;
import net.sf.l2j.gameserver.skills.Env;
import net.sf.l2j.gameserver.skills.FuncTemplate;
import net.sf.l2j.gameserver.skills.Lambda;
import net.sf.l2j.gameserver.skills.LambdaCalc;
import net.sf.l2j.gameserver.skills.LambdaConst;
import net.sf.l2j.gameserver.skills.LambdaStats;
import net.sf.l2j.gameserver.skills.Stats;
import net.sf.l2j.gameserver.templates.L2ArmorType;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.L2WeaponType;
import net.sf.l2j.gameserver.templates.StatsSet;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class DocumentBase {
    static Logger _log = Logger.getLogger(DocumentBase.class.getName());
    private File file;
    protected HashMap<String, Number[]> tables;

    DocumentBase(File file) {
        this.file = file;
        this.tables = new HashMap();
    }

    Document parse() {
        Document doc;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            doc = factory.newDocumentBuilder().parse(this.file);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error loading file " + this.file, e);
            return null;
        }
        try {
            this.parseDocument(doc);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error in file " + this.file, e);
            return null;
        }
        return doc;
    }

    protected abstract void parseDocument(Document var1);

    protected abstract StatsSet getStatsSet();

    protected abstract Number getTableValue(String var1);

    protected abstract Number getTableValue(String var1, int var2);

    protected void resetTable() {
        this.tables = new HashMap();
    }

    protected void setTable(String name, Number[] table) {
        this.tables.put(name, table);
    }

    protected void parseTemplate(Node n, Object template) {
        Condition condition = null;
        if ((n = n.getFirstChild()) == null) {
            return;
        }
        if ("cond".equalsIgnoreCase(n.getNodeName())) {
            condition = this.parseCondition(n.getFirstChild(), template);
            Node msg = n.getAttributes().getNamedItem("msg");
            if (condition != null && msg != null) {
                condition.setMessage(msg.getNodeValue());
            }
            n = n.getNextSibling();
        }
        while (n != null) {
            if ("add".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Add", condition);
            } else if ("sub".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Sub", condition);
            } else if ("mul".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Mul", condition);
            } else if ("div".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Div", condition);
            } else if ("set".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Set", condition);
            } else if ("enchant".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Enchant", condition);
            } else if ("effect".equalsIgnoreCase(n.getNodeName())) {
                if (template instanceof EffectTemplate) {
                    throw new RuntimeException("Nested effects");
                }
                this.attachEffect(n, template, condition);
            }
            n = n.getNextSibling();
        }
    }

    protected void attachFunc(Node n, Object template, String name, Condition attachCond) {
        Stats stat = Stats.valueOfXml(n.getAttributes().getNamedItem("stat").getNodeValue());
        String order = n.getAttributes().getNamedItem("order").getNodeValue();
        Lambda lambda = this.getLambda(n, template);
        int ord = this.getNumber(order, template).intValue();
        Condition applayCond = this.parseCondition(n.getFirstChild(), template);
        FuncTemplate ft = new FuncTemplate(attachCond, applayCond, name, stat, ord, lambda);
        if (template instanceof L2Item) {
            ((L2Item)template).attach(ft);
        } else if (template instanceof L2Skill) {
            ((L2Skill)template).attach(ft);
        } else if (template instanceof EffectTemplate) {
            ((EffectTemplate)template).attach(ft);
        }
    }

    protected void attachLambdaFunc(Node n, Object template, LambdaCalc calc) {
        String name = n.getNodeName();
        StringBuffer sb = new StringBuffer(name);
        sb.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        name = sb.toString();
        Lambda lambda = this.getLambda(n, template);
        FuncTemplate ft = new FuncTemplate(null, null, name, null, calc._funcs.length, lambda);
        calc.addFunc(ft.getFunc(new Env(), calc));
    }

    protected void attachEffect(Node n, Object template, Condition attachCond) {
        NamedNodeMap attrs = n.getAttributes();
        String name = attrs.getNamedItem("name").getNodeValue();
        int count = 1;
        if (attrs.getNamedItem("count") != null) {
            count = this.getNumber(attrs.getNamedItem("count").getNodeValue(), template).intValue();
        }
        int time = attrs.getNamedItem("time") != null ? this.getNumber(attrs.getNamedItem("time").getNodeValue(), template).intValue() : ((L2Skill)template).getBuffDuration() / 1000 / count;
        Lambda lambda = this.getLambda(n, template);
        Condition applayCond = this.parseCondition(n.getFirstChild(), template);
        short abnormal = 0;
        if (attrs.getNamedItem("abnormal") != null) {
            String abn = attrs.getNamedItem("abnormal").getNodeValue();
            if (abn.equals("poison")) {
                abnormal = 2;
            }
            if (abn.equals("bleeding")) {
                abnormal = 1;
            }
            if (abn.equals("flame")) {
                abnormal = 16384;
            }
            if (abn.equals("bighead")) {
                abnormal = 8192;
            }
        }
        int stackOrder = 0;
        String stackType = "none";
        if (attrs.getNamedItem("stackType") != null) {
            stackType = attrs.getNamedItem("stackType").getNodeValue();
        }
        if (attrs.getNamedItem("stackOrder") != null) {
            stackOrder = this.getNumber(attrs.getNamedItem("stackOrder").getNodeValue(), template).intValue();
        }
        EffectTemplate lt = new EffectTemplate(attachCond, applayCond, name, lambda, count, time, abnormal, stackType, stackOrder);
        this.parseTemplate(n, lt);
        if (template instanceof L2Item) {
            ((L2Item)template).attach(lt);
        } else if (template instanceof L2Skill) {
            ((L2Skill)template).attach(lt);
        }
    }

    protected Condition parseCondition(Node n, Object template) {
        while (n != null && n.getNodeType() != 1) {
            n = n.getNextSibling();
        }
        if (n == null) {
            return null;
        }
        if ("and".equalsIgnoreCase(n.getNodeName())) {
            return this.parseLogicAnd(n, template);
        }
        if ("or".equalsIgnoreCase(n.getNodeName())) {
            return this.parseLogicOr(n, template);
        }
        if ("not".equalsIgnoreCase(n.getNodeName())) {
            return this.parseLogicNot(n, template);
        }
        if ("player".equalsIgnoreCase(n.getNodeName())) {
            return this.parsePlayerCondition(n, template);
        }
        if ("target".equalsIgnoreCase(n.getNodeName())) {
            return this.parseTargetCondition(n, template);
        }
        if ("skill".equalsIgnoreCase(n.getNodeName())) {
            return this.parseSkillCondition(n, template);
        }
        if ("using".equalsIgnoreCase(n.getNodeName())) {
            return this.parseUsingCondition(n, template);
        }
        if ("game".equalsIgnoreCase(n.getNodeName())) {
            return this.parseGameCondition(n, template);
        }
        return null;
    }

    protected Condition parseLogicAnd(Node n, Object template) {
        ConditionLogicAnd cond = new ConditionLogicAnd();
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            cond.add(this.parseCondition(n, template));
        }
        if (cond._conditions == null || cond._conditions.length == 0) {
            _log.severe("Empty <and> condition in " + this.file);
        }
        return cond;
    }

    protected Condition parseLogicOr(Node n, Object template) {
        ConditionLogicOr cond = new ConditionLogicOr();
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            cond.add(this.parseCondition(n, template));
        }
        if (cond._conditions == null || cond._conditions.length == 0) {
            _log.severe("Empty <or> condition in " + this.file);
        }
        return cond;
    }

    protected Condition parseLogicNot(Node n, Object template) {
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return new ConditionLogicNot(this.parseCondition(n, template));
        }
        _log.severe("Empty <not> condition in " + this.file);
        return null;
    }

    protected Condition parsePlayerCondition(Node n, Object template) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node a = attrs.item(i);
            if ("race".equalsIgnoreCase(a.getNodeName())) {
                Race race = Race.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerRace(race));
                continue;
            }
            if ("level".equalsIgnoreCase(a.getNodeName())) {
                int lvl = this.getNumber(a.getNodeValue(), null).intValue();
                cond = this.joinAnd(cond, new ConditionPlayerLevel(lvl));
                continue;
            }
            if ("resting".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(ConditionPlayerState.CheckPlayerState.RESTING, val));
                continue;
            }
            if ("moving".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(ConditionPlayerState.CheckPlayerState.MOVING, val));
                continue;
            }
            if (!"running".equalsIgnoreCase(a.getNodeName())) continue;
            boolean val = Boolean.valueOf(a.getNodeValue());
            cond = this.joinAnd(cond, new ConditionPlayerState(ConditionPlayerState.CheckPlayerState.RUNNING, val));
        }
        if (cond == null) {
            _log.severe("Unrecognized <player> condition in " + this.file);
        }
        return cond;
    }

    protected Condition parseTargetCondition(Node n, Object template) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node a = attrs.item(i);
            if ("aggro".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionTargetAggro(val));
                continue;
            }
            if ("level".equalsIgnoreCase(a.getNodeName())) {
                int lvl = this.getNumber(a.getNodeValue(), template).intValue();
                cond = this.joinAnd(cond, new ConditionTargetLevel(lvl));
                continue;
            }
            if (!"using".equalsIgnoreCase(a.getNodeName())) continue;
            int mask = 0;
            StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
            block1: while (st.hasMoreTokens()) {
                String item = st.nextToken().trim();
                for (L2WeaponType l2WeaponType : L2WeaponType.values()) {
                    if (!l2WeaponType.toString().equals(item)) continue;
                    mask |= l2WeaponType.mask();
                    break;
                }
                for (Enum enum_ : L2ArmorType.values()) {
                    if (!((L2ArmorType)enum_).toString().equals(item)) continue;
                    mask |= ((L2ArmorType)enum_).mask();
                    continue block1;
                }
            }
            cond = this.joinAnd(cond, new ConditionTargetUsesWeaponKind(mask));
        }
        if (cond == null) {
            _log.severe("Unrecognized <target> condition in " + this.file);
        }
        return cond;
    }

    protected Condition parseSkillCondition(Node n, Object template) {
        NamedNodeMap attrs = n.getAttributes();
        Stats stat = Stats.valueOfXml(attrs.getNamedItem("stat").getNodeValue());
        return new ConditionSkillStats(stat);
    }

    protected Condition parseUsingCondition(Node n, Object template) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node a = attrs.item(i);
            if ("kind".equalsIgnoreCase(a.getNodeName())) {
                int mask = 0;
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                block1: while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    for (L2WeaponType l2WeaponType : L2WeaponType.values()) {
                        if (!l2WeaponType.toString().equals(item)) continue;
                        mask |= l2WeaponType.mask();
                        break;
                    }
                    for (Enum enum_ : L2ArmorType.values()) {
                        if (!((L2ArmorType)enum_).toString().equals(item)) continue;
                        mask |= ((L2ArmorType)enum_).mask();
                        continue block1;
                    }
                }
                cond = this.joinAnd(cond, new ConditionUsingItemType(mask));
                continue;
            }
            if ("skill".equalsIgnoreCase(a.getNodeName())) {
                int id = Integer.parseInt(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionUsingSkill(id));
                continue;
            }
            if (!"slotitem".equalsIgnoreCase(a.getNodeName())) continue;
            StringTokenizer st = new StringTokenizer(a.getNodeValue(), ";");
            int id = Integer.parseInt(st.nextToken().trim());
            int slot = Integer.parseInt(st.nextToken().trim());
            int enchant = 0;
            if (st.hasMoreTokens()) {
                enchant = Integer.parseInt(st.nextToken().trim());
            }
            cond = this.joinAnd(cond, new ConditionSlotItemId(slot, id, enchant));
        }
        if (cond == null) {
            _log.severe("Unrecognized <using> condition in " + this.file);
        }
        return cond;
    }

    protected Condition parseGameCondition(Node n, Object template) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node a = attrs.item(i);
            if (!"night".equalsIgnoreCase(a.getNodeName())) continue;
            boolean val = Boolean.valueOf(a.getNodeValue());
            cond = this.joinAnd(cond, new ConditionGameTime(ConditionGameTime.CheckGameTime.NIGHT, val));
        }
        if (cond == null) {
            _log.severe("Unrecognized <game> condition in " + this.file);
        }
        return cond;
    }

    protected void parseTable(Node n) {
        NamedNodeMap attrs = n.getAttributes();
        String name = attrs.getNamedItem("name").getNodeValue();
        if (name.charAt(0) != '#') {
            throw new IllegalArgumentException("Table name must start with #");
        }
        StringTokenizer data = new StringTokenizer(n.getFirstChild().getNodeValue());
        ArrayList<String> array = new ArrayList<String>();
        while (data.hasMoreTokens()) {
            array.add(data.nextToken());
        }
        Number[] res = new Number[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            res[i] = this.getNumber((String)array.get(i), null);
        }
        this.setTable(name, res);
    }

    protected void parseBeanSet(Node n, StatsSet set2, Integer level) {
        char ch;
        String name = n.getAttributes().getNamedItem("name").getNodeValue().trim();
        String value = n.getAttributes().getNamedItem("val").getNodeValue().trim();
        char c = ch = value.length() == 0 ? (char)' ' : (char)value.charAt(0);
        if (ch == '#' || ch == '-' || Character.isDigit(ch)) {
            set2.set(name, String.valueOf(this.getNumber(value, level)));
        } else {
            set2.set(name, value);
        }
    }

    protected Lambda getLambda(Node n, Object template) {
        Node nval = n.getAttributes().getNamedItem("val");
        if (nval != null) {
            String val = nval.getNodeValue();
            if (val.charAt(0) == '#') {
                return new LambdaConst(this.getTableValue(val).doubleValue());
            }
            if (val.charAt(0) == '$') {
                if (val.equalsIgnoreCase("$player_level")) {
                    return new LambdaStats(LambdaStats.StatsType.PLAYER_LEVEL);
                }
                if (val.equalsIgnoreCase("$target_level")) {
                    return new LambdaStats(LambdaStats.StatsType.TARGET_LEVEL);
                }
                if (val.equalsIgnoreCase("$player_max_hp")) {
                    return new LambdaStats(LambdaStats.StatsType.PLAYER_MAX_HP);
                }
                if (val.equalsIgnoreCase("$player_max_mp")) {
                    return new LambdaStats(LambdaStats.StatsType.PLAYER_MAX_MP);
                }
                StatsSet set2 = this.getStatsSet();
                String field = set2.getString(val.substring(1));
                if (field != null) {
                    return new LambdaConst(this.getNumber(field, template).doubleValue());
                }
                throw new IllegalArgumentException("Unknown value " + val);
            }
            return new LambdaConst(Double.parseDouble(val));
        }
        LambdaCalc calc = new LambdaCalc();
        for (n = n.getFirstChild(); n != null && n.getNodeType() != 1; n = n.getNextSibling()) {
        }
        if (n == null || !"val".equals(n.getNodeName())) {
            throw new IllegalArgumentException("Value not specified");
        }
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            this.attachLambdaFunc(n, template, calc);
        }
        return calc;
    }

    protected Number getNumber(String value, Object template) {
        if (value.charAt(0) == '#') {
            if (template instanceof L2Skill) {
                return this.getTableValue(value);
            }
            if (template instanceof Integer) {
                return this.getTableValue(value, (Integer)template);
            }
            throw new IllegalStateException();
        }
        if (value.indexOf(46) == -1) {
            int radix = 10;
            if (value.length() > 2 && value.substring(0, 2).equalsIgnoreCase("0x")) {
                value = value.substring(2);
                radix = 16;
            }
            return Integer.valueOf(value, radix);
        }
        return Double.valueOf(value);
    }

    protected Condition joinAnd(Condition cond, Condition c) {
        if (cond == null) {
            return c;
        }
        if (cond instanceof ConditionLogicAnd) {
            ((ConditionLogicAnd)cond).add(c);
            return cond;
        }
        ConditionLogicAnd and = new ConditionLogicAnd();
        and.add(cond);
        and.add(c);
        return and;
    }
}

