/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import net.sf.l2j.gameserver.skills.Env;
import net.sf.l2j.gameserver.skills.Func;

public final class Calculator {
    static final Func[] emptyFuncs = new Func[0];
    Func[] _functions;

    public Calculator() {
        this._functions = emptyFuncs;
    }

    public Calculator(Calculator c) {
        this._functions = c._functions;
    }

    public static boolean equalsCals(Calculator c1, Calculator c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        Func[] funcs1 = c1._functions;
        Func[] funcs2 = c2._functions;
        if (funcs1 == funcs2) {
            return true;
        }
        if (funcs1.length != funcs2.length) {
            return false;
        }
        if (funcs1.length == 0) {
            return true;
        }
        for (int i = 0; i < funcs1.length; ++i) {
            if (funcs1[i] == funcs2[i]) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this._functions.length;
    }

    public synchronized void addFunc(Func f) {
        int i;
        Func[] funcs = this._functions;
        Func[] tmp = new Func[funcs.length + 1];
        int order = f._order;
        for (i = 0; i < funcs.length && order >= funcs[i]._order; ++i) {
            tmp[i] = funcs[i];
        }
        tmp[i] = f;
        while (i < funcs.length) {
            tmp[i + 1] = funcs[i];
            ++i;
        }
        this._functions = tmp;
    }

    public synchronized void removeFunc(Func f) {
        int i;
        Func[] funcs = this._functions;
        Func[] tmp = new Func[funcs.length - 1];
        for (i = 0; i < funcs.length && f != funcs[i]; ++i) {
            tmp[i] = funcs[i];
        }
        if (i == funcs.length) {
            return;
        }
        ++i;
        while (i < funcs.length) {
            tmp[i - 1] = funcs[i];
            ++i;
        }
        this._functions = tmp.length == 0 ? emptyFuncs : tmp;
    }

    public synchronized void removeOwner(Object owner) {
        Func[] funcs = this._functions;
        for (int i = 0; i < funcs.length; ++i) {
            if (funcs[i]._funcOwner != owner) continue;
            this.removeFunc(funcs[i]);
        }
    }

    public void calc(Env env) {
        Func[] funcs = this._functions;
        for (int i = 0; i < funcs.length; ++i) {
            funcs[i].calc(env);
        }
    }
}

