/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;

public class WareHouseWithdrawalList
extends ServerBasePacket {
    private static Logger _log = Logger.getLogger(WareHouseWithdrawalList.class.getName());
    private static final String _S__54_WAREHOUSEWITHDRAWALLIST = "[S] 42 WareHouseWithdrawalList";
    private L2PcInstance _cha;
    private L2Clan _clan;
    private int _money;
    private L2ItemInstance[] _items;

    public WareHouseWithdrawalList(L2PcInstance cha) {
        this._cha = cha;
        this._clan = null;
        this._money = cha.getAdena();
    }

    public WareHouseWithdrawalList(L2PcInstance cha, L2Clan clan) {
        this._cha = cha;
        this._clan = clan;
        this._money = cha.getAdena();
    }

    final void runImpl() {
        if (this._clan == null) {
            this._items = this._cha.getWarehouse().listItems();
            for (int i = 0; i < this._items.length; ++i) {
                L2ItemInstance temp = this._items[i];
                if (!Config.DEBUG) continue;
                _log.fine("item:" + temp.getItem().getName() + " type1:" + temp.getItem().getType1() + " type2:" + temp.getItem().getType2());
            }
        } else {
            this._items = this._clan.getWarehouse().listItems();
            for (int i = 0; i < this._items.length; ++i) {
                L2ItemInstance temp = this._items[i];
                if (!Config.DEBUG) continue;
                _log.fine("item:" + temp.getItem().getName() + " type1:" + temp.getItem().getType1() + " type2:" + temp.getItem().getType2());
            }
        }
    }

    final void writeImpl() {
        this.writeC(66);
        this.writeD(this._money);
        this.writeH(this._items.length);
        for (L2ItemInstance temp : this._items) {
            this.writeH(temp.getItem().getType1());
            this.writeD(temp.getObjectId());
            this.writeD(temp.getItemId());
            this.writeD(temp.getCount());
            this.writeH(temp.getItem().getType2());
            this.writeH(0);
            this.writeD(temp.getItem().getBodyPart());
            this.writeH(temp.getEnchantLevel());
            this.writeH(0);
            this.writeH(0);
            this.writeD(temp.getItemId());
        }
    }

    public String getType() {
        return _S__54_WAREHOUSEWITHDRAWALLIST;
    }
}

