/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.BasePacket;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.Connection;
import net.sf.l2j.gameserver.serverpackets.KeyPacket;

public abstract class ServerBasePacket
extends BasePacket {
    private static Logger _log = Logger.getLogger(ServerBasePacket.class.getName());

    protected ServerBasePacket() {
        if (Config.DEBUG) {
            _log.fine(this.getType());
        }
    }

    protected ServerBasePacket(Connection con) {
        super(con);
        if (Config.DEBUG) {
            _log.fine(this.getType());
        }
    }

    protected final void writeD(int value) {
        this._buf.putInt(value);
    }

    protected final void writeH(int value) {
        this._buf.putShort((short)value);
    }

    protected final void writeC(int value) {
        this._buf.put((byte)value);
    }

    protected final void writeF(double value) {
        this._buf.putDouble(value);
    }

    protected final void writeS(String text) {
        if (text == null) {
            this._buf.putChar('\u0000');
        } else {
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                this._buf.putChar(text.charAt(i));
            }
            this._buf.putChar('\u0000');
        }
    }

    protected final void writeB(byte[] data) {
        this._buf.put(data);
    }

    public final BasePacket setConnection(Connection con) {
        BasePacket bp = super.setConnection(con);
        if (bp == this) {
            this.runImpl();
        }
        return bp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean write(ByteBuffer buf) {
        if (Config.ASSERT) assert (buf.position() == 0);
        if (Config.ASSERT) assert (buf.order() == ByteOrder.LITTLE_ENDIAN);
        this._buf = buf;
        try {
            this._buf.putShort((short)0);
            try {
                if (Config.DEBUG) {
                    ClientThread client = this.getClient();
                    _log.finer(this.getType() + " >>> " + (client == null ? "null" : client.getLoginName()));
                }
                this.writeImpl();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
                boolean bl = false;
                this._buf = null;
                return bl;
            }
            this._buf.flip();
            this._buf.putShort((short)this._buf.limit());
            ByteBuffer b = this._buf.slice();
            this._buf.position(0);
            if (!(this instanceof KeyPacket)) {
                this.getConnection().encript(b);
            }
        }
        finally {
            this._buf = null;
        }
        return true;
    }

    abstract void runImpl();

    abstract void writeImpl();
}

