/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2MerchantInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;

public class SellList
extends ServerBasePacket {
    private static final String _S__10_SELLLIST = "[S] 10 SellList";
    private static Logger _log = Logger.getLogger(SellList.class.getName());
    private final L2PcInstance _char;
    private final L2MerchantInstance _lease;
    private int _money;
    private ArrayList<L2ItemInstance> _selllist = new ArrayList();

    public SellList(L2PcInstance player) {
        this._char = player;
        this._lease = null;
        this._money = this._char.getAdena();
    }

    public SellList(L2PcInstance player, L2MerchantInstance lease) {
        this._char = player;
        this._lease = lease;
        this._money = this._char.getAdena();
    }

    final void runImpl() {
        if (this._lease == null) {
            for (L2ItemInstance item : this._char.getInventory().getItems()) {
                if (item.isEquipped() || !item.getItem().isSellable()) continue;
                this._selllist.add(item);
                if (!Config.DEBUG) continue;
                _log.fine("item added to selllist: " + item.getItem().getName());
            }
        } else {
            L2ItemInstance[] leaseList = this._lease.listLeaseItems();
            L2ItemInstance[] playerList = this._char.getInventory().getItems();
            for (L2ItemInstance li : leaseList) {
                for (L2ItemInstance item : playerList) {
                    if (item.getItemId() != li.getItemId() || item.getEnchantLevel() != li.getEnchantLevel() || item.isEquipped() || !item.getItem().isSellable() || li.getPriceToBuy() == 0 && this._char.getObjectId() != this._lease.getLeaseHolderId()) continue;
                    this._selllist.add(item);
                    if (!Config.DEBUG) continue;
                    _log.fine("item added to selllist: " + item.getItem().getName());
                }
            }
            if (this._lease.getLeaseHolderId() == this._char.getObjectId()) {
                this._selllist.add(this._char.getInventory().getAdenaInstance());
            }
        }
    }

    final void writeImpl() {
        this.writeC(16);
        this.writeD(this._money);
        this.writeD(this._lease == null ? 0 : 1000000 + this._lease.getTemplate().npcId);
        this.writeH(this._selllist.size());
        for (L2ItemInstance item : this._selllist) {
            this.writeH(item.getItem().getType1());
            this.writeD(item.getObjectId());
            this.writeD(item.getItemId());
            this.writeD(item.getCount());
            this.writeH(item.getItem().getType2());
            this.writeH(0);
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchantLevel());
            this.writeH(0);
            this.writeH(0);
            if (this._lease == null) {
                this.writeD(item.getItem().getReferencePrice() / 2);
                continue;
            }
            if (this._lease.getLeaseHolderId() == this._char.getObjectId()) {
                this.writeD(0);
                continue;
            }
            if (this._lease.getLeaseHolderId() == this._char.getObjectId()) continue;
            this.writeD(item.getPriceToBuy());
        }
    }

    public String getType() {
        return _S__10_SELLLIST;
    }
}

