/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.util.ArrayList;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2TradeList;
import net.sf.l2j.gameserver.model.TradeItem;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.templates.L2Item;

public class PrivateSellListBuy
extends ServerBasePacket {
    private static final String _S__D0_PRIVATESELLLISTBUY = "[S] b7 PrivateSellListBuy";
    private L2PcInstance _buyer;
    private int _buyerAdena;
    private L2TradeList _list;
    private TradeItem[] _buyList;

    public PrivateSellListBuy(L2PcInstance buyer) {
        this._buyer = buyer;
        this._buyerAdena = this._buyer.getAdena();
    }

    final void runImpl() {
        L2ItemInstance[] inventory = this._buyer.getInventory().getItems();
        ArrayList<TradeItem> buyList = this._buyer.getBuyList();
        int count = this._buyer.getInventory().getSize();
        this._list = new L2TradeList(0);
        this._buyList = buyList.toArray(new TradeItem[buyList.size()]);
        for (int i = 0; i < count; ++i) {
            L2ItemInstance item = inventory[i];
            if (item.isEquipped() || item.getItem().getType2() == 3 || item.getItem().getType2() == 4 && item.getItem().getType1() == 1 || item.isEquipped()) continue;
            this._list.addItem(item);
        }
    }

    final void writeImpl() {
        int i;
        this.writeC(183);
        this.writeD(this._buyer.getObjectId());
        this.writeD(this._buyerAdena);
        int count = this._list.getItems().size();
        this.writeD(count);
        for (i = 0; i < count; ++i) {
            L2ItemInstance temp = this._list.getItems().get(i);
            this.writeD(temp.getItemId());
            this.writeH(0);
            this.writeD(temp.getCount());
            this.writeD(temp.getPriceToSell());
            this.writeH(0);
            this.writeD(temp.getItem().getBodyPart());
            this.writeH(temp.getItem().getType2());
        }
        count = this._buyList.length;
        this.writeD(count);
        if (count != 0) {
            for (i = 0; i < count; ++i) {
                TradeItem temp2 = this._buyList[i];
                L2Item tempItem = ItemTable.getInstance().getTemplate(temp2.getItemId());
                this.writeD(temp2.getItemId());
                this.writeH(0);
                this.writeD(temp2.getCount());
                this.writeD(temp2.getStorePrice());
                this.writeH(0);
                this.writeD(tempItem.getBodyPart());
                this.writeH(tempItem.getType2());
                this.writeD(temp2.getOwnersPrice());
                this.writeD(temp2.getStorePrice());
            }
        }
    }

    public String getType() {
        return _S__D0_PRIVATESELLLISTBUY;
    }
}

