/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.waypoint.WayPointNode;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class NpcInfoPoly
extends ServerBasePacket {
    private static final String _S__22_NPCINFO = "[S] 16 NpcInfo";
    private L2Character _cha;
    private L2Object _obj;
    private int _x;
    private int _y;
    private int _z;
    private int _heading;
    private int _npcId;
    private boolean _isAttackable;
    private boolean _isSummoned;
    private boolean _isRunning;
    private boolean _isInCombat;
    private boolean _isAlikeDead;
    private int _mAtkSpd;
    private int _pAtkSpd;
    private int _runSpd;
    private int _walkSpd;
    private int _swimRunSpd;
    private int _swimWalkSpd;
    private int _flRunSpd;
    private int _flWalkSpd;
    private int _flyRunSpd;
    private int _flyWalkSpd;
    private int _rhand;
    private int _lhand;
    private String _name;
    private String _title;
    private short _abnormalEffect;
    L2NpcTemplate _template;
    private int collisionRadius;
    private int collisionHeight;

    public NpcInfoPoly(L2Object cha, L2Character attacker) {
        this._obj = cha;
        this._npcId = cha.getPolyid();
        this._template = NpcTable.getInstance().getTemplate(this._npcId);
        this._isAttackable = true;
        this._rhand = 0;
        this._lhand = 0;
        this._isSummoned = false;
        this.collisionRadius = this._template.collisionRadius;
        this.collisionHeight = this._template.collisionHeight;
        if (this._obj instanceof L2Character) {
            this._cha = (L2Character)cha;
            this._isAttackable = cha.isAutoAttackable(attacker);
            this._rhand = this._template.rhand;
            this._lhand = this._template.lhand;
        }
    }

    final void runImpl() {
        if (this._obj instanceof L2ItemInstance) {
            this._x = this._obj.getX();
            this._y = this._obj.getY();
            this._z = this._obj.getZ();
            this._heading = 0;
            this._mAtkSpd = 100;
            this._pAtkSpd = 100;
            this._runSpd = 120;
            this._walkSpd = 80;
            this._flRunSpd = this._flyRunSpd = this._runSpd;
            this._swimRunSpd = this._flyRunSpd;
            this._flWalkSpd = this._flyWalkSpd = this._walkSpd;
            this._swimWalkSpd = this._flyWalkSpd;
            this._isAlikeDead = false;
            this._isInCombat = false;
            this._isRunning = false;
            this._name = "item";
            this._title = "polymorphed";
            this._abnormalEffect = 0;
        } else if (this._obj instanceof WayPointNode) {
            WayPointNode node = (WayPointNode)this._obj;
            this._x = this._obj.getX();
            this._y = this._obj.getY();
            this._z = this._obj.getZ();
            this._heading = 0;
            this._mAtkSpd = 100;
            this._pAtkSpd = 100;
            this._runSpd = 120;
            this._walkSpd = 80;
            this._flRunSpd = this._flyRunSpd = this._runSpd;
            this._swimRunSpd = this._flyRunSpd;
            this._flWalkSpd = this._flyWalkSpd = this._walkSpd;
            this._swimWalkSpd = this._flyWalkSpd;
            this._isAlikeDead = false;
            this._isInCombat = false;
            this._isRunning = false;
            this._name = node.getName();
            this._title = node.getTitle();
            this._abnormalEffect = 0;
            this.collisionRadius = 10;
        } else {
            this._x = this._cha.getX();
            this._y = this._cha.getY();
            this._z = this._cha.getZ();
            this._heading = this._cha.getHeading();
            this._mAtkSpd = this._cha.getMAtkSpd();
            this._pAtkSpd = this._cha.getPAtkSpd();
            this._runSpd = this._cha.getRunSpeed();
            this._walkSpd = this._cha.getWalkSpeed();
            this._flRunSpd = this._flyRunSpd = this._runSpd;
            this._swimRunSpd = this._flyRunSpd;
            this._flWalkSpd = this._flyWalkSpd = this._walkSpd;
            this._swimWalkSpd = this._flyWalkSpd;
            this._isRunning = this._cha.isRunning();
            this._isInCombat = this._cha.isInCombat();
            this._isAlikeDead = this._cha.isAlikeDead();
            this._name = this._cha.getName();
            this._title = this._cha.getTitle();
            this._abnormalEffect = this._cha.getAbnormalEffect();
        }
    }

    final void writeImpl() {
        this.writeC(22);
        this.writeD(this._obj.getObjectId());
        this.writeD(this._npcId + 1000000);
        this.writeD(this._isAttackable ? 1 : 0);
        this.writeD(this._x);
        this.writeD(this._y);
        this.writeD(this._z);
        this.writeD(this._heading);
        this.writeD(0);
        this.writeD(this._mAtkSpd);
        this.writeD(this._pAtkSpd);
        this.writeD(this._runSpd);
        this.writeD(this._walkSpd);
        this.writeD(this._swimRunSpd);
        this.writeD(this._swimWalkSpd);
        this.writeD(this._flRunSpd);
        this.writeD(this._flWalkSpd);
        this.writeD(this._flyRunSpd);
        this.writeD(this._flyWalkSpd);
        this.writeF(1.0);
        this.writeF(1.0);
        this.writeF(this.collisionRadius);
        this.writeF(this.collisionHeight);
        this.writeD(this._rhand);
        this.writeD(0);
        this.writeD(this._lhand);
        this.writeC(1);
        this.writeC(this._isRunning ? 1 : 0);
        this.writeC(this._isInCombat ? 1 : 0);
        this.writeC(this._isAlikeDead ? 1 : 0);
        this.writeC(this._isSummoned ? 2 : 0);
        this.writeS(this._name);
        this.writeS(this._title);
        this.writeD(0);
        this.writeD(0);
        this.writeD(0);
        this.writeH(this._abnormalEffect);
        this.writeH(0);
        this.writeD(0);
        this.writeD(0);
        this.writeD(0);
        this.writeD(0);
        this.writeC(0);
    }

    public String getType() {
        return _S__22_NPCINFO;
    }
}

