/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2CastleGuardInstance;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2MonsterInstance;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2PetInstance;
import net.sf.l2j.gameserver.model.L2Summon;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;

public class NpcInfo
extends ServerBasePacket {
    private static final String _S__22_NPCINFO = "[S] 16 NpcInfo";
    private L2Character _cha;
    private int _x;
    private int _y;
    private int _z;
    private int _heading;
    private int _npcId;
    private boolean _isAttackable;
    private boolean _isSummoned;
    private int _mAtkSpd;
    private int _pAtkSpd;
    private int _runSpd;
    private int _walkSpd;
    private int _swimRunSpd;
    private int _swimWalkSpd;
    private int _flRunSpd;
    private int _flWalkSpd;
    private int _flyRunSpd;
    private int _flyWalkSpd;
    private int _rhand;
    private int _lhand;
    private int collisionHeight;
    private int collisionRadius;
    private String _name = "";

    public NpcInfo(L2NpcInstance cha, L2Character attacker) {
        this._cha = cha;
        this._npcId = cha.getTemplate().npcId;
        this._isAttackable = cha.isAutoAttackable(attacker);
        this._rhand = cha.getTemplate().rhand;
        this._lhand = cha.getTemplate().lhand;
        this._isSummoned = false;
        this.collisionHeight = this._cha.getTemplate().collisionHeight;
        this.collisionRadius = this._cha.getTemplate().collisionRadius;
        if (Config.SERVER_SIDE_NPC_NAME) {
            if (Config.SERVER_SIDE_NPC_NAME_WITH_LVL && this._cha instanceof L2MonsterInstance) {
                String _aggro = "";
                if (cha.getAggroRange() > 0) {
                    _aggro = "*";
                }
                this._name = "Lv" + cha.getLevel() + _aggro + " " + cha.getName();
            } else {
                this._name = cha.getName();
            }
        }
    }

    public NpcInfo(L2CastleGuardInstance cha, L2Character attacker) {
        this._cha = cha;
        this._npcId = cha.getTemplate().npcId;
        this._isAttackable = cha.isAutoAttackable(attacker);
        this._rhand = cha.getTemplate().rhand;
        this._lhand = cha.getTemplate().lhand;
        this._isSummoned = false;
        this.collisionHeight = this._cha.getTemplate().collisionHeight;
        this.collisionRadius = this._cha.getTemplate().collisionRadius;
        if (Config.SERVER_SIDE_NPC_NAME) {
            this._name = this._cha.getName();
        }
    }

    public NpcInfo(L2Summon cha, L2Character attacker) {
        this._cha = cha;
        this._npcId = cha.getTemplate().npcId;
        this._isAttackable = cha.isAutoAttackable(attacker);
        this._rhand = 0;
        this._lhand = 0;
        this._isSummoned = cha.isShowSummonAnimation();
        this.collisionHeight = this._cha.getTemplate().collisionHeight;
        this.collisionRadius = this._cha.getTemplate().collisionRadius;
        if (Config.SERVER_SIDE_NPC_NAME || cha instanceof L2PetInstance) {
            this._name = this._cha.getName();
        }
    }

    final void runImpl() {
        this._x = this._cha.getX();
        this._y = this._cha.getY();
        this._z = this._cha.getZ();
        this._heading = this._cha.getHeading();
        this._mAtkSpd = this._cha.getMAtkSpd();
        this._pAtkSpd = this._cha.getPAtkSpd();
        this._runSpd = this._cha.getRunSpeed();
        this._walkSpd = this._cha.getWalkSpeed();
        this._flRunSpd = this._flyRunSpd = this._runSpd;
        this._swimRunSpd = this._flyRunSpd;
        this._flWalkSpd = this._flyWalkSpd = this._walkSpd;
        this._swimWalkSpd = this._flyWalkSpd;
    }

    final void writeImpl() {
        this.writeC(22);
        this.writeD(this._cha.getObjectId());
        this.writeD(this._npcId + 1000000);
        this.writeD(this._isAttackable ? 1 : 0);
        this.writeD(this._x);
        this.writeD(this._y);
        this.writeD(this._z);
        this.writeD(this._heading);
        this.writeD(0);
        this.writeD(this._mAtkSpd);
        this.writeD(this._pAtkSpd);
        this.writeD(this._runSpd);
        this.writeD(this._walkSpd);
        this.writeD(this._swimRunSpd);
        this.writeD(this._swimWalkSpd);
        this.writeD(this._flRunSpd);
        this.writeD(this._flWalkSpd);
        this.writeD(this._flyRunSpd);
        this.writeD(this._flyWalkSpd);
        this.writeF(1.0);
        this.writeF(1.0);
        this.writeF(this.collisionRadius);
        this.writeF(this.collisionHeight);
        this.writeD(this._rhand);
        this.writeD(0);
        this.writeD(this._lhand);
        this.writeC(1);
        this.writeC(this._cha.isRunning() ? 1 : 0);
        this.writeC(this._cha.isInCombat() ? 1 : 0);
        this.writeC(this._cha.isAlikeDead() ? 1 : 0);
        this.writeC(this._isSummoned ? 2 : 0);
        this.writeS(this._name);
        this.writeS(this._cha.getTitle());
        this.writeD(0);
        this.writeD(0);
        this.writeD(0);
        this.writeH(this._cha.getAbnormalEffect());
        this.writeH(0);
        this.writeD(0);
        this.writeD(0);
        this.writeD(0);
        this.writeD(0);
        this.writeC(0);
    }

    public String getType() {
        return _S__22_NPCINFO;
    }
}

