/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;

public class ItemList
extends ServerBasePacket {
    private static Logger _log = Logger.getLogger(ItemList.class.getName());
    private static final String _S__27_ITEMLIST = "[S] 1b ItemList";
    private L2ItemInstance[] _items;
    private boolean _showWindow;

    public ItemList(L2PcInstance cha, boolean showWindow) {
        this._items = cha.getInventory().getItems();
        this._showWindow = showWindow;
    }

    public ItemList(L2ItemInstance[] items, boolean showWindow) {
        this._items = items;
        this._showWindow = showWindow;
    }

    final void runImpl() {
        if (Config.DEBUG) {
            for (L2ItemInstance temp : this._items) {
                _log.fine("item:" + temp.getItem().getName() + " type1:" + temp.getItem().getType1() + " type2:" + temp.getItem().getType2());
            }
        }
    }

    final void writeImpl() {
        this.writeC(27);
        if (this._showWindow) {
            this.writeH(1);
        } else {
            this.writeH(0);
        }
        int count = this._items.length;
        this.writeH(count);
        for (L2ItemInstance temp : this._items) {
            this.writeH(temp.getItem().getType1());
            this.writeD(temp.getObjectId());
            this.writeD(temp.getItemId());
            this.writeD(temp.getCount());
            this.writeH(temp.getItem().getType2());
            this.writeH(255);
            if (temp.isEquipped()) {
                this.writeH(1);
            } else {
                this.writeH(0);
            }
            this.writeD(temp.getItem().getBodyPart());
            this.writeH(temp.getEnchantLevel());
            this.writeH(0);
        }
    }

    public String getType() {
        return _S__27_ITEMLIST;
    }
}

