/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.script.faenor;

import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.script.IntList;
import net.sf.l2j.gameserver.script.Parser;
import net.sf.l2j.gameserver.script.ParserFactory;
import net.sf.l2j.gameserver.script.ScriptEngine;
import net.sf.l2j.gameserver.script.faenor.FaenorParser;
import org.apache.bsf.BSFManager;
import org.w3c.dom.Node;

public class FaenorWorldDataParser
extends FaenorParser {
    static Logger _log = Logger.getLogger(FaenorWorldDataParser.class.getName());
    private static final String PET_DATA = "PetData";
    private static final String NPC_INFO_DATA = "NpcData";
    private static final String NPC_STAT_DATA = "NpcStatData";
    private static final String NPC_DROP_DATA = "NpcDropData";
    private static final String ITEM_DATA = "ItemData";
    private static final double NPC_COLLISION_HEIGHT = 30.0;
    private static final double NPC_COLLISION_RADIUS = 15.0;
    private static final String NPC_NAME = "NoName";
    private static final int NPC_ATTACK_RANGE = 40;
    private static final int NPC_PHYSICAL_ATTACK_SPEED = 253;
    private static final int NPC_AGGRO_RANGE = 0;
    private static final int NPC_MAGICAL_ATTACK_SPEED = 10;
    private static final int NPC_RIGHT_HAND_WEAPON_ID = 0;
    private static final int NPC_LEFT_HAND_WEAPON_ID = 0;
    private static final int NPC_ARMOR_ID = 0;
    private static final int NPC_WALK_SPEED = 80;
    private static final int NPC_RUN_SPEED = 110;

    public void parseScript(Node eventNode, BSFManager context2) {
        if (Config.DEBUG) {
            System.out.println("Parsing WorldData");
        }
        for (Node node = eventNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (FaenorWorldDataParser.isNodeName(node, PET_DATA)) {
                this.parsePetData(node, context2);
                continue;
            }
            if (FaenorWorldDataParser.isNodeName(node, NPC_STAT_DATA)) {
                this.parseNpcStatData(node);
                continue;
            }
            if (FaenorWorldDataParser.isNodeName(node, NPC_INFO_DATA)) {
                this.parseNpcInfoData(node);
                continue;
            }
            if (FaenorWorldDataParser.isNodeName(node, NPC_DROP_DATA)) {
                this.parseNpcDropData(node);
                continue;
            }
            if (!FaenorWorldDataParser.isNodeName(node, ITEM_DATA)) continue;
            this.parseItemData(node);
        }
    }

    private void parseNpcInfoData(Node node) {
        if (Config.DEBUG) {
            System.out.println("Parsing Npc Info Data NOT DONE.");
        }
    }

    private void parseItemData(Node itemNode) {
    }

    private void parseNpcDropData(Node npcNode) {
        try {
            int mobId = FaenorWorldDataParser.getInt(FaenorWorldDataParser.element(npcNode, "MonsterID"));
            int itemId = FaenorWorldDataParser.getInt(FaenorWorldDataParser.element(npcNode, "ItemID"));
            int minDrop = FaenorWorldDataParser.getInt(FaenorWorldDataParser.element(npcNode, "MinimumDrop"));
            int maxDrop = FaenorWorldDataParser.getInt(FaenorWorldDataParser.element(npcNode, "MaximumDrop"));
            boolean sweep = FaenorWorldDataParser.getInt(FaenorWorldDataParser.element(npcNode, "isSweepDrop")) == 1;
            int chance = FaenorWorldDataParser.getInt(FaenorWorldDataParser.element(npcNode, "Chance"));
            bridge.addDrop(mobId, itemId, minDrop, maxDrop, sweep, chance);
        }
        catch (Exception e) {
            System.err.println("ERROR(parseNpcDropData):" + e.getMessage());
            return;
        }
    }

    private void parseNpcStatData(Node npcNode) {
    }

    private void parsePetData(Node petNode, BSFManager context2) {
        PetData petData = new PetData();
        try {
            petData.petID = FaenorWorldDataParser.getInt(FaenorWorldDataParser.attribute(petNode, "ID"));
            int[] levelRange = IntList.parse(FaenorWorldDataParser.attribute(petNode, "Levels"));
            petData.levelStart = levelRange[0];
            petData.levelEnd = levelRange[1];
            for (Node node = petNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!FaenorWorldDataParser.isNodeName(node, "Stat")) continue;
                this.parseStat(node, petData);
            }
            bridge.addPetData(context2, petData.petID, petData.levelStart, petData.levelEnd, petData.statValues);
        }
        catch (Exception e) {
            petData.petID = -1;
            _log.warning("Error in pet Data parser.");
            e.printStackTrace();
        }
    }

    private void parseStat(Node stat, PetData petData) {
        try {
            String statName = FaenorWorldDataParser.attribute(stat, "Name");
            for (Node node = stat.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!FaenorWorldDataParser.isNodeName(node, "Formula")) continue;
                String formula = this.parseForumla(node, petData);
                petData.statValues.put(statName, formula);
            }
        }
        catch (Exception e) {
            petData.petID = -1;
            System.err.println("ERROR(parseStat):" + e.getMessage());
        }
    }

    private String parseForumla(Node formulaNode, PetData petData) {
        return formulaNode.getTextContent().trim();
    }

    static {
        ScriptEngine.parserFactories.put(FaenorWorldDataParser.getParserName("WorldData"), new FaenorWorldDataParserFactory());
    }

    static class FaenorWorldDataParserFactory
    extends ParserFactory {
        FaenorWorldDataParserFactory() {
        }

        public Parser create() {
            return new FaenorWorldDataParser();
        }
    }

    public class PetData {
        public int petID;
        public int levelStart;
        public int levelEnd;
        HashMap<String, String> statValues = new HashMap();
    }
}

