/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.script.faenor;

import net.sf.l2j.gameserver.script.Parser;
import net.sf.l2j.gameserver.script.ParserFactory;
import net.sf.l2j.gameserver.script.ScriptEngine;
import net.sf.l2j.gameserver.script.faenor.FaenorParser;
import org.apache.bsf.BSFManager;
import org.w3c.dom.Node;

public class FaenorQuestParser
extends FaenorParser {
    public void parseScript(Node questNode, BSFManager context2) {
        System.out.println("Parsing Quest.");
        String questID = FaenorQuestParser.attribute(questNode, "ID");
        for (Node node = questNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (FaenorQuestParser.isNodeName(node, "DROPLIST")) {
                this.parseQuestDropList(node.cloneNode(true), questID);
                continue;
            }
            if (!FaenorQuestParser.isNodeName(node, "DIALOG WINDOWS") && !FaenorQuestParser.isNodeName(node, "INITIATOR") && !FaenorQuestParser.isNodeName(node, "STATE")) continue;
        }
    }

    private void parseQuestDropList(Node dropList, String questID) throws NullPointerException {
        System.out.println("Parsing Droplist.");
        for (Node node = dropList.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!FaenorQuestParser.isNodeName(node, "DROP")) continue;
            this.parseQuestDrop(node.cloneNode(true), questID);
        }
    }

    private void parseQuestDrop(Node drop2, String questID) {
        String[] states;
        int chance;
        int max;
        int min;
        int itemID;
        int npcID;
        System.out.println("Parsing Drop.");
        try {
            npcID = FaenorQuestParser.getInt(FaenorQuestParser.attribute(drop2, "NpcID"));
            itemID = FaenorQuestParser.getInt(FaenorQuestParser.attribute(drop2, "ItemID"));
            min = FaenorQuestParser.getInt(FaenorQuestParser.attribute(drop2, "Min"));
            max = FaenorQuestParser.getInt(FaenorQuestParser.attribute(drop2, "Max"));
            chance = FaenorQuestParser.getInt(FaenorQuestParser.attribute(drop2, "Chance"));
            states = FaenorQuestParser.attribute(drop2, "States").split(",");
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Incorrect Drop Data");
        }
        System.out.println("Adding Drop to NpcID: " + npcID);
        bridge.addQuestDrop(npcID, itemID, min, max, chance, questID, states);
    }

    static {
        ScriptEngine.parserFactories.put(FaenorQuestParser.getParserName("Quest"), new FaenorQuestParserFactory());
    }

    static class FaenorQuestParserFactory
    extends ParserFactory {
        FaenorQuestParserFactory() {
        }

        public Parser create() {
            return new FaenorQuestParser();
        }
    }
}

