/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.script.faenor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.Announcements;
import net.sf.l2j.gameserver.EventDroplist;
import net.sf.l2j.gameserver.model.L2DropData;
import net.sf.l2j.gameserver.model.L2PetData;
import net.sf.l2j.gameserver.model.L2PetDataTable;
import net.sf.l2j.gameserver.script.DateRange;
import net.sf.l2j.gameserver.script.EngineInterface;
import net.sf.l2j.gameserver.script.Expression;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaenorInterface
implements EngineInterface {
    private static FaenorInterface _instance;

    public static FaenorInterface getInstance() {
        if (_instance == null) {
            _instance = new FaenorInterface();
        }
        return _instance;
    }

    public ArrayList getAllPlayers() {
        return null;
    }

    @Override
    public void addQuestDrop(int npcID, int itemID, int min, int max, int chance, String questID, String[] states) {
        L2NpcTemplate npc = _npcTable.getTemplate(npcID);
        if (npc == null) {
            throw new NullPointerException();
        }
        L2DropData drop2 = new L2DropData();
        drop2.setItemId(itemID);
        drop2.setMinDrop(min);
        drop2.setMaxDrop(max);
        drop2.setChance(chance);
        drop2.setQuestID(questID);
        drop2.addStates(states);
        npc.addDropData(drop2);
    }

    public void addDrop(int npcID, int itemID, int min, int max, boolean sweep, int chance) throws NullPointerException {
        L2NpcTemplate npc = _npcTable.getTemplate(npcID);
        if (npc == null) {
            if (Config.DEBUG) {
                System.out.print("Npc doesnt Exist");
            }
            throw new NullPointerException();
        }
        L2DropData drop2 = new L2DropData();
        drop2.setItemId(itemID);
        drop2.setMinDrop(min);
        drop2.setMaxDrop(max);
        drop2.setSweep(sweep);
        drop2.setChance(chance);
        npc.addDropData(drop2);
    }

    public List getQuestDrops(int npcID) {
        L2NpcTemplate npc = _npcTable.getTemplate(npcID);
        if (npc == null) {
            return null;
        }
        ArrayList<L2DropData> questDrops = new ArrayList<L2DropData>();
        for (L2DropData drop2 : npc.getDropData()) {
            if (drop2.getQuestID() == null) continue;
            questDrops.add(drop2);
        }
        return questDrops;
    }

    @Override
    public void addEventDrop(int[] items, int[] count, double chance, DateRange range) {
        EventDroplist.getInstance().addGlobalDrop(items, count, (int)(chance * 1000000.0), range);
    }

    @Override
    public void onPlayerLogin(String[] message, DateRange validDateRange) {
        Announcements.getInstance().addEventAnnouncement(validDateRange, message);
    }

    public void addPetData(BSFManager context2, int petID, int levelStart, int levelEnd, HashMap<String, String> stats) throws BSFException {
        L2PetData[] petData = new L2PetData[levelEnd - levelStart + 1];
        int value = 0;
        for (int level = levelStart; level <= levelEnd; ++level) {
            petData[level - 1] = new L2PetData();
            petData[level - 1].setPetID(petID);
            petData[level - 1].setPetLevel(level);
            context2.declareBean("level", new Double(level), Double.TYPE);
            for (String stat : stats.keySet()) {
                value = ((Number)Expression.eval(context2, "beanshell", stats.get(stat))).intValue();
                petData[level - 1].setStat(stat, value);
            }
            context2.undeclareBean("level");
        }
        L2PetDataTable.getInstance().addPetData(petData);
    }
}

