/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.script.faenor;

import java.util.Date;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.script.DateRange;
import net.sf.l2j.gameserver.script.IntList;
import net.sf.l2j.gameserver.script.Parser;
import net.sf.l2j.gameserver.script.ParserFactory;
import net.sf.l2j.gameserver.script.ScriptEngine;
import net.sf.l2j.gameserver.script.faenor.FaenorParser;
import org.apache.bsf.BSFManager;
import org.w3c.dom.Node;

public class FaenorEventParser
extends FaenorParser {
    static Logger _log = Logger.getLogger(FaenorEventParser.class.getName());
    private DateRange eventDates = null;

    public void parseScript(Node eventNode, BSFManager context2) {
        String ID = FaenorEventParser.attribute(eventNode, "ID");
        _log.fine("Parsing Event \"" + ID + "\"");
        this.eventDates = DateRange.parse(FaenorEventParser.attribute(eventNode, "Active"), DATE_FORMAT);
        Date currentDate = new Date();
        if (this.eventDates.getEndDate().before(currentDate)) {
            _log.warning("Event ID: (" + ID + ") has passed... Ignored.");
            return;
        }
        for (Node node = eventNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (FaenorEventParser.isNodeName(node, "DropList")) {
                this.parseEventDropList(node);
                continue;
            }
            if (!FaenorEventParser.isNodeName(node, "Message")) continue;
            this.parseEventMessage(node);
        }
    }

    private void parseEventMessage(Node sysMsg) {
        _log.fine("Parsing Event Message.");
        try {
            String type = FaenorEventParser.attribute(sysMsg, "Type");
            String[] message = FaenorEventParser.attribute(sysMsg, "Msg").split("\n");
            if (type.equalsIgnoreCase("OnJoin")) {
                bridge.onPlayerLogin(message, this.eventDates);
            }
        }
        catch (Exception e) {
            _log.warning("Error in event parser.");
            e.printStackTrace();
        }
    }

    private void parseEventDropList(Node dropList) {
        _log.fine("Parsing Droplist.");
        for (Node node = dropList.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!FaenorEventParser.isNodeName(node, "AllDrop")) continue;
            this.parseEventDrop(node);
        }
    }

    private void parseEventDrop(Node drop2) {
        _log.fine("Parsing Drop.");
        try {
            int[] items = IntList.parse(FaenorEventParser.attribute(drop2, "Items"));
            int[] count = IntList.parse(FaenorEventParser.attribute(drop2, "Count"));
            double chance = FaenorEventParser.getPercent(FaenorEventParser.attribute(drop2, "Chance"));
            bridge.addEventDrop(items, count, chance, this.eventDates);
        }
        catch (Exception e) {
            System.err.println("ERROR(parseEventDrop):" + e.getMessage());
        }
    }

    static {
        ScriptEngine.parserFactories.put(FaenorEventParser.getParserName("Event"), new FaenorEventParserFactory());
    }

    static class FaenorEventParserFactory
    extends ParserFactory {
        FaenorEventParserFactory() {
        }

        public Parser create() {
            return new FaenorEventParser();
        }
    }
}

