/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model.waypoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.util.Point3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WayPointNode
extends L2Object {
    private int id;
    private String name;
    private String title;
    private String type;
    private static String NORMAL = "Node";
    private static String SELECTED = "Selected";
    private static String LINKED = "Linked";
    public static int LINE_ID = 5560;
    private static String LINE_TYPE = "item";
    private Map<WayPointNode, List<WayPointNode>> linkLists = new HashMap<WayPointNode, List<WayPointNode>>();

    public WayPointNode(int objectId) {
        super(objectId);
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    public static WayPointNode spawn(String type, int id, int x, int y, int z) {
        WayPointNode newNode = new WayPointNode(IdFactory.getInstance().getNextId());
        newNode.setPolyInfo(type, id + "");
        newNode.spawnMe(x, y, z);
        return newNode;
    }

    public static WayPointNode spawn(boolean isItemId, int id, L2PcInstance player) {
        return WayPointNode.spawn(isItemId ? "item" : "npc", id, player.getX(), player.getY(), player.getZ());
    }

    public static WayPointNode spawn(boolean isItemId, int id, Point3D point) {
        return WayPointNode.spawn(isItemId ? "item" : "npc", id, point.x, point.y, point.z);
    }

    public static WayPointNode spawn(Point3D point) {
        return WayPointNode.spawn(Config.NEW_NODE_TYPE, Config.NEW_NODE_ID, point.x, point.y, point.z);
    }

    public static WayPointNode spawn(L2PcInstance player) {
        return WayPointNode.spawn(Config.NEW_NODE_TYPE, Config.NEW_NODE_ID, player.getX(), player.getY(), player.getZ());
    }

    @Override
    public void onAction(L2PcInstance player) {
        if (player.getTarget() != this) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), 0);
            player.sendPacket(my);
        }
    }

    public void setNormalInfo(String type, int id, String title) {
        this.type = type;
        this.changeID(id, title);
    }

    public void setNormalInfo(String type, int id) {
        this.type = type;
        this.changeID(id);
    }

    private void changeID(int id) {
        this.id = id;
        this.toggleVisible();
        this.toggleVisible();
    }

    private void changeID(int id, String title) {
        this.setName(title);
        this.setTitle(title);
        this.changeID(id);
    }

    public void setLinked() {
        this.changeID(Config.LINKED_NODE_ID, LINKED);
    }

    public void setNormal() {
        this.changeID(Config.NEW_NODE_ID, NORMAL);
    }

    public void setSelected() {
        this.changeID(Config.SELECTED_NODE_ID, SELECTED);
    }

    @Override
    public boolean isMarker() {
        return true;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    public int getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static void drawLine(WayPointNode nodeA, WayPointNode nodeB) {
        int x1 = nodeA.getX();
        int y1 = nodeA.getY();
        int z1 = nodeA.getZ();
        int x2 = nodeB.getX();
        int y2 = nodeB.getY();
        int z2 = nodeB.getZ();
        int modX = x1 - x2 > 0 ? -1 : 1;
        int modY = y1 - y2 > 0 ? -1 : 1;
        int modZ = z1 - z2 > 0 ? -1 : 1;
        int diffX = Math.abs(x1 - x2);
        int diffY = Math.abs(y1 - y2);
        int diffZ = Math.abs(z1 - z2);
        int distance = (int)Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
        int steps = distance / 40;
        ArrayList<WayPointNode> lineNodes = new ArrayList<WayPointNode>();
        for (int i = 0; i < steps; ++i) {
            lineNodes.add(WayPointNode.spawn(LINE_TYPE, LINE_ID, x1 += modX * diffX / steps, y1 += modY * diffY / steps, z1 += modZ * diffZ / steps));
        }
        nodeA.addLineInfo(nodeB, lineNodes);
        nodeB.addLineInfo(nodeA, lineNodes);
    }

    public void addLineInfo(WayPointNode node, List<WayPointNode> line) {
        this.linkLists.put(node, line);
    }

    public static void eraseLine(WayPointNode target, WayPointNode selectedNode) {
        List<WayPointNode> lineNodes = target.getLineInfo(selectedNode);
        if (lineNodes == null) {
            return;
        }
        for (WayPointNode node : lineNodes) {
            node.decayMe();
        }
        target.eraseLine(selectedNode);
        selectedNode.eraseLine(target);
    }

    public void eraseLine(WayPointNode target) {
        this.linkLists.remove(target);
    }

    private List<WayPointNode> getLineInfo(WayPointNode selectedNode) {
        return this.linkLists.get(selectedNode);
    }

    public static void setLineId(int line_id) {
        LINE_ID = line_id;
    }

    public List<WayPointNode> getLineNodes() {
        ArrayList<WayPointNode> list = new ArrayList<WayPointNode>();
        for (List<WayPointNode> points : this.linkLists.values()) {
            list.addAll(points);
        }
        return list;
    }
}

