/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model.quest;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.lib.Rnd;
import net.sf.l2j.gameserver.model.L2DropData;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.model.quest.Quest;
import net.sf.l2j.gameserver.model.quest.State;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.PlaySound;
import net.sf.l2j.gameserver.serverpackets.QuestList;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QuestState {
    protected static Logger _log = Logger.getLogger(Quest.class.getName());
    private final Quest quest;
    private final L2PcInstance player;
    private State state;
    private boolean completed;
    private HashMap<String, String> vars;
    private HashMap<Integer, ArrayList<L2DropData>> drops;

    QuestState(Quest quest, L2PcInstance player, State state2, boolean completed) {
        HashMap<Integer, ArrayList<L2DropData>> new_drops;
        this.quest = quest;
        this.player = player;
        this.player.setQuestState(this);
        this.completed = completed;
        this.state = state2;
        if (state2 != null && !completed && (new_drops = state2.getDrops()) != null) {
            this.drops = new HashMap();
            this.drops.putAll(new_drops);
        }
    }

    public Quest getQuest() {
        return this.quest;
    }

    public L2PcInstance getPlayer() {
        return this.player;
    }

    public State getState() {
        return this.state;
    }

    public HashMap<Integer, ArrayList<L2DropData>> getDrops() {
        return this.drops;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isStarted() {
        return this.getStateId().equals("Started");
    }

    public Object setState(State state2) {
        HashMap<Integer, ArrayList<L2DropData>> new_drops;
        if (this.drops != null) {
            Iterator<ArrayList<L2DropData>> i = this.drops.values().iterator();
            while (i.hasNext()) {
                ArrayList<L2DropData> lst = i.next();
                Iterator<L2DropData> ds = lst.iterator();
                block1: while (ds.hasNext()) {
                    L2DropData d = ds.next();
                    String[] states = d.getStateIDs();
                    for (int k = 0; k < states.length; ++k) {
                        if (!this.state.getName().equals(states[k])) continue;
                        ds.remove();
                        continue block1;
                    }
                }
                if (lst != null && lst.size() != 0) continue;
                i.remove();
            }
        }
        this.state = state2;
        if (state2 != null && !this.completed && (new_drops = state2.getDrops()) != null) {
            if (this.drops == null) {
                this.drops = new HashMap();
            }
            this.drops.putAll(new_drops);
        }
        Quest.updateQuestInDb(this);
        QuestList ql = new QuestList();
        this.player.sendPacket(ql);
        return state2;
    }

    public String getStateId() {
        return this.state.getName();
    }

    String setInternal(String var, String val) {
        if (this.vars == null) {
            this.vars = new HashMap();
        }
        if (val == null) {
            val = "";
        }
        this.vars.put(var, val);
        return val;
    }

    public String set(String var, String val) {
        String old;
        if (this.vars == null) {
            this.vars = new HashMap();
        }
        if (val == null) {
            val = "";
        }
        if ((old = this.vars.put(var, val)) != null) {
            Quest.updateQuestVarInDb(this, var, val);
        } else {
            Quest.createQuestVarInDb(this, var, val);
        }
        return val;
    }

    public String unset(String var) {
        if (this.vars == null) {
            return null;
        }
        String old = this.vars.remove(var);
        if (old != null) {
            Quest.deleteQuestVarInDb(this, var);
        }
        return old;
    }

    public Object get(String var) {
        if (this.vars == null) {
            return null;
        }
        return this.vars.get(var);
    }

    public int getInt(String var) {
        int varint = 0;
        try {
            varint = Integer.parseInt(this.vars.get(var));
        }
        catch (Exception e) {
            _log.warning("variable " + var + " isn't an integer: " + varint + e);
        }
        return varint;
    }

    public boolean waitsForEvent(String event) {
        for (String se : this.state.getEvents()) {
            if (!se.equals(event)) continue;
            return true;
        }
        return false;
    }

    public boolean waitsForKill(int npcId) {
        for (int k : this.state.getKillIds()) {
            if (k != npcId) continue;
            return true;
        }
        return false;
    }

    public boolean waitsForTalk(int npcId) {
        for (int k : this.state.getTalkIds()) {
            if (k != npcId) continue;
            return true;
        }
        return false;
    }

    public void addQuestDrop(int npcId, int itemId, int chance) {
        if (this.drops == null) {
            this.drops = new HashMap();
        }
        L2DropData d = new L2DropData();
        d.setItemId(itemId);
        d.setChance(chance);
        d.setQuestID(this.quest.name);
        d.addStates(new String[]{this.state.name});
        ArrayList<L2DropData> lst = this.drops.get(npcId);
        if (lst != null) {
            lst.add(d);
        } else {
            lst = new ArrayList();
            lst.add(d);
            this.drops.put(npcId, lst);
        }
    }

    public void clearQuestDrops() {
        this.drops = null;
    }

    public void fillQuestDrops(L2NpcInstance npc, ArrayList<L2DropData> drops) {
        if (this.drops == null) {
            return;
        }
        ArrayList<L2DropData> lst = this.drops.get(npc.getTemplate().npcId);
        if (lst != null) {
            drops.addAll(lst);
        }
        if ((lst = this.drops.get(0)) != null) {
            drops.addAll(lst);
        }
    }

    public int getQuestItemsCount(int itemId) {
        L2ItemInstance inst = this.player.getInventory().getItemByItemId(itemId);
        if (inst == null) {
            return 0;
        }
        return inst.getCount();
    }

    public void giveItems(int itemId, int count) {
        L2ItemInstance item;
        if (count <= 0) {
            count = 1;
        }
        if ((item = ItemTable.getInstance().createItem(itemId)) == null) {
            return;
        }
        if (item.getItemId() == 57) {
            count = (int)((float)count * Config.RATE_QUESTS_REWARD);
        }
        item.setCount(count);
        this.player.getInventory().addItem(item);
        if (item.getItemId() == 57) {
            SystemMessage smsg = new SystemMessage(52);
            smsg.addNumber(count);
            this.player.sendPacket(smsg);
            ItemList il = new ItemList(this.player, false);
            this.player.sendPacket(il);
        } else {
            SystemMessage smsg = new SystemMessage(53);
            smsg.addNumber(count);
            smsg.addItemName(item.getItemId());
            this.player.sendPacket(smsg);
            ItemList il = new ItemList(this.player, false);
            this.player.sendPacket(il);
        }
    }

    public void addRadar(int x, int y, int z) {
        this.player.radar.addMarker(x, y, z);
    }

    public void removeRadar(int x, int y, int z) {
        this.player.radar.removeMarker(x, y, z);
    }

    public void clearRadar() {
        this.player.radar.removeAllMarkers();
    }

    public void takeItems(int itemId, int count) {
        L2ItemInstance item = this.player.getInventory().getItemByItemId(itemId);
        if (item == null) {
            return;
        }
        if (count < 0 || count > item.getCount()) {
            count = item.getCount();
        }
        this.player.getInventory().destroyItemByItemId(itemId, count);
        SystemMessage smsg = new SystemMessage(301);
        smsg.addItemName(itemId);
        this.player.sendPacket(smsg);
        ItemList il = new ItemList(this.player, false);
        this.player.sendPacket(il);
    }

    public void playSound(String sound) {
        this.player.sendPacket(new PlaySound(sound));
    }

    public void addExpAndSp(int exp, int sp) {
        this.player.addExpAndSp((int)((float)exp * Config.RATE_QUESTS_REWARD), (int)((float)sp * Config.RATE_QUESTS_REWARD));
    }

    public int getRandom(int max) {
        return Rnd.get(max);
    }

    public int getItemEquipped(int loc) {
        int item = this.player.getInventory().getPaperdollItemId(loc);
        return item;
    }

    public int getGameTicks() {
        return GameTimeController.getGameTicks();
    }

    public void spawnNpc(int npcId) {
        int newId = this.player.getObjectId() + 1000000 + npcId;
        try {
            L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(npcId);
            if (template1 == null) {
                return;
            }
            L2Spawn spawnDat = new L2Spawn(template1);
            spawnDat.setId(newId);
            spawnDat.setAmount(1);
            spawnDat.setLocx(this.player.getX() + this.getRandom(300) - 150);
            spawnDat.setLocy(this.player.getY() + this.getRandom(300) - 150);
            spawnDat.setLocz(this.player.getZ());
            spawnDat.init();
            spawnDat.stopRespawn();
        }
        catch (Exception e1) {
            _log.warning("Npc " + npcId + " cannot be spawned, Id:" + newId);
        }
    }

    public void spawnNpc(int npcId, int x, int y, int z) {
        int newId = this.player.getObjectId() + 1000000 + npcId;
        try {
            L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(npcId);
            if (template1 == null) {
                return;
            }
            L2Spawn spawnDat = new L2Spawn(template1);
            spawnDat.setId(newId);
            spawnDat.setAmount(1);
            spawnDat.setLocx(x);
            spawnDat.setLocy(y);
            spawnDat.setLocz(z);
            spawnDat.init();
            spawnDat.stopRespawn();
        }
        catch (Exception e1) {
            _log.warning("Npc " + npcId + " cannot be spawned, Id:" + newId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String showHtmlFile(String fileName) {
        FileInputStream fis = null;
        String content = null;
        try {
            String questId = this.getQuest().getName();
            String directory = this.getQuest().getDescr().toLowerCase();
            File file = new File(Config.DATAPACK_ROOT, "data/jscript/" + directory + "/" + questId + "/" + fileName);
            if (!file.exists() && !(file = new File(Config.DATAPACK_ROOT, "data/jscript/quests/" + questId + "/" + fileName)).exists()) {
                file = this.findQuestFile(fileName, file, questId);
            }
            if (file.exists()) {
                if (Config.DEBUG) {
                    _log.fine("Showing quest window for quest " + questId + " html path: " + file);
                }
                fis = new FileInputStream(file);
                byte[] raw = new byte[fis.available()];
                fis.read(raw);
                content = new String(raw, "UTF-8");
                content = content.replaceAll("%objectId%", String.valueOf(this.player.getTarget().getObjectId()));
            } else {
                if (Config.DEBUG) {
                    _log.fine("File not exists for quest " + questId + " html path: " + file);
                }
                content = null;
            }
            if (content != null) {
                NpcHtmlMessage npcReply = new NpcHtmlMessage(5);
                npcReply.setHtml(content);
                this.player.sendPacket(npcReply);
            }
        }
        catch (Exception e) {
            _log.warning("problem with npc text " + e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e1) {}
        }
        return content;
    }

    private File findQuestFile(String fileName, File file, String questId) {
        for (File jscriptDirectory : new File(Config.DATAPACK_ROOT, "data/jscript/").listFiles()) {
            for (File questIdDirectory : jscriptDirectory.listFiles()) {
                if (questIdDirectory.getName().equals("" + questId)) {
                    for (File questFile : questIdDirectory.listFiles()) {
                        if (!questFile.getName().equals(fileName)) continue;
                        file = questFile;
                    }
                }
                file = new File(Config.DATAPACK_ROOT, "data/jscript/quests/" + questId + "/" + fileName);
            }
        }
        return file;
    }

    public QuestState exitQuest(boolean repeatable) {
        if (this.completed) {
            return this;
        }
        this.completed = true;
        if (this.drops != null) {
            for (ArrayList<L2DropData> lst : this.drops.values()) {
                for (L2DropData d : lst) {
                    int itemId = d.getItemId();
                    L2ItemInstance item = this.player.getInventory().getItemByItemId(itemId);
                    if (item == null || itemId == 57) continue;
                    int count = item.getCount();
                    this.player.getInventory().destroyItemByItemId(itemId, count);
                }
            }
            ItemList il = new ItemList(this.player, false);
            this.player.sendPacket(il);
            this.drops = null;
        }
        if (repeatable) {
            this.player.delQuestState(this.quest.name);
            Quest.deleteQuestInDb(this);
            this.vars = null;
        } else {
            if (this.vars != null) {
                for (String var : this.vars.keySet().toArray(new String[this.vars.size()])) {
                    this.unset(var);
                }
            }
            Quest.updateQuestInDb(this);
        }
        return this;
    }
}

