/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.Inventory;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;

public class PcInventory
extends Inventory {
    private final L2PcInstance _owner;
    private L2ItemInstance _adena;
    public static final int MAX_ITEMS = Config.INVENTORY_MAXIMUM_CHAR;
    public static final int MAX_ITEMS_GM = Config.INVENTORY_MAXIMUM_GM;

    public PcInventory(L2PcInstance owner) {
        this._owner = owner;
    }

    protected L2PcInstance getOwner() {
        return this._owner;
    }

    protected L2ItemInstance.ItemLocation getBaseLocation() {
        return L2ItemInstance.ItemLocation.INVENTORY;
    }

    protected L2ItemInstance.ItemLocation getEquipLocation() {
        return L2ItemInstance.ItemLocation.PAPERDOLL;
    }

    protected L2ItemInstance addItem(L2ItemInstance newItem, boolean dbUpdate) {
        if (newItem.getItemId() == 57) {
            if (this._adena == null) {
                this.addAdena(newItem, dbUpdate);
            } else {
                this.addAdena(newItem.getCount(), dbUpdate);
                newItem.setCount(0);
                newItem.setOwnerId(0);
                newItem.setLocation(L2ItemInstance.ItemLocation.VOID);
                if (dbUpdate) {
                    newItem.updateDatabase();
                }
            }
            return this._adena;
        }
        return super.addItem(newItem, dbUpdate);
    }

    public L2ItemInstance dropItem(L2ItemInstance oldItem, int count) {
        if (Config.ASSERT) assert (oldItem.getOwnerId() == this.getOwnerId());
        if (oldItem != null && oldItem.getItemId() == 57) {
            this.reduceAdena(count);
            L2ItemInstance adena = ItemTable.getInstance().createItem(oldItem.getItemId());
            adena.setCount(count);
            return adena;
        }
        return super.dropItem(oldItem, count);
    }

    public L2ItemInstance getItemByItemId(int itemId) {
        if (this._adena != null && itemId == this._adena.getItemId()) {
            return this._adena;
        }
        return super.getItemByItemId(itemId);
    }

    public L2ItemInstance getItemByObjectId(int objectId) {
        if (this._adena != null && objectId == this._adena.getObjectId()) {
            return this._adena;
        }
        return super.getItemByObjectId(objectId);
    }

    public L2ItemInstance getAdenaInstance() {
        return this._adena;
    }

    public int getAdena() {
        if (this._adena == null) {
            return 0;
        }
        return this._adena.getCount();
    }

    private void setAdena(int adena, boolean dbUpdate) {
        if (adena < 0) {
            _log.warning("setAdena(" + adena + ") for char " + this._owner.getName());
            adena = 0;
        }
        if (this._adena != null && !this._items.contains(this._adena)) {
            _log.warning("missing adena in _items for char " + this._owner.getName());
            this._items.add(this._adena);
        }
        if (adena == 0) {
            if (this._adena != null && this._items.contains(this._adena)) {
                this._items.remove(this._adena);
                this._adena.setOwnerId(0);
                this._adena.setLocation(L2ItemInstance.ItemLocation.VOID);
                if (dbUpdate) {
                    this._adena.updateDatabase();
                }
                this._adena = null;
            }
        } else {
            if (this._adena == null) {
                this._adena = ItemTable.getInstance().createItem(57);
                this._adena.setOwnerId(this.getOwnerId());
                this._adena.setLocation(this.getBaseLocation());
                this._adena.setCount(adena);
                this._items.add(this._adena);
            } else {
                this._adena.setCount(adena);
            }
            if (dbUpdate) {
                this._adena.updateDatabase();
            }
        }
    }

    private void addAdena(L2ItemInstance adena, boolean dbUpdate) {
        this._adena = adena;
        this._adena.setOwnerId(this.getOwnerId());
        this._adena.setLocation(this.getBaseLocation());
        this._items.add(this._adena);
        if (dbUpdate) {
            this._adena.updateDatabase();
        }
    }

    public void addAdena(int adena) {
        this.addAdena(adena, true);
    }

    private void addAdena(int adena, boolean dbUpdate) {
        this.setAdena(this.getAdena() + adena, dbUpdate);
    }

    public void reduceAdena(int adena) {
        this.setAdena(this.getAdena() - adena, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] restoreVisibleInventory(int objectId) {
        int[][] paperdoll = new int[16][3];
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement2 = con.prepareStatement("SELECT object_id,item_id,loc_data,enchant_level FROM items WHERE owner_id=? AND loc='PAPERDOLL'");
            statement2.setInt(1, objectId);
            ResultSet invdata = statement2.executeQuery();
            while (invdata.next()) {
                int slot = invdata.getInt("loc_data");
                paperdoll[slot][0] = invdata.getInt("object_id");
                paperdoll[slot][1] = invdata.getInt("item_id");
                paperdoll[slot][2] = invdata.getInt("enchant_level");
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not restore inventory:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        return paperdoll;
    }
}

