/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.Random;
import java.util.Vector;
import net.sf.l2j.gameserver.SpawnTable;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2ControllableMobAI;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ControllableMobInstance;
import net.sf.l2j.gameserver.model.L2GroupSpawn;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class MobGroup {
    private L2NpcTemplate _template;
    private int _mobCount;
    private Vector<L2ControllableMobInstance> _mobs;
    private static final int RANDOM_RANGE = 300;

    public MobGroup(L2NpcTemplate template, int mobCount) {
        this._template = template;
        this._mobCount = mobCount;
    }

    public L2NpcTemplate get_template() {
        return this._template;
    }

    public void set_template(L2NpcTemplate _template) {
        this._template = _template;
    }

    public void spawnIt(int x, int y, int z) {
        if (this._mobs != null && this._mobs.size() > 0) {
            return;
        }
        this._mobs = new Vector();
        try {
            for (int i = 0; i < this._mobCount; ++i) {
                L2GroupSpawn spawn = new L2GroupSpawn(this._template);
                Random rnd = new Random();
                int signX = rnd.nextInt(2) == 0 ? -1 : 1;
                int signY = rnd.nextInt(2) == 0 ? -1 : 1;
                int randX = rnd.nextInt(300);
                int randY = rnd.nextInt(300);
                spawn.setLocx(x + signX * randX);
                spawn.setLocy(y + signY * randY);
                spawn.setLocz(z);
                spawn.stopRespawn();
                SpawnTable.getInstance().addNewSpawn(spawn, false);
                this._mobs.add((L2ControllableMobInstance)spawn.doGroupSpawn());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void spawnIt(L2PcInstance activeChar) {
        this.spawnIt(activeChar.getX(), activeChar.getY(), activeChar.getZ());
    }

    public L2ControllableMobInstance getAMob() {
        this.removeDead();
        Random rnd = new Random();
        System.out.println(this._mobs == null);
        if (this._mobs == null) {
            return null;
        }
        int choice = rnd.nextInt(this._mobs.size());
        System.out.println(choice + ":" + this._mobs.get(choice));
        return this._mobs.get(choice);
    }

    public void unspawn() {
        if (this._mobs == null) {
            return;
        }
        this.removeDead();
        for (int i = 0; i < this._mobs.size(); ++i) {
            if (!this._mobs.get(i).isDead()) {
                this._mobs.get(i).deleteMe();
            }
            SpawnTable.getInstance().deleteSpawn(this._mobs.get(i).getSpawn(), false);
        }
        this._mobs.clear();
    }

    public void kill(L2PcInstance activeChar) {
        if (this._mobs == null) {
            return;
        }
        this.removeDead();
        for (int i = 0; i < this._mobs.size(); ++i) {
            if (!this._mobs.get(i).isDead()) {
                this._mobs.get(i).reduceCurrentHp(this._mobs.get(i).getMaxHp() + 1, activeChar);
            }
            SpawnTable.getInstance().deleteSpawn(this._mobs.get(i).getSpawn(), false);
        }
        this._mobs.clear();
    }

    public void randomAttack() {
        if (this._mobs == null) {
            return;
        }
        this.removeDead();
        for (int i = 0; i < this._mobs.size(); ++i) {
            L2ControllableMobAI ai = (L2ControllableMobAI)this._mobs.get(i).getAI();
            ai.setAlternateAI(L2ControllableMobAI.AI_NORMAL);
            ai.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
    }

    public void attackTarget(L2Character target) {
        if (this._mobs == null) {
            return;
        }
        this.removeDead();
        for (int i = 0; i < this._mobs.size(); ++i) {
            L2ControllableMobAI ai = (L2ControllableMobAI)this._mobs.get(i).getAI();
            ai.forceAttack(target);
        }
    }

    public void idle() {
        if (this._mobs == null) {
            return;
        }
        this.removeDead();
        for (int i = 0; i < this._mobs.size(); ++i) {
            L2ControllableMobAI ai = (L2ControllableMobAI)this._mobs.get(i).getAI();
            ai.stop();
        }
    }

    public void returnToCharacter(L2Character activeChar) {
        if (this._mobs == null) {
            return;
        }
        this.idle();
        Random rnd = new Random();
        for (int i = 0; i < this._mobs.size(); ++i) {
            int signX = rnd.nextInt(2) == 0 ? -1 : 1;
            int signY = rnd.nextInt(2) == 0 ? -1 : 1;
            int randX = rnd.nextInt(300);
            int randY = rnd.nextInt(300);
            L2ControllableMobAI ai = (L2ControllableMobAI)this._mobs.get(i).getAI();
            ai.move(activeChar.getX() + signX * randX, activeChar.getY() + signY * randY, activeChar.getZ());
        }
    }

    public void follow(L2Character character) {
        if (this._mobs == null) {
            return;
        }
        this.removeDead();
        for (int i = 0; i < this._mobs.size(); ++i) {
            L2ControllableMobAI ai = (L2ControllableMobAI)this._mobs.get(i).getAI();
            ai.follow(character);
        }
    }

    public void setCastMode() {
        if (this._mobs == null) {
            return;
        }
        this.removeDead();
        for (int i = 0; i < this._mobs.size(); ++i) {
            L2ControllableMobAI ai = (L2ControllableMobAI)this._mobs.get(i).getAI();
            ai.setAlternateAI(L2ControllableMobAI.AI_CAST);
        }
    }

    public void setNoMoveMode(boolean enabled) {
        if (this._mobs == null) {
            return;
        }
        this.removeDead();
        for (int i = 0; i < this._mobs.size(); ++i) {
            L2ControllableMobAI ai = (L2ControllableMobAI)this._mobs.get(i).getAI();
            ai.setNoMove(enabled);
        }
    }

    protected void removeDead() {
        int i;
        if (this._mobs == null) {
            return;
        }
        Vector<L2ControllableMobInstance> deadMobs = new Vector<L2ControllableMobInstance>();
        for (i = 0; i < this._mobs.size(); ++i) {
            L2ControllableMobInstance mob = this._mobs.get(i);
            if (!mob.isDead()) continue;
            deadMobs.add(mob);
        }
        for (i = 0; i < deadMobs.size(); ++i) {
            this._mobs.remove(deadMobs.get(i));
        }
    }

    public void setInvul(boolean state2) {
        this.removeDead();
        for (int i = 0; i < this._mobs.size(); ++i) {
            this._mobs.get(i).setInvul(state2);
        }
    }

    public void setAttackGroup(MobGroup otherGrp) {
        if (this._mobs == null) {
            return;
        }
        this.removeDead();
        for (int i = 0; i < this._mobs.size(); ++i) {
            L2ControllableMobAI ai = (L2ControllableMobAI)this._mobs.get(i).getAI();
            ai.forceAttackGroup(otherGrp);
            ai.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
    }
}

