/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.Inventory;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.PcInventory;
import net.sf.l2j.gameserver.model.TradeItem;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L2TradeList {
    private static Logger _log = Logger.getLogger(L2TradeList.class.getName());
    private ArrayList<L2ItemInstance> _items = new ArrayList();
    private int _listId;
    private boolean _confirmed;
    private String _Buystorename;
    private String _Sellstorename;

    public L2TradeList(int listId) {
        this._listId = listId;
        this._confirmed = false;
    }

    public void addItem(L2ItemInstance item) {
        this._items.add(item);
    }

    public void replaceItem(int itemID, int price) {
        for (int i = 0; i < this._items.size(); ++i) {
            L2ItemInstance item = this._items.get(i);
            if (item.getItemId() != itemID) continue;
            item.setPriceToSell(price);
        }
    }

    public void removeItem(int itemID) {
        for (int i = 0; i < this._items.size(); ++i) {
            L2ItemInstance item = this._items.get(i);
            if (item.getItemId() != itemID) continue;
            this._items.remove(i);
        }
    }

    public int getListId() {
        return this._listId;
    }

    public void setSellStoreName(String name) {
        this._Sellstorename = name;
    }

    public String getSellStoreName() {
        return this._Sellstorename;
    }

    public void setBuyStoreName(String name) {
        this._Buystorename = name;
    }

    public String getBuyStoreName() {
        return this._Buystorename;
    }

    public ArrayList<L2ItemInstance> getItems() {
        return this._items;
    }

    public List<L2ItemInstance> getItems(int start, int end) {
        return this._items.subList(start, end);
    }

    public int getPriceForItemId(int itemId) {
        for (int i = 0; i < this._items.size(); ++i) {
            L2ItemInstance item = this._items.get(i);
            if (item.getItemId() != itemId) continue;
            return item.getPriceToSell();
        }
        return -1;
    }

    public L2ItemInstance getItem(int ObjectId) {
        for (int i = 0; i < this._items.size(); ++i) {
            L2ItemInstance item = this._items.get(i);
            if (item.getObjectId() != ObjectId) continue;
            return item;
        }
        return null;
    }

    public void setConfirmedTrade(boolean x) {
        this._confirmed = x;
    }

    public boolean hasConfirmed() {
        return this._confirmed;
    }

    public void removeItem(int objId, int count) {
        for (int y = 0; y < this._items.size(); ++y) {
            L2ItemInstance temp = this._items.get(y);
            if (temp.getObjectId() != objId) continue;
            if (count != temp.getCount()) break;
            this._items.remove(temp);
            break;
        }
    }

    public boolean contains(int objId) {
        boolean bool = false;
        for (int y = 0; y < this._items.size(); ++y) {
            L2ItemInstance temp = this._items.get(y);
            if (temp.getObjectId() != objId) continue;
            bool = true;
            break;
        }
        return bool;
    }

    public boolean validateTrade(L2PcInstance player, L2PcInstance reciever) {
        PcInventory playersInv = player.getInventory();
        for (int y = 0; y < this._items.size(); ++y) {
            L2ItemInstance temp = this._items.get(y);
            L2ItemInstance playerItem = ((Inventory)playersInv).getItemByObjectId(temp.getObjectId());
            if (playerItem == null || playerItem.getCount() >= temp.getCount()) continue;
            return false;
        }
        return true;
    }

    public void tradeItems(L2PcInstance player, L2PcInstance reciever) {
        PcInventory playersInv = player.getInventory();
        PcInventory recieverInv = reciever.getInventory();
        InventoryUpdate update2 = new InventoryUpdate();
        ItemTable itemTable = ItemTable.getInstance();
        for (int y = 0; y < this._items.size(); ++y) {
            L2ItemInstance temp = this._items.get(y);
            L2ItemInstance playerItem = ((Inventory)playersInv).getItemByObjectId(temp.getObjectId());
            if (playerItem == null) continue;
            L2ItemInstance newitem = itemTable.createItem(playerItem.getItemId());
            if (playerItem.getCount() < temp.getCount()) {
                newitem.setCount(playerItem.getCount());
            } else {
                newitem.setCount(temp.getCount());
            }
            newitem.setEnchantLevel(temp.getEnchantLevel());
            playerItem = playersInv.destroyItem(playerItem.getObjectId(), temp.getCount());
            L2ItemInstance recieverItem = recieverInv.addItem(newitem);
            if (playerItem.getLastChange() == 2) {
                update2.addModifiedItem(playerItem);
            } else {
                L2World world = L2World.getInstance();
                world.removeObject(playerItem);
                update2.addRemovedItem(playerItem);
            }
            player.sendPacket(update2);
            update2 = new InventoryUpdate();
            if (recieverItem.getLastChange() == 2) {
                update2.addModifiedItem(recieverItem);
            } else {
                update2.addNewItem(recieverItem);
            }
            reciever.sendPacket(update2);
        }
        StatusUpdate su = new StatusUpdate(player.getObjectId());
        su.addAttribute(StatusUpdate.CUR_LOAD, player.getCurrentLoad());
        player.sendPacket(su);
        su = new StatusUpdate(reciever.getObjectId());
        su.addAttribute(StatusUpdate.CUR_LOAD, reciever.getCurrentLoad());
        reciever.sendPacket(su);
    }

    public void updateBuyList(L2PcInstance player, ArrayList<TradeItem> list) {
        PcInventory playersInv = player.getInventory();
        for (int count = 0; count != list.size(); ++count) {
            TradeItem temp = list.get(count);
            L2ItemInstance temp2 = playersInv.findItemByItemId(temp.getItemId());
            if (temp2 == null) {
                list.remove(count);
                --count;
                continue;
            }
            if (temp.getCount() != 0) continue;
            list.remove(count);
            --count;
        }
    }

    public void updateSellList(L2PcInstance player, ArrayList<TradeItem> list) {
        PcInventory playersInv = player.getInventory();
        for (int count = 0; count != list.size(); ++count) {
            TradeItem temp = list.get(count);
            L2ItemInstance temp2 = ((Inventory)playersInv).getItemByObjectId(temp.getObjectId());
            if (temp2 == null) {
                list.remove(count);
                --count;
                continue;
            }
            if (temp2.getCount() >= temp.getCount()) continue;
            temp.setCount(temp2.getCount());
        }
    }

    public synchronized void BuySellItems(L2PcInstance buyer, ArrayList<TradeItem> buyerslist, L2PcInstance seller, ArrayList<TradeItem> sellerslist) {
        int x;
        PcInventory sellerInv = seller.getInventory();
        PcInventory buyerInv = buyer.getInventory();
        TradeItem temp2 = null;
        L2ItemInstance sellerItem = null;
        L2ItemInstance temp = null;
        L2ItemInstance newitem = null;
        L2ItemInstance adena = null;
        InventoryUpdate buyerupdate = new InventoryUpdate();
        InventoryUpdate sellerupdate = new InventoryUpdate();
        ItemTable itemTable = ItemTable.getInstance();
        boolean y = false;
        ArrayList<SystemMessage> sysmsgs = new ArrayList<SystemMessage>();
        SystemMessage msg = null;
        for (TradeItem buyerItem : buyerslist) {
            for (x = 0; x < sellerslist.size(); ++x) {
                temp2 = sellerslist.get(x);
                if (temp2.getItemId() != buyerItem.getItemId()) continue;
                sellerItem = sellerInv.findItemByItemId(buyerItem.getItemId());
                break;
            }
            if (sellerItem == null) continue;
            if (buyerItem.getCount() > temp2.getCount()) {
                int n = temp2.getCount();
            }
            int amount = buyerItem.getCount() > sellerItem.getCount() ? sellerItem.getCount() : buyerItem.getCount();
            if (buyerItem.getCount() > Integer.MAX_VALUE / buyerItem.getOwnersPrice()) {
                _log.warning("Integer Overflow on Cost. Possible Exploit attempt between " + buyer.getName() + " and " + seller.getName() + ".");
                return;
            }
            int cost = amount * buyerItem.getOwnersPrice();
            sellerItem = sellerInv.destroyItem(sellerItem.getObjectId(), amount);
            buyer.reduceAdena(cost);
            seller.addAdena(cost);
            newitem = itemTable.createItem(sellerItem.getItemId());
            newitem.setCount(amount);
            temp = buyerInv.addItem(newitem);
            if (amount == 1) {
                msg = new SystemMessage(378);
                msg.addString(buyer.getName());
                msg.addItemName(sellerItem.getItemId());
                sysmsgs.add(msg);
                msg = new SystemMessage(378);
                msg.addString("You");
                msg.addItemName(sellerItem.getItemId());
                sysmsgs.add(msg);
            } else {
                msg = new SystemMessage(380);
                msg.addString(buyer.getName());
                msg.addItemName(sellerItem.getItemId());
                msg.addNumber(amount);
                sysmsgs.add(msg);
                msg = new SystemMessage(380);
                msg.addString("You");
                msg.addItemName(sellerItem.getItemId());
                msg.addNumber(amount);
                sysmsgs.add(msg);
            }
            if (temp2.getCount() == buyerItem.getCount()) {
                sellerslist.remove(x);
                buyerItem.setCount(0);
            } else if (buyerItem.getCount() < temp2.getCount()) {
                temp2.setCount(temp2.getCount() - buyerItem.getCount());
            } else {
                buyerItem.setCount(buyerItem.getCount() - temp2.getCount());
            }
            if (sellerItem.getLastChange() == 2) {
                sellerupdate.addModifiedItem(sellerItem);
            } else {
                L2World world = L2World.getInstance();
                world.removeObject(sellerItem);
                sellerupdate.addRemovedItem(sellerItem);
            }
            if (temp.getLastChange() == 2) {
                buyerupdate.addModifiedItem(temp);
            } else {
                buyerupdate.addNewItem(temp);
            }
            sellerItem = null;
        }
        if (newitem != null) {
            adena = seller.getInventory().getAdenaInstance();
            adena.setLastChange(2);
            sellerupdate.addModifiedItem(adena);
            adena = buyer.getInventory().getAdenaInstance();
            adena.setLastChange(2);
            buyerupdate.addModifiedItem(adena);
            seller.sendPacket(sellerupdate);
            buyer.sendPacket(buyerupdate);
            y = false;
            for (x = 0; x < sysmsgs.size(); ++x) {
                if (!y) {
                    seller.sendPacket((ServerBasePacket)sysmsgs.get(x));
                    y = true;
                    continue;
                }
                buyer.sendPacket((ServerBasePacket)sysmsgs.get(x));
                y = false;
            }
        }
    }
}

