/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.concurrent.Future;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Summon;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class L2SummonInstance
extends L2Summon {
    private static Logger _log = Logger.getLogger(L2SummonInstance.class.getName());
    private float _expPenalty = 0.0f;
    private Future _disappearTask;

    public L2SummonInstance(int objectId, L2NpcTemplate template, L2PcInstance owner) {
        super(objectId, template, owner);
        this.setShowSummonAnimation(true);
        this._disappearTask = ClientScheduler.getInstance().scheduleLow(new Disappear(this.getOwner(), this), 1200000L);
    }

    public final int getLevel() {
        return this.getTemplate().level;
    }

    public int getSummonType() {
        return 1;
    }

    public void setExpPenalty(float expPenalty) {
        this._expPenalty = expPenalty;
    }

    public float getExpPenalty() {
        return this._expPenalty;
    }

    public void addExpAndSp(int addToExp, int addToSp) {
        this.getOwner().addExpAndSp(addToExp, addToSp);
    }

    public void reduceCurrentHp(int damage, L2Character attacker) {
        super.reduceCurrentHp(damage, attacker);
        SystemMessage sm = new SystemMessage(1027);
        if (attacker instanceof L2NpcInstance) {
            sm.addNpcName(((L2NpcInstance)attacker).getTemplate().npcId);
        } else {
            sm.addString(attacker.getName());
        }
        if (this.isDead()) {
            this._disappearTask.cancel(false);
            this._disappearTask = null;
        }
        sm.addNumber(damage);
        this.getOwner().sendPacket(sm);
    }

    protected void displayHitMessage(int damage, boolean crit, boolean miss) {
        if (crit) {
            this.getOwner().sendPacket(new SystemMessage(1028));
        }
        if (miss) {
            this.getOwner().sendPacket(new SystemMessage(43));
        } else {
            SystemMessage sm = new SystemMessage(1026);
            sm.addNumber(damage);
            this.getOwner().sendPacket(sm);
        }
    }

    public void removeItemFromInventory(L2ItemInstance item, int count) {
        this.getOwner().removeItemFromInventory(item, count);
    }

    static class Disappear
    implements Runnable {
        private L2PcInstance _activeChar;
        private L2SummonInstance _summon;

        Disappear(L2PcInstance activeChar, L2SummonInstance newpet) {
            this._activeChar = activeChar;
            this._summon = newpet;
        }

        public void run() {
            this._summon.PetdeleteMe(this._activeChar);
        }
    }
}

