/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.Announcements;
import net.sf.l2j.gameserver.model.ClassId;
import net.sf.l2j.gameserver.model.L2ArtefactInstance;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2ClanMember;
import net.sf.l2j.gameserver.model.L2DoorInstance;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2Party;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2PetInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2Summon;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.Condition;
import net.sf.l2j.gameserver.skills.EffectTemplate;
import net.sf.l2j.gameserver.skills.Env;
import net.sf.l2j.gameserver.skills.Func;
import net.sf.l2j.gameserver.skills.FuncTemplate;
import net.sf.l2j.gameserver.skills.L2SkillCharge;
import net.sf.l2j.gameserver.skills.L2SkillChargeDmg;
import net.sf.l2j.gameserver.skills.L2SkillDefault;
import net.sf.l2j.gameserver.skills.L2SkillDrain;
import net.sf.l2j.gameserver.skills.L2SkillElemental;
import net.sf.l2j.gameserver.skills.L2SkillNegate;
import net.sf.l2j.gameserver.skills.L2SkillSeed;
import net.sf.l2j.gameserver.skills.L2SkillSummon;
import net.sf.l2j.gameserver.skills.Stats;
import net.sf.l2j.gameserver.templates.L2WeaponType;
import net.sf.l2j.gameserver.templates.StatsSet;

public abstract class L2Skill {
    protected static Logger _log = Logger.getLogger(L2Skill.class.getName());
    public static final int SKILL_CUBIC_MASTERY = 143;
    public static final int SKILL_LUCKY = 194;
    public static final int SKILL_CRAFTING = 172;
    public static final int SKILL_CRYSTALLIZE = 248;
    public static final int SKILL_FAKE_INT = 9001;
    public static final int SKILL_FAKE_WIT = 9002;
    public static final int SKILL_FAKE_MEN = 9003;
    public static final int SKILL_FAKE_CON = 9004;
    public static final int SKILL_FAKE_DEX = 9005;
    public static final int SKILL_FAKE_STR = 9006;
    public static final int ELEMENT_WIND = 1;
    public static final int ELEMENT_FIRE = 2;
    public static final int ELEMENT_WATER = 3;
    public static final int ELEMENT_EARTH = 4;
    public static final int ELEMENT_HOLY = 5;
    public static final int SAVEVS_INT = 1;
    public static final int SAVEVS_WIT = 2;
    public static final int SAVEVS_MEN = 3;
    public static final int SAVEVS_CON = 4;
    public static final int SAVEVS_DEX = 5;
    public static final int SAVEVS_STR = 6;
    public static final int STAT_PATK = 301;
    public static final int STAT_PDEF = 302;
    public static final int STAT_MATK = 303;
    public static final int STAT_MDEF = 304;
    public static final int STAT_MAXHP = 305;
    public static final int STAT_MAXMP = 306;
    public static final int STAT_CURHP = 307;
    public static final int STAT_CURMP = 308;
    public static final int STAT_HPREGEN = 309;
    public static final int STAT_MPREGEN = 310;
    public static final int STAT_CASTINGSPEED = 311;
    public static final int STAT_ATKSPD = 312;
    public static final int STAT_CRITDAM = 313;
    public static final int STAT_CRITRATE = 314;
    public static final int STAT_FIRERES = 315;
    public static final int STAT_WINDRES = 316;
    public static final int STAT_WATERRES = 317;
    public static final int STAT_EARTHRES = 318;
    public static final int STAT_ROOTRES = 319;
    public static final int STAT_SLEEPRES = 320;
    public static final int STAT_CONFUSIONRES = 321;
    public static final int STAT_BREATH = 322;
    public static final int STAT_AGGRESSION = 323;
    public static final int STAT_BLEED = 324;
    public static final int STAT_POISON = 325;
    public static final int STAT_STUN = 326;
    public static final int STAT_ROOT = 327;
    public static final int STAT_MOVEMENT = 328;
    public static final int STAT_EVASION = 329;
    public static final int STAT_ACCURACY = 330;
    public static final int STAT_COMBAT_STRENGTH = 331;
    public static final int STAT_COMBAT_WEAKNESS = 332;
    public static final int STAT_ATTACK_RANGE = 333;
    public static final int STAT_NOAGG = 334;
    public static final int STAT_SHIELDDEF = 335;
    public static final int COMBAT_MOD_ANIMAL = 200;
    public static final int COMBAT_MOD_BEAST = 201;
    public static final int COMBAT_MOD_BUG = 202;
    public static final int COMBAT_MOD_DRAGON = 203;
    public static final int COMBAT_MOD_MONSTER = 204;
    public static final int COMBAT_MOD_PLANT = 205;
    public static final int COMBAT_MOD_HOLY = 206;
    public static final int COMBAT_MOD_UNHOLY = 207;
    public static final int COMBAT_MOD_BOW = 208;
    public static final int COMBAT_MOD_BLUNT = 209;
    public static final int COMBAT_MOD_DAGGER = 210;
    public static final int COMBAT_MOD_FIST = 211;
    public static final int COMBAT_MOD_DUAL = 212;
    public static final int COMBAT_MOD_SWORD = 213;
    public static final int COMBAT_MOD_POISON = 214;
    public static final int COMBAT_MOD_BLEED = 215;
    public static final int COMBAT_MOD_FIRE = 216;
    public static final int COMBAT_MOD_WATER = 217;
    public static final int COMBAT_MOD_EARTH = 218;
    public static final int COMBAT_MOD_WIND = 219;
    public static final int COMBAT_MOD_ROOT = 220;
    public static final int COMBAT_MOD_STUN = 221;
    public static final int COMBAT_MOD_CONFUSION = 222;
    public static final int COND_RUNNING = 1;
    public static final int COND_WALKING = 2;
    public static final int COND_SIT = 4;
    public static final int COND_BEHIND = 8;
    public static final int COND_CRIT = 16;
    public static final int COND_LOWHP = 32;
    public static final int COND_ROBES = 64;
    public static final int COND_CHARGES = 128;
    public static final int COND_SHIELD = 256;
    public static final int COND_GRADEA = 65536;
    public static final int COND_GRADEB = 131072;
    public static final int COND_GRADEC = 262144;
    public static final int COND_GRADED = 524288;
    public static final int COND_GRADES = 0x100000;
    private static final Func[] _emptyFunctionSet = new Func[0];
    private static final L2Effect[] _emptyEffectSet = new L2Effect[0];
    private final int _id;
    private final int _level;
    private int _displayId;
    private final String _name;
    private final SkillOpType _operateType;
    private final boolean _magic;
    private final int _mpConsume;
    private final int _hpConsume;
    private final int _itemConsume;
    private final int _itemConsumeId;
    private final int _castRange;
    private final int _skillTime;
    private final int _skillInterruptTime;
    private final int _hitTime;
    private final int _reuseDelay;
    private final int _buffDuration;
    private final SkillTargetType _targetType;
    private final double _power;
    private final SkillType _skillType;
    private final int _element;
    private final int _savevs;
    private final Stats _stat;
    private final int _condition;
    private final int _conditionValue;
    private final boolean _overhit;
    private final int _weaponsAllowed;
    private final int _armorsAllowed;
    private final int _addCrossLearn;
    private final float _mulCrossLearn;
    private final float _mulCrossLearnRace;
    private final float _mulCrossLearnProf;
    private final ArrayList<ClassId> _canLearn;
    private final ArrayList<Integer> _teachers;
    protected Condition _preCondition;
    protected FuncTemplate[] _funcTemplates;
    protected EffectTemplate[] _effectTemplates;

    protected L2Skill(StatsSet set2) {
        this._id = set2.getInteger("skill_id");
        this._level = set2.getInteger("level");
        this._displayId = set2.getInteger("displayId", this._id);
        this._name = set2.getString("name");
        this._operateType = set2.getEnum("operateType", SkillOpType.class);
        this._magic = set2.getBool("isMagic", false);
        this._mpConsume = set2.getInteger("mpConsume", 0);
        this._hpConsume = set2.getInteger("hpConsume", 0);
        this._itemConsume = set2.getInteger("itemConsumeCount", 0);
        this._itemConsumeId = set2.getInteger("itemConsumeId", 0);
        this._castRange = set2.getInteger("castRange", 0);
        this._skillTime = set2.getInteger("skillTime", 0);
        this._skillInterruptTime = set2.getInteger("skillTime", this._skillTime / 2);
        this._hitTime = set2.getInteger("hitTime", 0);
        this._reuseDelay = set2.getInteger("reuseDelay", 0);
        this._buffDuration = set2.getInteger("buffDuration", 0);
        this._targetType = set2.getEnum("target", SkillTargetType.class);
        this._power = set2.getFloat("power", 0.0f);
        this._stat = set2.getEnum("stat", Stats.class, null);
        this._skillType = set2.getEnum("skillType", SkillType.class);
        this._element = set2.getInteger("element", 0);
        this._savevs = set2.getInteger("save", 0);
        this._condition = set2.getInteger("condition", 0);
        this._conditionValue = set2.getInteger("conditionValue", 0);
        this._overhit = set2.getBool("overHit", false);
        this._weaponsAllowed = set2.getInteger("weaponsAllowed", 0);
        this._armorsAllowed = set2.getInteger("armorsAllowed", 0);
        this._addCrossLearn = set2.getInteger("addCrossLearn", 1000);
        this._mulCrossLearn = set2.getFloat("mulCrossLearn", 2.0f);
        this._mulCrossLearnRace = set2.getFloat("mulCrossLearnRace", 2.0f);
        this._mulCrossLearnProf = set2.getFloat("mulCrossLearnProf", 3.0f);
        String canLearn = set2.getString("canLearn", null);
        if (canLearn == null) {
            this._canLearn = null;
        } else {
            this._canLearn = new ArrayList();
            StringTokenizer st = new StringTokenizer(canLearn, " \r\n\t,;");
            while (st.hasMoreTokens()) {
                String cls = st.nextToken();
                try {
                    this._canLearn.add(ClassId.valueOf(cls));
                }
                catch (Throwable t) {
                    _log.log(Level.SEVERE, "Bad class " + cls + " to learn skill", t);
                }
            }
        }
        String teachers = set2.getString("teachers", null);
        if (teachers == null) {
            this._teachers = null;
        } else {
            this._teachers = new ArrayList();
            StringTokenizer st = new StringTokenizer(teachers, " \r\n\t,;");
            while (st.hasMoreTokens()) {
                String npcid = st.nextToken();
                try {
                    this._teachers.add(Integer.parseInt(npcid));
                }
                catch (Throwable t) {
                    _log.log(Level.SEVERE, "Bad teacher id " + npcid + " to teach skill", t);
                }
            }
        }
    }

    public abstract void useSkill(L2Character var1, L2Object[] var2);

    public final int getArmorsAllowed() {
        return this._armorsAllowed;
    }

    public final int getConditionValue() {
        return this._conditionValue;
    }

    public final SkillType getSkillType() {
        return this._skillType;
    }

    public final int getSavevs() {
        return this._savevs;
    }

    public final int getElement() {
        return this._element;
    }

    public final SkillTargetType getTargetType() {
        return this._targetType;
    }

    public final int getCondition() {
        return this._condition;
    }

    public final boolean isOverhit() {
        return this._overhit;
    }

    public final double getPower() {
        return this._power;
    }

    public final int getBuffDuration() {
        return this._buffDuration;
    }

    public final int getCastRange() {
        return this._castRange;
    }

    public final int getHitTime() {
        return this._hitTime;
    }

    public final int getHpConsume() {
        return this._hpConsume;
    }

    public final int getId() {
        return this._id;
    }

    public int getDisplayId() {
        return this._displayId;
    }

    public void setDisplayId(int id) {
        this._displayId = id;
    }

    public final Stats getStat() {
        return this._stat;
    }

    public final int getItemConsume() {
        return this._itemConsume;
    }

    public final int getItemConsumeId() {
        return this._itemConsumeId;
    }

    public final int getLevel() {
        return this._level;
    }

    public final boolean isMagic() {
        return this._magic;
    }

    public final int getMpConsume() {
        return this._mpConsume;
    }

    public final String getName() {
        return this._name;
    }

    public final int getReuseDelay() {
        return this._reuseDelay;
    }

    public final int getSkillTime() {
        return this._skillTime;
    }

    public final int getSkillInterruptTime() {
        return this._skillInterruptTime;
    }

    public final boolean isActive() {
        return this._operateType == SkillOpType.OP_ACTIVE;
    }

    public final boolean isPassive() {
        return this._operateType == SkillOpType.OP_PASSIVE;
    }

    public final boolean isToggle() {
        return this._operateType == SkillOpType.OP_TOGGLE;
    }

    public final int getWeaponsAllowed() {
        return this._weaponsAllowed;
    }

    public final int getCrossLearnAdd() {
        return this._addCrossLearn;
    }

    public final float getCrossLearnMul() {
        return this._mulCrossLearn;
    }

    public final float getCrossLearnRace() {
        return this._mulCrossLearnRace;
    }

    public final float getCrossLearnProf() {
        return this._mulCrossLearnProf;
    }

    public final boolean getCanLearn(ClassId cls) {
        return this._canLearn == null || this._canLearn.contains((Object)cls);
    }

    public final boolean canTeachBy(int npcId) {
        return this._teachers == null || this._teachers.contains(npcId);
    }

    public final boolean isOffensive() {
        switch (this._skillType) {
            case PDAM: 
            case MDAM: 
            case DOT: 
            case BLEED: 
            case POISON: 
            case AGGDAMAGE: 
            case DEBUFF: 
            case STUN: 
            case ROOT: 
            case CONFUSION: 
            case UNLOCK: 
            case FEAR: 
            case DRAIN: 
            case SLEEP: 
            case CHARGEDAM: 
            case CONFUSE_MOB_ONLY: 
            case DEATHLINK: 
            case DETECT_WEAKNESS: 
            case MANADAM: 
            case MDOT: 
            case MUTE: 
            case SOULSHOT: 
            case SPIRITSHOT: 
            case SPOIL: 
            case WEAKNESS: 
            case MANA_BY_LEVEL: 
            case SWEEP: 
            case PARALYZE: {
                return true;
            }
        }
        return false;
    }

    public final boolean getWeaponDependancy(L2Character activeChar) {
        int weaponsAllowed = this.getWeaponsAllowed();
        if (weaponsAllowed == 0) {
            return true;
        }
        if (activeChar.getActiveWeaponItem() != null) {
            L2WeaponType playerWeapon = activeChar.getActiveWeaponItem().getItemType();
            int mask = playerWeapon.mask();
            if ((mask & weaponsAllowed) != 0) {
                return true;
            }
            if (activeChar.getSecondaryWeaponItem() != null && ((mask = (playerWeapon = activeChar.getSecondaryWeaponItem().getItemType()).mask()) & weaponsAllowed) != 0) {
                return true;
            }
        }
        StringBuffer skillmsg = new StringBuffer();
        skillmsg.append(this.getName());
        skillmsg.append(" can only be used with weapons of type ");
        for (L2WeaponType wt : L2WeaponType.values()) {
            if ((wt.mask() & weaponsAllowed) == 0) continue;
            skillmsg.append((Object)wt).append('/');
        }
        skillmsg.setCharAt(skillmsg.length() - 1, '.');
        SystemMessage message = new SystemMessage(614);
        message.addString(skillmsg.toString());
        activeChar.sendPacket(message);
        return false;
    }

    public boolean checkCondition(L2Character activeChar) {
        if ((this.getCondition() & 8) != 0 && !activeChar.isBehindTarget()) {
            return false;
        }
        if ((this.getCondition() & 0x100) != 0) {
            // empty if block
        }
        if (this._preCondition == null) {
            return true;
        }
        Env env = new Env();
        env._player = activeChar;
        env._skill = this;
        if (!this._preCondition.test(env)) {
            String msg = this._preCondition.getMessage();
            if (msg != null) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString(msg);
                activeChar.sendPacket(sm);
            }
            return false;
        }
        return true;
    }

    public final L2Object[] getTargetList(L2Character activeChar) {
        ArrayList<L2Character> targetList = new ArrayList<L2Character>();
        SkillTargetType targetType = this.getTargetType();
        L2Character target = null;
        L2Object objTarget = activeChar.getTarget();
        SkillType skillType = this.getSkillType();
        if (objTarget instanceof L2Character) {
            target = (L2Character)objTarget;
        }
        switch (targetType) {
            case TARGET_ONE: {
                if (target == null || target.isDead() || target == activeChar && skillType != SkillType.BUFF && skillType != SkillType.HEAL && skillType != SkillType.MANAHEAL && skillType != SkillType.HOT && skillType != SkillType.REFLECT && skillType != SkillType.NEGATE) {
                    activeChar.sendPacket(new SystemMessage(144));
                    return null;
                }
                return new L2Character[]{target};
            }
            case TARGET_SELF: {
                return new L2Character[]{activeChar};
            }
            case TARGET_HOLY: {
                int currentCastle;
                L2Character[] returnVal = null;
                if (!(activeChar instanceof L2PcInstance)) {
                    return null;
                }
                L2Object tempTarget = ((L2PcInstance)activeChar).getTarget();
                if (tempTarget instanceof L2ArtefactInstance && (currentCastle = L2Siege.getSiege() - 1) != -1) {
                    int x1 = L2World.castlewinareas[currentCastle][0];
                    int y1 = L2World.castlewinareas[currentCastle][1];
                    int x2 = L2World.castlewinareas[currentCastle][2];
                    int y2 = L2World.castlewinareas[currentCastle][3];
                    int z = L2World.castlewinareas[currentCastle][4];
                    if (activeChar.getX() >= Math.min(x1, x2) && activeChar.getX() <= Math.max(x1, x2) && activeChar.getY() >= Math.min(y1, y2) && activeChar.getY() <= Math.max(y1, y2) && activeChar.getZ() <= z + 30 && activeChar.getZ() >= z - 30) {
                        returnVal = new L2Character[]{(L2ArtefactInstance)tempTarget};
                        Announcements anounce = new Announcements();
                        anounce.announceToAll(activeChar.getName() + " is attempting to seal the Holy Artifact!");
                    }
                }
                return returnVal;
            }
            case TARGET_PET: {
                L2Summon summon;
                if (activeChar instanceof L2PcInstance && (summon = ((L2PcInstance)activeChar).getPet()) != null) {
                    return new L2Character[]{summon};
                }
                return null;
            }
            case TARGET_AURA: {
                L2Object[] possibleTargets = L2World.getInstance().getVisibleObjects3D(activeChar, 205);
                for (int i = 0; i < possibleTargets.length; ++i) {
                    if (!(possibleTargets[i] instanceof L2Attackable)) continue;
                    targetList.add((L2Character)possibleTargets[i]);
                }
                return targetList.toArray(new L2Character[targetList.size()]);
            }
            case TARGET_AURA_CLOSE: {
                L2Object[] possibleTargets = L2World.getInstance().getVisibleObjects3D(activeChar, 80);
                for (int i = 0; i < possibleTargets.length; ++i) {
                    if (!(possibleTargets[i] instanceof L2Attackable)) continue;
                    targetList.add((L2Character)possibleTargets[i]);
                }
                return targetList.toArray(new L2Character[targetList.size()]);
            }
            case TARGET_AREA: {
                if (!(target instanceof L2Attackable) && !(target instanceof L2PcInstance) || target.isAlikeDead()) {
                    activeChar.sendPacket(new SystemMessage(144));
                    return null;
                }
                L2Object[] possibleTargets = L2World.getInstance().getVisibleObjects3D(target, 205);
                for (int i = 0; i < possibleTargets.length; ++i) {
                    if (!(possibleTargets[i] instanceof L2Attackable) || (target = (L2Character)possibleTargets[i]).isAlikeDead()) continue;
                    targetList.add((L2Character)possibleTargets[i]);
                }
                targetList.add((L2Character)activeChar.getTarget());
                return targetList.toArray(new L2Character[targetList.size()]);
            }
            case TARGET_MULTIFACE: {
                if (!(target instanceof L2Attackable) && !(target instanceof L2PcInstance)) {
                    activeChar.sendPacket(new SystemMessage(144));
                    return null;
                }
                targetList.add(target);
                L2Object[] possibleTargets = L2World.getInstance().getVisibleObjects3D(activeChar, 60);
                for (int i = 0; i < possibleTargets.length; ++i) {
                    if (possibleTargets[i] instanceof L2Attackable && possibleTargets[i] != target) {
                        targetList.add((L2Character)possibleTargets[i]);
                    }
                    if (targetList.size() != 0) continue;
                    activeChar.sendPacket(new SystemMessage(50));
                    return null;
                }
                return targetList.toArray(new L2Character[targetList.size()]);
            }
            case TARGET_PARTY: {
                if (activeChar instanceof L2PcInstance) {
                    L2PcInstance player = (L2PcInstance)activeChar;
                    L2Party party = player.getParty();
                    if (party != null) {
                        ArrayList<L2PcInstance> partyList = party.getPartyMembers();
                        L2Character partyMember = null;
                        for (int i = 0; i < partyList.size(); ++i) {
                            partyMember = partyList.get(i);
                            if (partyMember.isDead()) continue;
                            targetList.add(partyMember);
                        }
                    } else {
                        targetList.add(player);
                    }
                }
                return targetList.toArray(new L2Character[targetList.size()]);
            }
            case TARGET_CLAN: {
                if (activeChar instanceof L2PcInstance) {
                    L2PcInstance player = (L2PcInstance)activeChar;
                    L2Clan clan = player.getClan();
                    if (clan != null) {
                        L2ClanMember[] clanMembers = clan.getMembers();
                        for (int i = 0; i < clanMembers.length; ++i) {
                            L2PcInstance member = clanMembers[i].getPlayerInstance();
                            if (member == null || member.isOnline() == 0 || member.isDead()) continue;
                            targetList.add(clanMembers[i].getPlayerInstance());
                        }
                    } else {
                        activeChar.sendPacket(new SystemMessage(234));
                        return null;
                    }
                }
                return targetList.toArray(new L2Character[targetList.size()]);
            }
            case TARGET_CORPSE_PLAYER: {
                if (!(target instanceof L2PcInstance) && !(target instanceof L2PetInstance) || !target.isDead()) {
                    activeChar.sendPacket(new SystemMessage(144));
                    return null;
                }
                targetList.add(target);
                return targetList.toArray(new L2Object[targetList.size()]);
            }
            case TARGET_CORPSE_MOB: {
                if (!(target instanceof L2Attackable) || !target.isDead()) {
                    activeChar.sendPacket(new SystemMessage(144));
                    return null;
                }
                targetList.add(target);
                return targetList.toArray(new L2Object[targetList.size()]);
            }
            case TARGET_CORPSE_CLAN: {
                L2PcInstance player = (L2PcInstance)activeChar;
                L2Clan clan = player.getClan();
                if (clan != null) {
                    L2ClanMember[] clanMembers = clan.getMembers();
                    for (int i = 0; i < clanMembers.length; ++i) {
                        if (!clanMembers[i].getPlayerInstance().isDead()) continue;
                        targetList.add(clanMembers[i].getPlayerInstance());
                    }
                    return targetList.toArray(new L2Object[targetList.size()]);
                }
                activeChar.sendPacket(new SystemMessage(234));
                return null;
            }
            case TARGET_UNLOCKABLE: {
                if (!(target instanceof L2DoorInstance)) {
                    activeChar.sendPacket(new SystemMessage(144));
                    return null;
                }
                targetList.add(target);
                return targetList.toArray(new L2Object[targetList.size()]);
            }
            case TARGET_ITEM: {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Target type of skill is not currently handled");
                activeChar.sendPacket(sm);
                return null;
            }
            case TARGET_UNDEAD: {
                if (!(target instanceof L2NpcInstance)) break;
                if (!((L2NpcInstance)target).isUndead()) {
                    activeChar.sendPacket(new SystemMessage(144));
                    return null;
                }
                targetList.add(target);
                return targetList.toArray(new L2Object[targetList.size()]);
            }
        }
        SystemMessage sm = new SystemMessage(614);
        sm.addString("Target type of skill is not currently handled");
        activeChar.sendPacket(sm);
        return null;
    }

    public final Func[] getStatFuncs(L2Effect effect, L2Character player) {
        if (!(player instanceof L2PcInstance)) {
            return _emptyFunctionSet;
        }
        if (this._funcTemplates == null) {
            return _emptyFunctionSet;
        }
        ArrayList<Func> funcs = new ArrayList<Func>();
        for (FuncTemplate t : this._funcTemplates) {
            Env env = new Env();
            env._player = player;
            env._skill = this;
            Func f = t.getFunc(env, this);
            if (f == null) continue;
            funcs.add(f);
        }
        if (funcs.size() == 0) {
            return _emptyFunctionSet;
        }
        return funcs.toArray(new Func[funcs.size()]);
    }

    public final L2Effect[] getEffects(L2Character effector, L2Character effected) {
        if (this.isPassive()) {
            return _emptyEffectSet;
        }
        if (this._effectTemplates == null) {
            return _emptyEffectSet;
        }
        ArrayList<L2Effect> effects = new ArrayList<L2Effect>();
        for (EffectTemplate et : this._effectTemplates) {
            Env env = new Env();
            env._player = effector;
            env._target = effected;
            env._skill = this;
            L2Effect e = et.getEffect(env);
            if (e == null) continue;
            effects.add(e);
        }
        if (effects.size() == 0) {
            return _emptyEffectSet;
        }
        return effects.toArray(new L2Effect[effects.size()]);
    }

    public final void attach(FuncTemplate f) {
        if (this._funcTemplates == null) {
            this._funcTemplates = new FuncTemplate[]{f};
        } else {
            int len = this._funcTemplates.length;
            FuncTemplate[] tmp = new FuncTemplate[len + 1];
            System.arraycopy(this._funcTemplates, 0, tmp, 0, len);
            tmp[len] = f;
            this._funcTemplates = tmp;
        }
    }

    public final void attach(EffectTemplate effect) {
        if (this._effectTemplates == null) {
            this._effectTemplates = new EffectTemplate[]{effect};
        } else {
            int len = this._effectTemplates.length;
            EffectTemplate[] tmp = new EffectTemplate[len + 1];
            System.arraycopy(this._effectTemplates, 0, tmp, 0, len);
            tmp[len] = effect;
            this._effectTemplates = tmp;
        }
    }

    public final void attach(Condition c) {
        this._preCondition = c;
    }

    public String toString() {
        return "" + this._name + "[id=" + this._id + ",lvl=" + this._level + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SkillType {
        PDAM,
        MDAM,
        DOT,
        BLEED,
        POISON,
        HEAL,
        HOT,
        MANAHEAL,
        AGGDAMAGE,
        BUFF,
        DEBUFF,
        STUN,
        ROOT,
        RESURRECT,
        PASSIVE,
        CONT,
        CONFUSION,
        UNLOCK,
        CHARGE(L2SkillCharge.class),
        FEAR,
        MHOT,
        DRAIN(L2SkillDrain.class),
        NEGATE(L2SkillNegate.class),
        SLEEP,
        AGGREDUCE,
        AGGREMOVE,
        AGGREDUCE_CHAR,
        CHARGEDAM(L2SkillChargeDmg.class),
        CONFUSE_MOB_ONLY,
        DEATHLINK,
        DETECT_WEAKNESS,
        ENCHANT_ARMOR,
        ENCHANT_WEAPON,
        FEED_PET,
        HEAL_PERCENT,
        LUCK,
        MANADAM,
        MDOT,
        MUTE,
        RECALL,
        REFLECT,
        SOULSHOT,
        SPIRITSHOT,
        SPOIL,
        SWEEP,
        SUMMON(L2SkillSummon.class),
        WEAKNESS,
        DEATHLINK_PET,
        MANA_BY_LEVEL,
        FAKE_DEATH,
        UNBLEED,
        UNPOISON,
        SIEGEFLAG,
        TAKECASTLE,
        UNDEAD_DEFENSE,
        SEED(L2SkillSeed.class),
        MDAM_ELEMENTAL(L2SkillElemental.class),
        PARALYZE,
        NOTDONE;

        private final Class<? extends L2Skill> clazz;

        public L2Skill makeSkill(StatsSet set2) {
            try {
                Constructor<? extends L2Skill> c = this.clazz.getConstructor(StatsSet.class);
                return c.newInstance(set2);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private SkillType() {
            this.clazz = L2SkillDefault.class;
        }

        private SkillType(Class<? extends L2Skill> clazz) {
            this.clazz = clazz;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SkillTargetType {
        TARGET_NONE,
        TARGET_SELF,
        TARGET_ONE,
        TARGET_PARTY,
        TARGET_CLAN,
        TARGET_PET,
        TARGET_AREA,
        TARGET_AURA,
        TARGET_CORPSE,
        TARGET_UNDEAD,
        TARGET_MULTIFACE,
        TARGET_AURA_CLOSE,
        TARGET_CORPSE_CLAN,
        TARGET_CORPSE_PLAYER,
        TARGET_ITEM,
        TARGET_AREA_CORPSE_MOB,
        TARGET_CORPSE_MOB,
        TARGET_UNLOCKABLE,
        TARGET_HOLY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SkillOpType {
        OP_PASSIVE,
        OP_ACTIVE,
        OP_TOGGLE;

    }
}

