/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.Random;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2CharacterAI;
import net.sf.l2j.gameserver.ai.L2SiegeGuardAI;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2PetInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.gameserver.serverpackets.NpcInfo;
import net.sf.l2j.gameserver.serverpackets.SocialAction;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.ValidateLocation;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public final class L2SiegeGuardInstance
extends L2Attackable {
    private final Random _rnd = new Random();
    private int _homeX;
    private int _homeY;
    private int _homeZ;

    public L2SiegeGuardInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2CharacterAI getAI() {
        if (this._ai == null) {
            L2SiegeGuardInstance l2SiegeGuardInstance = this;
            synchronized (l2SiegeGuardInstance) {
                if (this._ai == null) {
                    this._ai = new L2SiegeGuardAI(new L2Character.AIAccessor());
                }
            }
        }
        return this._ai;
    }

    public boolean isAutoAttackable(L2Character attacker) {
        if (attacker instanceof L2PcInstance) {
            return !L2Siege.isDefender(((L2PcInstance)attacker).getClanId()) && L2Siege.getSiege() > 0;
        }
        return false;
    }

    public boolean addKnownObject(L2Object object, L2Character dropper) {
        L2PcInstance player;
        boolean ret = super.addKnownObject(object, dropper);
        if (!ret) {
            return false;
        }
        if (this._homeX == 0) {
            this.getHomeLocation();
        }
        if (object instanceof L2PcInstance && !L2Siege.isDefender((player = (L2PcInstance)object).getClanId()) && L2Siege.getSiege() > 0 && this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
        }
        if (object instanceof L2PetInstance && !L2Siege.isDefender((player = ((L2PetInstance)object).getOwner()).getClanId()) && L2Siege.getSiege() > 0 && this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
        }
        return ret;
    }

    public void removeKnownObject(L2Object object) {
        super.removeKnownObject(object);
        if (this.noTarget()) {
            this.clearAggroList();
            this.removeAllKnownObjects();
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
            this.returnHome();
        }
    }

    private void getHomeLocation() {
        this._homeX = this.getX();
        this._homeY = this.getY();
        this._homeZ = this.getZ();
        if (Config.DEBUG) {
            _log.finer(this.getObjectId() + ": Home location set to" + " X:" + this._homeX + " Y:" + this._homeY + " Z:" + this._homeZ);
        }
    }

    public int getHomeX() {
        return this._homeX;
    }

    public int getHomeY() {
        return this._homeY;
    }

    public void returnHome() {
        if (this.getDistance(this._homeX, this._homeY) > 40.0) {
            if (Config.DEBUG) {
                _log.fine(this.getObjectId() + ": moving home");
            }
            this.clearAggroList();
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(this._homeX, this._homeY, this._homeZ, 0));
        }
    }

    public void onAction(L2PcInstance player) {
        if (this != player.getTarget()) {
            if (Config.DEBUG) {
                _log.fine("new target selected:" + this.getObjectId());
            }
            NpcInfo npcInfo = new NpcInfo(this, (L2Character)player);
            player.sendPacket(npcInfo);
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            StatusUpdate su = new StatusUpdate(this.getObjectId());
            su.addAttribute(StatusUpdate.CUR_HP, (int)this.getCurrentHp());
            su.addAttribute(StatusUpdate.MAX_HP, this.getMaxHp());
            player.sendPacket(su);
            player.sendPacket(new ValidateLocation(this));
        } else {
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            if (this.isAutoAttackable(player) && !this.isAlikeDead()) {
                if (Math.abs(player.getZ() - this.getZ()) < 600) {
                    player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
                } else {
                    player.sendPacket(new ActionFailed());
                }
            }
            if (!this.isAutoAttackable(player)) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
                double distance = this.getDistance(player.getX(), player.getY());
                if (!(distance > 150.0)) {
                    SocialAction sa = new SocialAction(this.getObjectId(), this._rnd.nextInt(8));
                    this.broadcastPacket(sa);
                    this.sendPacket(sa);
                    this.showChatWindow(player, 0);
                    player.sendPacket(new ActionFailed());
                }
            }
        }
    }
}

