/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.io.BufferedReader;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.Announcements;
import net.sf.l2j.gameserver.ClanTable;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.DoorTable;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.MapRegionTable;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.SkillTable;
import net.sf.l2j.gameserver.model.L2ArtefactInstance;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.Location;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.StopMove;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class L2Siege {
    private static final int MAX_ATTACKERS = 8;
    private static final int MAX_DEFENDERS = 8;
    private static final String STORE_SIEGE_CLAN = "INSERT INTO siege_clans (clan_id,castle_id,type) values (?,?,?)";
    private static final String GET_SIEGE_CLANS = "SELECT clan_id,type,castle_owner FROM siege_clans where castle_id=?";
    protected static int _siege = 0;
    private static int _lastSiege = 0;
    private static L2Clan[] attackingClans = new L2Clan[8];
    private static L2Clan[] defendingClans = new L2Clan[8];
    private static ArrayList<LinkedList<L2NpcInstance>> attackerSpawns = new ArrayList(8);
    private static int numAttackers = 0;
    private static int numDefenders = 0;
    private static Hashtable<Integer, Integer> siegeRewardItems;
    private static int flagItem;
    private static int flagCost;
    private static int defenderSpawnTime;
    private static int defenderPenalty;
    private static int attackerSpawnTime;
    private static int[][] controlTowerSpawns;
    private static L2NpcInstance[] controlTowers;
    private static int numCTs;
    private static int ctDeathPenalty;
    private static int maxFlags;
    private static int[] numFlags;
    private static int[][] artefactSpawns;
    protected static int countdownStart;
    private static int siegeLength;
    private static int castleOwner;

    public static void cleanUp() {
        L2Siege.deleteAllFlags();
        L2Siege.deleteCTs();
    }

    public static Hashtable<Integer, Integer> getRewardItems() {
        return siegeRewardItems;
    }

    public static void addSiegeSkills(L2PcInstance character) {
        character.addSkill(SkillTable.getInstance().getInfo(247, 1));
        character.addSkill(SkillTable.getInstance().getInfo(246, 1));
    }

    public static void removeSiegeSkills(L2PcInstance character) {
        character.removeSkill(SkillTable.getInstance().getInfo(247, 1));
        character.removeSkill(SkillTable.getInstance().getInfo(246, 1));
    }

    public static int getFlagItem() {
        return flagItem;
    }

    public static boolean okToPlaceFlag(int clanId) {
        int clanIndex = -1;
        for (int i = 0; i < numAttackers; ++i) {
            if (attackingClans[i].getClanId() != clanId) continue;
            clanIndex = i;
        }
        if (clanIndex == -1) {
            return false;
        }
        return numFlags[clanIndex] < maxFlags;
    }

    public static int getFlagCost() {
        return flagCost;
    }

    public static int getAttackerSpawnTime() {
        return attackerSpawnTime;
    }

    public static int getDefenderSpawnTime() {
        return defenderSpawnTime + defenderPenalty;
    }

    public static void setSiege(int siege) {
        if (_lastSiege == 0) {
            _lastSiege = siege;
        } else if (_siege != 0) {
            _lastSiege = _siege;
        }
        _siege = siege;
        if (siege != 0) {
            L2Siege.spawnCTs();
            defenderPenalty = 0;
            PrepareEndSiegeTask est = new PrepareEndSiegeTask();
            ClientScheduler.getInstance().scheduleLow(est, siegeLength * 60000);
            L2Siege.loadSiegeClans(siege);
        }
        for (int i = 0; i < 8; ++i) {
            attackerSpawns.add(i, new LinkedList());
        }
    }

    public static void setCastleOwner(int ownerId) {
        castleOwner = ownerId;
    }

    public static int getCastleOwner() {
        return castleOwner;
    }

    public static void endSiege() {
        L2Siege.cleanUp();
        L2Siege.clearSiegeClans(_siege);
        if (castleOwner != -1) {
            L2Siege.storeSiegeClan(castleOwner, _siege, 0, 1);
        }
        if (_siege != 0) {
            _lastSiege = _siege;
            _siege = 0;
            Announcements anounce = new Announcements();
            anounce.announceToAll("The Siege has ended!");
        }
        int lastSiege = _lastSiege;
        DoorTable doors = DoorTable.getInstance();
        doors.respawn();
        L2Siege.clearList();
        int theCastle = lastSiege - 1;
        int x1 = L2World.castles[theCastle][0];
        int y1 = L2World.castles[theCastle][1];
        int x2 = L2World.castles[theCastle][2];
        int y2 = L2World.castles[theCastle][3];
        for (L2PcInstance _player : L2World.getInstance().getAllPlayers()) {
            L2Clan playersClan = _player.getClan();
            if (playersClan != null && playersClan.getHasCastle() == lastSiege || _player.getX() < Math.min(x1, x2) || _player.getX() > Math.max(x1, x2) || _player.getY() < Math.min(y1, y2) || _player.getY() > Math.max(y1, y2)) continue;
            Location townCords = MapRegionTable.getInstance().getClosestTownCords(_player);
            StopMove sm = new StopMove(_player);
            _player.sendPacket(sm);
            _player.broadcastPacket(sm);
            ActionFailed af = new ActionFailed();
            _player.sendPacket(af);
            _player.teleToLocation(townCords.getX(), townCords.getY(), townCords.getZ());
        }
        for (int i = 0; i < 8; ++i) {
            attackerSpawns.add(i, new LinkedList());
        }
    }

    public static void setFlag(int clanId, L2NpcInstance flag) {
        int attackerNum = L2Siege.attackerIndex(clanId);
        if (attackerNum >= 0 && numFlags[attackerNum] < maxFlags) {
            attackerSpawns.get(attackerNum).addFirst(flag);
            int n = attackerNum;
            numFlags[n] = numFlags[n] + 1;
        }
    }

    public static Location getAttackerSpawn(int clanId) {
        int attackerNum = L2Siege.attackerIndex(clanId);
        Location spawnLoc = null;
        try {
            L2NpcInstance tempFlag;
            if (attackerNum >= 0 && attackerSpawns.get(attackerNum).size() > 0 && (tempFlag = attackerSpawns.get(attackerNum).getFirst()) != null) {
                spawnLoc = new Location(tempFlag.getX(), tempFlag.getY(), tempFlag.getZ());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return spawnLoc;
    }

    public static void deleteAllFlags() {
        for (int i = 0; i < numAttackers; ++i) {
            int flagsToDelete = attackerSpawns.get(i).size();
            for (int j = 0; j < flagsToDelete; ++j) {
                try {
                    L2NpcInstance tempFlag = attackerSpawns.get(i).get(j);
                    tempFlag.deleteMe();
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            attackerSpawns.set(i, null);
            L2Siege.numFlags[i] = 0;
        }
    }

    public static void killFlag(int id) {
        for (int i = 0; i < numAttackers; ++i) {
            L2NpcInstance tempFlag = attackerSpawns.get(i).getFirst();
            int j = 0;
            while (tempFlag != null && j < attackerSpawns.get(i).size()) {
                if (tempFlag.getObjectId() == id) {
                    attackerSpawns.get(i).remove(j);
                    int n = i;
                    numFlags[n] = numFlags[n] - 1;
                }
                if (++j >= attackerSpawns.get(i).size()) continue;
                tempFlag = attackerSpawns.get(i).get(j);
            }
        }
    }

    private static int attackerIndex(int id) {
        for (int i = 0; i < numAttackers; ++i) {
            if (attackingClans[i].getClanId() != id) continue;
            return i;
        }
        return -1;
    }

    public static int getLastSiege() {
        return _lastSiege;
    }

    public static void addAttacker(L2Clan clan) {
        if (!L2Siege.isAttacker(clan.getClanId()) && numAttackers < 8) {
            L2Siege.attackingClans[L2Siege.numAttackers] = new L2Clan(clan.getClanId());
            ++numAttackers;
        }
    }

    public static void addDefender(L2Clan clan) {
        if (!L2Siege.isDefender(clan.getClanId()) && numDefenders < 8) {
            L2Siege.defendingClans[L2Siege.numDefenders] = new L2Clan(clan.getClanId());
            ++numDefenders;
        }
    }

    public static void clearList() {
        numAttackers = 0;
        numDefenders = 0;
    }

    public static int getSiege() {
        return _siege;
    }

    public static boolean isAttacker(int id) {
        boolean isAttacker = false;
        for (int i = 0; i < numAttackers; ++i) {
            if (attackingClans[i].getClanId() != id) continue;
            isAttacker = true;
        }
        return isAttacker;
    }

    public static boolean isDefender(int id) {
        boolean isDef = false;
        for (int i = 0; i < numDefenders; ++i) {
            if (defendingClans[i].getClanId() != id) continue;
            isDef = true;
        }
        return isDef;
    }

    public static L2Clan[] getAttackers() {
        return attackingClans;
    }

    public static L2Clan[] getDefenders() {
        return defendingClans;
    }

    public static int getNumAttackers() {
        return numAttackers;
    }

    public static int getNumDefenders() {
        return numDefenders;
    }

    public static void killCT() {
        defenderPenalty += ctDeathPenalty;
    }

    public static void deleteCTs() {
        for (int i = 0; i < numCTs; ++i) {
            if (controlTowers[i] == null) continue;
            controlTowers[i].onDecay();
        }
        defenderPenalty = 0;
    }

    public static void spawnCTs() {
        int CTId = 0;
        L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(12314);
        for (int i = 0; i < numCTs; ++i) {
            CTId = IdFactory.getInstance().getNextId();
            if (controlTowers[i] != null) {
                controlTowers[i].onDecay();
            }
            L2Siege.controlTowers[i] = new L2NpcInstance(CTId, template1);
            controlTowers[i].setCurrentHpMp(controlTowers[i].getMaxHp(), controlTowers[i].getMaxMp());
            controlTowers[i].spawnMe(controlTowerSpawns[i][0], controlTowerSpawns[i][1], controlTowerSpawns[i][2] + 50);
        }
    }

    public static void spawnArtefacts() {
        int CTId = 0;
        for (int i = 0; i < 5; ++i) {
            L2NpcTemplate artefactTemplate = NpcTable.getInstance().getTemplate(artefactSpawns[i][4]);
            CTId = IdFactory.getInstance().getNextId();
            L2ArtefactInstance artefact = new L2ArtefactInstance(CTId, artefactTemplate);
            artefact.setCurrentHpMp(artefact.getMaxHp(), artefact.getMaxMp());
            artefact.setHeading(artefactSpawns[i][3]);
            artefact.spawnMe(artefactSpawns[i][0], artefactSpawns[i][1], artefactSpawns[i][2] + 50);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSiegeClans(int castle_id) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM siege_clans WHERE castle_id=?");
            statement.setInt(1, castle_id);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSiegeClan(int castle_id, int clan_id) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM siege_clans WHERE castle_id=? and clan_id=?");
            statement.setInt(1, castle_id);
            statement.setInt(2, clan_id);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkIfSignedUp(int castle_id, int clan_id) {
        boolean notSignedUp = true;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clan_id FROM siege_clans where castle_id=? and clan_id=?");
            statement.setInt(1, castle_id);
            statement.setInt(2, clan_id);
            ResultSet siegeData = statement.executeQuery();
            if (siegeData.next()) {
                notSignedUp = false;
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return notSignedUp;
    }

    public static void storeSiegeClan(int clan_id, int castle_id, int type) {
        L2Siege.storeSiegeClan(clan_id, castle_id, type, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeSiegeClan(int clan_id, int castle_id, int type, int owner) {
        Connection con = null;
        try {
            if (L2Siege.checkIfSignedUp(castle_id, clan_id)) {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("INSERT INTO siege_clans (clan_id,castle_id,type,castle_owner) values (?,?,?,?)");
                statement.setInt(1, clan_id);
                statement.setInt(2, castle_id);
                statement.setInt(3, type);
                statement.setInt(4, owner);
                statement.execute();
                statement.close();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSiegeClans(int castle_id) {
        castleOwner = -1;
        System.out.println("Getting Clans for castle " + castle_id);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(GET_SIEGE_CLANS);
            statement.setInt(1, castle_id);
            ResultSet siegeData = statement.executeQuery();
            while (siegeData.next()) {
                int clanIdVal = siegeData.getInt("clan_id");
                int clanType = siegeData.getInt("type");
                int owner = siegeData.getInt("castle_owner");
                if (owner == 1) {
                    castleOwner = clanIdVal;
                }
                if (clanType == 0) {
                    L2Siege.addDefender(new L2Clan(clanIdVal));
                    continue;
                }
                L2Siege.addAttacker(new L2Clan(clanIdVal));
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSiegeData() {
        BufferedReader lnr = null;
        try {
            Properties siegeSettings = new Properties();
            InputStream is = Config.class.getResourceAsStream("/config/siege.properties");
            siegeSettings.load(is);
            is.close();
            flagItem = Integer.decode(siegeSettings.getProperty("FlagItem"));
            flagCost = Integer.decode(siegeSettings.getProperty("FlagCost"));
            siegeLength = Integer.decode(siegeSettings.getProperty("SiegeLength"));
            countdownStart = Integer.decode(siegeSettings.getProperty("CountDownLength"));
            StringTokenizer st = new StringTokenizer(siegeSettings.getProperty("Rewards"), "() ");
            ArrayList<String> rewards = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                rewards.add(st.nextToken());
                if (!st.hasMoreTokens()) continue;
                st.nextToken();
            }
            siegeRewardItems = new Hashtable();
            for (String reward : rewards) {
                st = new StringTokenizer(reward, ", ");
                int rewardItemID = Integer.parseInt(st.nextToken());
                int rewardAmount = Integer.parseInt(st.nextToken());
                siegeRewardItems.put(rewardItemID, rewardAmount);
            }
            defenderSpawnTime = Integer.decode(siegeSettings.getProperty("DefenderRespawn"));
            attackerSpawnTime = Integer.decode(siegeSettings.getProperty("AttackerRespawn"));
            ctDeathPenalty = Integer.decode(siegeSettings.getProperty("CTLossPenalty"));
            L2World.castlespawns[0] = L2Siege.getCoords(siegeSettings.getProperty("GludioAttackersSpawnLocation"));
            L2World.castlespawns[1] = L2Siege.getCoords(siegeSettings.getProperty("GludioDefendersSpawnLocation"));
            L2Siege.controlTowerSpawns[0] = L2Siege.getCoords(siegeSettings.getProperty("GludioControlTower1", "0,0,0"));
            L2Siege.controlTowerSpawns[1] = L2Siege.getCoords(siegeSettings.getProperty("GludioControlTower2", "0,0,0"));
            L2World.castlespawns[2] = L2Siege.getCoords(siegeSettings.getProperty("GiranAttackersSpawnLocation"));
            L2World.castlespawns[3] = L2Siege.getCoords(siegeSettings.getProperty("GiranDefendersSpawnLocation"));
            L2Siege.controlTowerSpawns[2] = L2Siege.getCoords(siegeSettings.getProperty("GiranControlTower1", "0,0,0"));
            L2Siege.controlTowerSpawns[3] = L2Siege.getCoords(siegeSettings.getProperty("GiranControlTower2", "0,0,0"));
            L2World.castlespawns[4] = L2Siege.getCoords(siegeSettings.getProperty("DionAttackersSpawnLocation"));
            L2World.castlespawns[5] = L2Siege.getCoords(siegeSettings.getProperty("DionDefendersSpawnLocation"));
            L2Siege.controlTowerSpawns[4] = L2Siege.getCoords(siegeSettings.getProperty("DionControlTower1", "0,0,0"));
            L2Siege.controlTowerSpawns[5] = L2Siege.getCoords(siegeSettings.getProperty("DionControlTower2", "0,0,0"));
            L2World.castlespawns[6] = L2Siege.getCoords(siegeSettings.getProperty("OrenAttackersSpawnLocation"));
            L2World.castlespawns[7] = L2Siege.getCoords(siegeSettings.getProperty("OrenDefendersSpawnLocation"));
            L2Siege.controlTowerSpawns[6] = L2Siege.getCoords(siegeSettings.getProperty("OrenControlTower1", "0,0,0"));
            L2Siege.controlTowerSpawns[7] = L2Siege.getCoords(siegeSettings.getProperty("OrenControlTower2", "0,0,0"));
            L2World.castlespawns[8] = L2Siege.getCoords(siegeSettings.getProperty("AdenAttackersSpawnLocation"));
            L2World.castlespawns[9] = L2Siege.getCoords(siegeSettings.getProperty("AdenDefendersSpawnLocation"));
            L2Siege.controlTowerSpawns[8] = L2Siege.getCoords(siegeSettings.getProperty("AdenControlTower1", "0,0,0"));
            L2Siege.controlTowerSpawns[9] = L2Siege.getCoords(siegeSettings.getProperty("AdenControlTower2", "0,0,0"));
            numCTs = 10;
            maxFlags = Integer.decode(siegeSettings.getProperty("MaxFlags"));
        }
        catch (Exception e) {
            System.err.println("Error while loading siege data.");
            e.printStackTrace();
        }
        finally {
            try {
                lnr.close();
            }
            catch (Exception e1) {}
        }
        L2Siege.spawnArtefacts();
        for (int i = 0; i < 8; ++i) {
            attackerSpawns.add(i, new LinkedList());
        }
    }

    private static int[] getCoords(String coordString) {
        int[] coords = new int[3];
        StringTokenizer st = new StringTokenizer(coordString, ",");
        for (int i = 0; i < 3; ++i) {
            coords[i] = Integer.decode(st.nextToken());
        }
        return coords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static L2Clan getClan(int castle2) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clan_id from clan_data");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                if (ClanTable.getInstance().getClan(rset.getInt("clan_id")).getHasCastle() != castle2) continue;
                L2Clan l2Clan = ClanTable.getInstance().getClan(rset.getInt("clan_id"));
                return l2Clan;
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return null;
    }

    static {
        flagItem = 57;
        flagCost = 50000;
        defenderSpawnTime = 10000;
        defenderPenalty = 0;
        attackerSpawnTime = 20000;
        controlTowerSpawns = new int[20][];
        controlTowers = new L2NpcInstance[20];
        numCTs = 0;
        ctDeathPenalty = 5000;
        maxFlags = 1;
        numFlags = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        artefactSpawns = new int[][]{{-18120, 107984, -2483, 16384, 7250}, {117939, 145090, -2550, 32768, 12154}, {22081, 161771, -2677, 49017, 12123}, {84014, 37184, -2277, 16384, 12242}, {116031, 250555, -798, 49200, 12602}, {147465, 1537, -373, 16384, 12291}};
        countdownStart = 10;
        siegeLength = 120;
        castleOwner = -1;
    }

    public static class PrepareEndSiegeTask
    implements Runnable {
        public void run() {
            try {
                Announcements anounce = new Announcements();
                if (countdownStart >= 6) {
                    PrepareEndSiegeTask est = new PrepareEndSiegeTask();
                    anounce.announceToAll("The Attackers have " + countdownStart + " minutes left to take the castle!");
                    ClientScheduler.getInstance().scheduleLow(est, 300000L);
                    countdownStart -= 5;
                } else if (countdownStart == 5) {
                    PrepareEndSiegeTask est = new PrepareEndSiegeTask();
                    anounce.announceToAll("The Attackers have 5 minutes left to take the castle!");
                    ClientScheduler.getInstance().scheduleLow(est, 240000L);
                    countdownStart = 1;
                } else if (countdownStart < 5 && countdownStart > 0) {
                    PrepareEndSiegeTask est = new PrepareEndSiegeTask();
                    anounce.announceToAll("The Attackers have " + countdownStart + " minute to take the castle!");
                    ClientScheduler.getInstance().scheduleLow(est, 60000L);
                    --countdownStart;
                } else {
                    EndSiegeTask est = new EndSiegeTask();
                    anounce.announceToAll("Time has run out, The Siege will end in 10 seconds, and all normal rules will resume!");
                    ClientScheduler.getInstance().scheduleLow(est, 10000L);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class EndSiegeTask
    implements Runnable {
        public void run() {
            try {
                if (_siege > 0) {
                    L2Siege.endSiege();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

