/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.Vector;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.RadarControl;

public final class L2Radar {
    private L2PcInstance player;
    private Vector<RadarMarker> markers;

    public L2Radar(L2PcInstance player) {
        this.player = player;
        this.markers = new Vector();
    }

    public void addMarker(int x, int y, int z) {
        RadarMarker newMarker = new RadarMarker(x, y, z);
        this.markers.add(newMarker);
        this.player.sendPacket(new RadarControl(0, 1, x, y, z));
    }

    public void removeMarker(int x, int y, int z) {
        RadarMarker newMarker = new RadarMarker(x, y, z);
        this.markers.remove(newMarker);
        this.player.sendPacket(new RadarControl(1, 1, x, y, z));
    }

    public void removeAllMarkers() {
        for (RadarMarker tempMarker : this.markers) {
            this.player.sendPacket(new RadarControl(1, tempMarker.type, tempMarker.x, tempMarker.y, tempMarker.z));
        }
        this.markers.removeAllElements();
    }

    public void loadMarkers() {
    }

    public class RadarMarker {
        public int type;
        public int x;
        public int y;
        public int z;

        public RadarMarker(int type, int x, int y, int z) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public RadarMarker(int x, int y, int z) {
            this.type = 1;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object obj) {
            try {
                RadarMarker temp = (RadarMarker)obj;
                return temp.x == this.x && temp.y == this.y && temp.z == this.z && temp.type == this.type;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

