/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.concurrent.Future;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;

public class L2Potion
extends L2Object {
    protected static final Logger _log = Logger.getLogger(L2Character.class.getName());
    L2Character _target;
    private Future _potionhpRegTask;
    private boolean _potionhpRegenActive;
    private Future _potionmpRegTask;
    private boolean _potionmpRegenActive;
    protected int _milliseconds;
    protected double _effect;
    protected int _duration;
    private int _potion;
    protected Object _mpLock = new Object();
    protected Object _hpLock = new Object();

    public L2Potion(int objectId) {
        super(objectId);
    }

    private void startPotionHpRegeneration(L2Character activeChar) {
        this._potionhpRegTask = ClientScheduler.getInstance().scheduleMedAtFixedRate(new PotionHpHealing(activeChar), 1000L, this._milliseconds);
        this._potionhpRegenActive = true;
        if (Config.DEBUG) {
            _log.fine("Potion HP regen Started");
        }
    }

    public void stopPotionHpRegeneration() {
        if (this._potionhpRegTask != null) {
            this._potionhpRegTask.cancel(false);
        }
        this._potionhpRegTask = null;
        this._potionhpRegenActive = false;
        if (Config.DEBUG) {
            _log.fine("Potion HP regen stop");
        }
    }

    public void setCurrentHpPotion2(L2Character activeChar) {
        if (this._duration == 0) {
            this.stopPotionHpRegeneration();
        }
    }

    public void setCurrentHpPotion1(L2Character activeChar, int item) {
        this._potion = item;
        this._target = activeChar;
        switch (this._potion) {
            case 1540: {
                double nowHp = activeChar.getCurrentHp();
                nowHp += 435.0;
                if (nowHp >= (double)activeChar.getMaxHp()) {
                    nowHp = activeChar.getMaxHp();
                }
                activeChar.setCurrentHp(nowHp);
            }
            case 728: {
                double nowMp = activeChar.getMaxMp();
                nowMp += 435.0;
                if (nowMp >= (double)activeChar.getMaxMp()) {
                    nowMp = activeChar.getMaxMp();
                }
                activeChar.setCurrentMp(nowMp);
                break;
            }
            case 726: {
                this._milliseconds = 500;
                this._duration = 15;
                this._effect = 1.5;
                this.startPotionMpRegeneration(activeChar);
            }
        }
    }

    private void startPotionMpRegeneration(L2Character activeChar) {
        this._potionmpRegTask = ClientScheduler.getInstance().scheduleMedAtFixedRate(new PotionMpHealing(activeChar), 1000L, this._milliseconds);
        this._potionmpRegenActive = true;
        if (Config.DEBUG) {
            _log.fine("Potion MP regen Started");
        }
    }

    public void stopPotionMpRegeneration() {
        if (this._potionmpRegTask != null) {
            this._potionmpRegTask.cancel(false);
        }
        this._potionmpRegTask = null;
        this._potionmpRegenActive = false;
        if (Config.DEBUG) {
            _log.fine("Potion MP regen stop");
        }
    }

    public void setCurrentMpPotion2(L2Character activeChar) {
        if (this._duration == 0) {
            this.stopPotionMpRegeneration();
        }
    }

    public void setCurrentMpPotion1(L2Character activeChar, int item) {
        this._potion = item;
        this._target = activeChar;
    }

    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    class PotionMpHealing
    implements Runnable {
        L2Character _instance;

        public PotionMpHealing(L2Character instance) {
            this._instance = instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = L2Potion.this._mpLock;
                synchronized (object) {
                    double nowMp = this._instance.getCurrentMp();
                    if (L2Potion.this._duration == 0) {
                        L2Potion.this.stopPotionMpRegeneration();
                    }
                    if (L2Potion.this._duration != 0) {
                        this._instance.setCurrentMp(nowMp += L2Potion.this._effect);
                        L2Potion.this._duration -= L2Potion.this._milliseconds / 1000;
                        L2Potion.this.setCurrentMpPotion2(this._instance);
                    }
                }
            }
            catch (Exception e) {
                _log.warning("error in mp potion task:" + e);
            }
        }
    }

    class PotionHpHealing
    implements Runnable {
        L2Character _instance;

        public PotionHpHealing(L2Character instance) {
            this._instance = instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = L2Potion.this._hpLock;
                synchronized (object) {
                    double nowHp = this._instance.getCurrentHp();
                    if (L2Potion.this._duration == 0) {
                        L2Potion.this.stopPotionHpRegeneration();
                    }
                    if (L2Potion.this._duration != 0) {
                        this._instance.setCurrentHp(nowHp += L2Potion.this._effect);
                        L2Potion.this._duration -= L2Potion.this._milliseconds / 1000;
                        L2Potion.this.setCurrentHpPotion2(this._instance);
                    }
                }
            }
            catch (Exception e) {
                _log.warning("Error in hp potion task:" + e);
            }
        }
    }
}

