/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2SummonInstance;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.PartySmallWindowAdd;
import net.sf.l2j.gameserver.serverpackets.PartySmallWindowAll;
import net.sf.l2j.gameserver.serverpackets.PartySmallWindowDelete;
import net.sf.l2j.gameserver.serverpackets.PartySmallWindowDeleteAll;
import net.sf.l2j.gameserver.serverpackets.PartySmallWindowUpdate;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L2Party {
    private static Random _rnd = new Random();
    private static Logger _log = Logger.getLogger(L2Party.class.getName());
    private ArrayList<L2PcInstance> _members = new ArrayList();
    private int _partyLvl = 0;
    private int _itemDistribution = 0;
    private int _itemOrder = 0;
    public final int ITEM_LOOTER = 0;
    public final int ITEM_RANDOM = 1;
    public final int ITEM_RANDOM_SPOIL = 2;
    public final int ITEM_ORDER = 3;
    public final int ITEM_ORDER_SPOIL = 4;

    public L2Party(L2PcInstance leader, int itemDistribution) {
        this._itemDistribution = itemDistribution;
        this._members.add(leader);
        this._partyLvl = leader.getLevel();
    }

    public int getMemberCount() {
        return this._members.size();
    }

    public ArrayList<L2PcInstance> getPartyMembers() {
        return this._members;
    }

    private L2PcInstance getRandomMember() {
        return this._members.get(_rnd.nextInt(this._members.size()));
    }

    private L2PcInstance getNextLooter() {
        int looter = this._itemOrder++;
        if (this._itemOrder > this.getMemberCount() - 1) {
            this._itemOrder = 0;
        }
        return this._members.get(looter);
    }

    public boolean isLeader(L2PcInstance player) {
        return this._members.get(0).equals(player);
    }

    public void broadcastToPartyMembers(ServerBasePacket msg) {
        for (int i = 0; i < this._members.size(); ++i) {
            L2PcInstance member = this._members.get(i);
            member.sendPacket(msg);
        }
    }

    public void broadcastToPartyMembers(L2PcInstance player, ServerBasePacket msg) {
        for (int i = 0; i < this._members.size(); ++i) {
            L2PcInstance member = this._members.get(i);
            if (member.equals(player)) continue;
            member.sendPacket(msg);
        }
    }

    public void addPartyMember(L2PcInstance player) {
        PartySmallWindowAll window = new PartySmallWindowAll();
        window.setPartyList(this._members);
        player.sendPacket(window);
        SystemMessage msg = new SystemMessage(106);
        msg.addString(this._members.get(0).getName());
        player.sendPacket(msg);
        msg = new SystemMessage(107);
        msg.addString(player.getName());
        this.broadcastToPartyMembers(msg);
        this.broadcastToPartyMembers(new PartySmallWindowAdd(player));
        this._members.add(player);
        if (player.getLevel() > this._partyLvl) {
            this._partyLvl = player.getLevel();
        }
    }

    public void removePartyMember(L2PcInstance player) {
        if (this._members.contains(player)) {
            this._members.remove(player);
            this.recalculatePartyLevel();
            SystemMessage msg = new SystemMessage(200);
            player.sendPacket(msg);
            player.sendPacket(new PartySmallWindowDeleteAll());
            player.setParty(null);
            msg = new SystemMessage(108);
            msg.addString(player.getName());
            this.broadcastToPartyMembers(msg);
            this.broadcastToPartyMembers(new PartySmallWindowDelete(player));
            if (this._members.size() == 1) {
                this._members.get(0).setParty(null);
            }
        }
    }

    public void changePartyLeader(L2PcInstance player) {
        if (this._members.contains(player)) {
            if (this.isLeader(player)) {
                SystemMessage msg = new SystemMessage(1401);
            } else {
                int p1 = this._members.indexOf(player);
                L2PcInstance temp = this._members.get(0);
                this._members.set(0, this._members.get(p1));
                this._members.set(p1, temp);
                SystemMessage msg = new SystemMessage(1384);
                msg.addString(this._members.get(0).getName());
                this.broadcastToPartyMembers(msg);
                this.broadcastToPartyMembers(new PartySmallWindowUpdate(this._members.get(0)));
            }
        } else {
            SystemMessage systemMessage = new SystemMessage(1402);
        }
    }

    public void changePartyLeader(String name) {
        L2PcInstance player = this.getPlayerByName(name);
        if (player != null) {
            if (this._members.contains(player)) {
                if (this.isLeader(player)) {
                    SystemMessage msg = new SystemMessage(1401);
                } else {
                    int p1 = this._members.indexOf(player);
                    L2PcInstance temp = this._members.get(0);
                    this._members.set(0, this._members.get(p1));
                    this._members.set(p1, temp);
                    SystemMessage msg = new SystemMessage(1384);
                    msg.addString(this._members.get(0).getName());
                    this.broadcastToPartyMembers(msg);
                    this.broadcastToPartyMembers(new PartySmallWindowUpdate(this._members.get(0)));
                }
            } else {
                SystemMessage systemMessage = new SystemMessage(1402);
            }
        }
    }

    private L2PcInstance getPlayerByName(String name) {
        for (int i = 0; i < this._members.size(); ++i) {
            L2PcInstance temp = this._members.get(i);
            if (!temp.getName().equals(name)) continue;
            return temp;
        }
        return null;
    }

    public void oustPartyMember(L2PcInstance player) {
        if (this._members.contains(player)) {
            if (this.isLeader(player)) {
                this.removePartyMember(player);
                SystemMessage msg = new SystemMessage(1384);
                msg.addString(this._members.get(0).getName());
                this.broadcastToPartyMembers(msg);
                this.broadcastToPartyMembers(new PartySmallWindowUpdate(this._members.get(0)));
            } else {
                this.removePartyMember(player);
            }
        }
    }

    public void oustPartyMember(String name) {
        L2PcInstance player = this.getPlayerByName(name);
        if (player != null) {
            if (this.isLeader(player)) {
                this.removePartyMember(player);
                SystemMessage msg = new SystemMessage(1384);
                msg.addString(this._members.get(0).getName());
                this.broadcastToPartyMembers(msg);
                this.broadcastToPartyMembers(new PartySmallWindowUpdate(this._members.get(0)));
            } else {
                this.removePartyMember(player);
            }
        }
    }

    private void dissolveParty() {
        SystemMessage msg = new SystemMessage(203);
        for (int i = 0; i < this._members.size(); ++i) {
            L2PcInstance temp = this._members.get(i);
            temp.sendPacket(msg);
            temp.sendPacket(new PartySmallWindowDeleteAll());
            temp.setParty(null);
        }
    }

    public void distributeItem(L2PcInstance player, L2ItemInstance item) {
        SystemMessage smsg;
        L2PcInstance target = null;
        switch (this._itemDistribution) {
            case 1: 
            case 2: {
                target = this.getRandomMember();
                break;
            }
            case 3: 
            case 4: {
                target = this.getNextLooter();
                break;
            }
            default: {
                target = player;
            }
        }
        if (item.getCount() == 1) {
            smsg = new SystemMessage(30);
            smsg.addItemName(item.getItemId());
            target.sendPacket(smsg);
            smsg = new SystemMessage(300);
            smsg.addString(target.getName());
            smsg.addItemName(item.getItemId());
            this.broadcastToPartyMembers(target, smsg);
        } else {
            smsg = new SystemMessage(29);
            smsg.addNumber(item.getCount());
            smsg.addItemName(item.getItemId());
            target.sendPacket(smsg);
            smsg = new SystemMessage(299);
            smsg.addString(target.getName());
            smsg.addNumber(item.getCount());
            smsg.addItemName(item.getItemId());
            this.broadcastToPartyMembers(target, smsg);
        }
        L2ItemInstance item2 = target.getInventory().addItem(item);
        InventoryUpdate iu = new InventoryUpdate();
        if (item2.getLastChange() == 1) {
            iu.addNewItem(item);
        } else {
            iu.addModifiedItem(item2);
        }
        target.sendPacket(iu);
        StatusUpdate su = new StatusUpdate(target.getObjectId());
        su.addAttribute(StatusUpdate.CUR_LOAD, target.getCurrentLoad());
        target.sendPacket(su);
    }

    public void distributeAdena(L2ItemInstance adena) {
        SystemMessage smsg = new SystemMessage(28);
        int[] adenaDist = new int[this._members.size()];
        int totalAdena = adena.getCount();
        for (int i = 0; i < adenaDist.length; ++i) {
            int amount;
            adenaDist[i] = amount = totalAdena / (adenaDist.length - i);
            totalAdena -= amount;
            smsg.addNumber(adenaDist[i]);
            L2ItemInstance newAdena = ItemTable.getInstance().createItem(57);
            newAdena.setCount(adenaDist[i]);
            L2PcInstance member = this._members.get(i);
            L2ItemInstance item2 = member.getInventory().addItem(newAdena);
            InventoryUpdate iu = new InventoryUpdate();
            if (item2.getLastChange() == 1) {
                iu.addNewItem(adena);
            } else {
                iu.addModifiedItem(item2);
            }
            member.sendPacket(smsg);
            member.sendPacket(iu);
        }
    }

    public void distributeXpAndSp(int xpReward, int spReward, ArrayList<L2Character> rewardedMembers, L2Character lastAttacker) {
        double xpToReward = 0.0;
        double spToReward = 0.0;
        L2SummonInstance summon = null;
        L2PcInstance owner = null;
        float penalty = 0.0f;
        for (L2Character member : rewardedMembers) {
            if (!lastAttacker.knowsThePlayer((L2PcInstance)member)) continue;
            penalty = 0.0f;
            if (member instanceof L2SummonInstance) {
                summon = (L2SummonInstance)member;
                penalty = summon.getExpPenalty();
                owner = summon.getOwner();
                if (rewardedMembers.contains(owner)) {
                    rewardedMembers.remove(owner);
                }
            } else if (member instanceof L2PcInstance && (owner = (L2PcInstance)member).getPet() instanceof L2SummonInstance && rewardedMembers.contains(owner.getPet())) {
                summon = (L2SummonInstance)owner.getPet();
                penalty = summon.getExpPenalty();
                rewardedMembers.remove(summon);
            }
            xpToReward = (double)xpReward * ((double)member.getLevel() / (double)this.getLevel()) * (1.0 - (double)this.getMemberCount() / 10.0);
            spToReward = (double)spReward * ((double)member.getLevel() / (double)this.getLevel()) * (1.0 - (double)this.getMemberCount() / 10.0);
            member.addExpAndSp((int)(xpToReward *= (double)(1.0f - penalty)), (int)spToReward);
        }
    }

    public void recalculatePartyLevel() {
        int newLevel = 0;
        for (L2PcInstance member : this._members) {
            if (member.getLevel() <= newLevel) continue;
            newLevel = member.getLevel();
        }
        this._partyLvl = newLevel;
    }

    private double getExpBonus() {
        int mcount = this.getMemberCount();
        if (mcount < 2) {
            return 1.0;
        }
        double mul2 = 1.0;
        switch (mcount) {
            default: {
                mul2 += 0.04;
            }
            case 8: {
                mul2 += 0.04;
            }
            case 7: {
                mul2 += 0.05;
            }
            case 6: {
                mul2 += 0.04;
            }
            case 5: {
                mul2 += 0.04;
            }
            case 4: {
                mul2 += 0.11;
            }
            case 3: {
                mul2 += 0.09;
            }
            case 2: 
        }
        return mul2 += 0.3;
    }

    public int getLevel() {
        return this._partyLvl;
    }

    public boolean isDistributeSpoilLoot() {
        boolean rv = false;
        if (this._itemDistribution == 2 || this._itemDistribution == 4) {
            rv = true;
        }
        return rv;
    }
}

