/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2PlayableInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.quest.Quest;
import net.sf.l2j.gameserver.model.quest.QuestState;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.NpcInfo;
import net.sf.l2j.gameserver.serverpackets.SocialAction;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.ValidateLocation;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;
import net.sf.l2j.gameserver.templates.L2Weapon;

public class L2NpcInstance
extends L2Character {
    private static Logger _log = Logger.getLogger(L2NpcInstance.class.getName());
    public static final int INTERACTION_DISTANCE = 150;
    private static final int MINIMUM_AGGRO_RANGE = 200;
    private final Random _rnd = new Random();
    private L2Spawn _spawn;

    public L2NpcInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setName(template.name);
        if (this.hasRandomAnimation()) {
            this.startRandomAnimation();
        }
    }

    public boolean hasRandomAnimation() {
        return Config.MAX_NPC_ANIMATION > 0;
    }

    public final L2NpcTemplate getTemplate() {
        return (L2NpcTemplate)this._template;
    }

    public int getNpcId() {
        return this.getTemplate().npcId;
    }

    public final String getFactionId() {
        return this.getTemplate().factionId;
    }

    public final int getLevel() {
        return this.getTemplate().level;
    }

    public boolean isAggressive() {
        return false;
    }

    public int getAggroRange() {
        return this.getTemplate().aggroRange;
    }

    public int getFactionRange() {
        return this.getTemplate().factionRange;
    }

    public boolean isUndead() {
        return this.getTemplate().isUndead;
    }

    public void updateAbnormalEffect() {
        for (L2PcInstance player : this.getKnownPlayers()) {
            player.sendPacket(new NpcInfo(this, (L2Character)player));
        }
    }

    protected int getDistanceToWatchObject(L2Object object) {
        if (object instanceof L2FolkInstance || !(object instanceof L2Character)) {
            return 0;
        }
        if (object instanceof L2PlayableInstance) {
            return 1500;
        }
        return 500;
    }

    protected int getDistanceToForgetObject(L2Object object) {
        return 2 * this.getDistanceToWatchObject(object);
    }

    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    public int getLeftHandItem() {
        return this.getTemplate().lhand;
    }

    public int getRightHandItem() {
        return this.getTemplate().rhand;
    }

    public void onAction(L2PcInstance player) {
        if (this != player.getTarget()) {
            if (Config.DEBUG) {
                _log.fine("new target selected:" + this.getObjectId());
            }
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            if (this.isAutoAttackable(player)) {
                StatusUpdate su = new StatusUpdate(this.getObjectId());
                su.addAttribute(StatusUpdate.CUR_HP, (int)this.getCurrentHp());
                su.addAttribute(StatusUpdate.MAX_HP, this.getMaxHp());
                player.sendPacket(su);
            }
            player.sendPacket(new ValidateLocation(this));
        } else {
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            if (this.isAutoAttackable(player) && !this.isAlikeDead()) {
                if (Math.abs(player.getZ() - this.getZ()) < 400) {
                    player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
                } else {
                    player.sendPacket(new ActionFailed());
                }
            }
            if (!this.isAutoAttackable(player)) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
                double distance = this.getDistance(player.getX(), player.getY());
                if (distance > 150.0) {
                    player.sendPacket(new ActionFailed());
                } else {
                    SocialAction sa = new SocialAction(this.getObjectId(), this._rnd.nextInt(8));
                    this.broadcastPacket(sa);
                    this.sendPacket(sa);
                    this.showChatWindow(player, 0);
                    player.sendPacket(new ActionFailed());
                }
            }
        }
    }

    public void onActionShift(ClientThread client) {
        L2PcInstance player = client.getActiveChar();
        if (player.getAccessLevel() >= Config.GM_ACCESSLEVEL) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            if (this.isAutoAttackable(player)) {
                StatusUpdate su = new StatusUpdate(this.getObjectId());
                su.addAttribute(StatusUpdate.CUR_HP, (int)this.getCurrentHp());
                su.addAttribute(StatusUpdate.MAX_HP, this.getMaxHp());
                player.sendPacket(su);
            }
            NpcHtmlMessage html = new NpcHtmlMessage(1);
            StringBuffer html1 = new StringBuffer("<html><body>");
            String className = this.getClass().getName().substring(28);
            html1.append("<center>class " + className + ", faction " + this.getFactionId() + "</center>");
            html1.append("<table border=0 width=\"100%\">");
            html1.append("<tr><td>Target</td><td>" + this.getObjectId() + "</td><td>NPC ID</td><td>" + this.getTemplate().npcId + "</td></tr>");
            html1.append("<tr><td>Level</td><td>" + this.getLevel() + "</td><td>Aggro</td><td>" + (this instanceof L2Attackable ? ((L2Attackable)this).getAggroRange() : 0) + "</td></tr>");
            html1.append("</table>");
            html1.append("<p>Combat");
            html1.append("<table border=0 width=\"100%\">");
            html1.append("<tr><td>Current HP</td><td>" + this.getCurrentHp() + "</td><td>Current MP</td><td>" + this.getCurrentMp() + "</td></tr>");
            html1.append("<tr><td>Max.HP</td><td>" + this.getMaxHp() + "</td><td>Max.MP</td><td>" + this.getMaxMp() + "</td></tr>");
            html1.append("<tr><td>P.Atk.</td><td>" + this.getPAtk(null) + "</td><td>M.Atk.</td><td>" + this.getMAtk(null, null) + "</td></tr>");
            html1.append("<tr><td>P.Def.</td><td>" + this.getPDef(null) + "</td><td>M.Def.</td><td>" + this.getMDef(null, null) + "</td></tr>");
            html1.append("<tr><td>Accuracy</td><td>" + this.getAccuracy() + "</td><td>Evasion</td><td>" + this.getEvasionRate(null) + "</td></tr>");
            html1.append("<tr><td>Critical</td><td>" + this.getCriticalHit(null, null) + "</td><td>Speed</td><td>" + this.getRunSpeed() + "</td></tr>");
            html1.append("<tr><td>Atk.Speed</td><td>" + this.getPAtkSpd() + "</td><td>Cast.Speed</td><td>" + this.getMAtkSpd() + "</td></tr>");
            html1.append("</table>");
            html1.append("<p>Basic");
            html1.append("<table border=0 width=\"100%\">");
            html1.append("<tr><td>STR</td><td>" + this.getSTR() + "</td><td>DEX</td><td>" + this.getDEX() + "</td><td>CON</td><td>" + this.getCON() + "</td></tr>");
            html1.append("<tr><td>INT</td><td>" + this.getINT() + "</td><td>WIT</td><td>" + this.getWIT() + "</td><td>MEN</td><td>" + this.getMEN() + "</td></tr>");
            html1.append("</table>");
            html1.append("<table><tr><td><button value=\"Edit NPC\" action=\"bypass -h admin_edit_npc " + this.getTemplate().npcId + "\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
            html1.append("<td><button value=\"Kill\" action=\"bypass -h admin_kill\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            html1.append("<tr><td><button value=\"Show DropList\" action=\"bypass -h admin_show_droplist " + this.getTemplate().npcId + "\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            html1.append("<td><button value=\"Delete\" action=\"bypass -h admin_delete\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            html1.append("</table>");
            html1.append("</body></html>");
            html.setHtml(html1.toString());
            player.sendPacket(html);
        }
        player.sendPacket(new ActionFailed());
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        double distance = this.getDistance(player.getX(), player.getY());
        if (distance > 150.0) {
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
        } else if (command.startsWith("Quest")) {
            String quest = command.substring(5).trim();
            if (quest.length() == 0) {
                this.showQuestWindow(player);
            } else {
                this.showQuestWindow(player, quest);
            }
        } else if (command.startsWith("Chat")) {
            int val = Integer.parseInt(command.substring(5));
            this.showChatWindow(player, val);
        }
    }

    public void onRandomAnimation() {
        SocialAction sa = new SocialAction(this.getObjectId(), L2NpcInstance.getRnd().nextInt(8));
        this.broadcastPacket(sa);
        this.sendPacket(sa);
        this.startRandomAnimation();
    }

    public void startRandomAnimation() {
        int minWait = Config.MIN_NPC_ANIMATION;
        int maxWait = Config.MAX_NPC_ANIMATION;
        int interval = (L2NpcInstance.getRnd().nextInt(maxWait - minWait) + minWait) * 1000;
        ClientScheduler.getInstance().scheduleLow(new RandomAnimationTask(), interval);
    }

    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    public L2Weapon getActiveWeaponItem() {
        int weaponId = this.getTemplate().rhand;
        if (weaponId < 1) {
            return null;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getTemplate().rhand);
        if (!(item instanceof L2Weapon)) {
            return null;
        }
        return (L2Weapon)item;
    }

    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    public L2Weapon getSecondaryWeaponItem() {
        int weaponId = this.getTemplate().lhand;
        if (weaponId < 1) {
            return null;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getTemplate().lhand);
        if (!(item instanceof L2Weapon)) {
            return null;
        }
        return (L2Weapon)item;
    }

    public void insertObjectIdAndShowChatWindow(L2PcInstance player, String content) {
        content = content.replaceAll("%objectId%", String.valueOf(this.getObjectId()));
        NpcHtmlMessage npcReply = new NpcHtmlMessage(5);
        npcReply.setHtml(content);
        player.sendPacket(npcReply);
    }

    public String getHtmlPath(int npcId, int val) {
        String pom = "";
        pom = val == 0 ? "" + npcId : npcId + "-" + val;
        String temp = "data/html/default/" + pom + ".htm";
        File mainText = new File(Config.DATAPACK_ROOT, temp);
        if (mainText.exists()) {
            return temp;
        }
        return "data/html/npcdefault.htm";
    }

    public void showQuestChooseWindow(L2PcInstance player, Quest[] quests) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body><title>Talk about:</title><br>");
        for (Quest q : quests) {
            sb.append("<a action=\"bypass -h npc_").append(this.getObjectId()).append("_Quest ").append(q.getName()).append("\">").append(q.getDescr()).append("</a><br>");
        }
        sb.append("</body></html>");
        this.insertObjectIdAndShowChatWindow(player, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showQuestWindow(L2PcInstance player, String questId) {
        FileInputStream fis = null;
        try {
            String content;
            QuestState qs = player.getQuestState(questId);
            if (qs != null) {
                if (!qs.getQuest().notifyTalk(this.getTemplate().npcId, qs)) {
                    return;
                }
            } else if (Quest.findQuest(questId) != null) {
                Quest q = Quest.findQuest(questId);
                Quest[] qlst = this.getTemplate().getStartQuests();
                if (qlst != null && qlst.length > 0) {
                    for (int i = 0; i < qlst.length; ++i) {
                        if (qlst[i] != q) continue;
                        qs = q.newQuestState(player);
                        if (qs.getQuest().notifyTalk(this.getTemplate().npcId, qs)) break;
                        return;
                    }
                }
            }
            if (qs == null) {
                content = "<html><body>No Quest</body></html>";
            } else {
                questId = qs.getQuest().getName();
                String stateId = qs.getStateId();
                File f = new File(Config.DATAPACK_ROOT, "data/jscript/quests/" + questId + "/" + stateId + ".htm");
                if (f.exists()) {
                    if (Config.DEBUG) {
                        _log.fine("Showing quest window for quest " + questId + " html path: " + f);
                    }
                    fis = new FileInputStream(f);
                    byte[] raw = new byte[fis.available()];
                    fis.read(raw);
                    content = new String(raw, "UTF-8");
                } else {
                    if (Config.DEBUG) {
                        _log.fine("File not exists for quest " + questId + " html path: " + f);
                    }
                    content = null;
                }
            }
            if (content != null) {
                this.insertObjectIdAndShowChatWindow(player, content);
            }
        }
        catch (Exception e) {
            _log.warning("problem with npc text " + e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {}
        }
        player.sendPacket(new ActionFailed());
    }

    public void showQuestWindow(L2PcInstance player) {
        ArrayList<Object> options = new ArrayList<Object>();
        QuestState[] awaits = player.getQuestsForTalk(this.getTemplate().npcId);
        Quest[] starts = this.getTemplate().getStartQuests();
        if (awaits != null) {
            for (QuestState questState : awaits) {
                if (options.contains(questState)) continue;
                options.add(questState.getQuest());
            }
        }
        if (starts != null) {
            for (Quest quest : starts) {
                if (options.contains(quest)) continue;
                options.add(quest);
            }
        }
        if (options.size() > 1) {
            this.showQuestChooseWindow(player, options.toArray(new Quest[options.size()]));
        } else if (options.size() == 1) {
            this.showQuestWindow(player, ((Quest)options.get(0)).getName());
        } else {
            this.showQuestWindow(player, "");
        }
    }

    public void showChatWindow(L2PcInstance player, int val) {
        int npcId = this.getTemplate().npcId;
        String filename = this.getHtmlPath(npcId, val);
        NpcHtmlMessage html = new NpcHtmlMessage(1);
        html.setFile(filename);
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(html);
        player.sendPacket(new ActionFailed());
    }

    public int getExpReward() {
        return (int)((float)this.getTemplate().revardExp * Config.RATE_XP);
    }

    public int getSpReward() {
        return (int)((float)this.getTemplate().revardSp * Config.RATE_SP);
    }

    protected void doDie(L2Character killer) {
        ClientScheduler.getInstance().scheduleLow(new L2Character.DecayTask(), 7000L);
        super.doDie(killer);
    }

    public void setSpawn(L2Spawn spawn) {
        this._spawn = spawn;
    }

    public void onDecay() {
        super.onDecay();
        if (this._spawn != null) {
            this._spawn.decreaseCount(this.getTemplate().npcId);
        }
        if (this.getNpcId() == 12024) {
            L2Siege.killFlag(this.getObjectId());
        } else if (this.getNpcId() == 12314) {
            int theCastle = L2Siege.getSiege() - 1;
            int x1 = L2World.castles[theCastle][0];
            int y1 = L2World.castles[theCastle][1];
            int x2 = L2World.castles[theCastle][2];
            int y2 = L2World.castles[theCastle][3];
            if (this.getX() >= Math.min(x1, x2) && this.getX() <= Math.max(x1, x2) && this.getY() >= Math.min(y1, y2) && this.getY() <= Math.max(y1, y2)) {
                L2Siege.killCT();
            }
        }
    }

    public void deleteMe() {
        try {
            this.decayMe();
        }
        catch (Throwable t) {
            _log.log(Level.SEVERE, "deletedMe()", t);
        }
        try {
            this.removeAllKnownObjects();
        }
        catch (Throwable t) {
            _log.log(Level.SEVERE, "deletedMe()", t);
        }
        L2World.getInstance().removeObject(this);
    }

    public L2Spawn getSpawn() {
        return this._spawn;
    }

    public String toString() {
        return this.getTemplate().name;
    }

    public class RandomAnimationTask
    implements Runnable {
        public void run() {
            try {
                L2NpcInstance.this.onRandomAnimation();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

