/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.logging.Level;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.ai.CtrlEvent;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2MinionData;
import net.sf.l2j.gameserver.model.L2MinionInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class L2MonsterInstance
extends L2Attackable {
    public L2MonsterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    public boolean isAutoAttackable(L2Character attacker) {
        return !(attacker instanceof L2MonsterInstance);
    }

    public boolean isAggressive() {
        return this.getTemplate().aggroRange > 0;
    }

    public boolean hasRandomAnimation() {
        return false;
    }

    public boolean addKnownObject(L2Object object, L2Character dropper) {
        boolean ret = super.addKnownObject(object, dropper);
        if (!ret) {
            return false;
        }
        if (object instanceof L2PcInstance && this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
        }
        return true;
    }

    public void removeKnownObject(L2Object object) {
        super.removeKnownObject(object);
        if (!(object instanceof L2Character)) {
            return;
        }
        if (this.hasAI()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_FORGET_OBJECT, object);
        }
        if (this.isVisible() && this.getKnownPlayers().isEmpty()) {
            this.clearAggroList();
            this.removeAllKnownObjects();
            return;
        }
    }

    public void DoSpawn() {
        ArrayList<L2MinionData> minions = new ArrayList<L2MinionData>();
        minions.addAll(this.getTemplate().getMinionData());
        for (L2MinionData minion : minions) {
            int amount = minion.getAmount();
            int minionid = minion.getMinionId();
            for (int i = 0; i < amount; ++i) {
                this.SpawnMinion(minionid);
            }
        }
    }

    public void SpawnMinion(int minionid) {
        L2NpcTemplate minionTemplate = NpcTable.getInstance().getTemplate(minionid);
        L2MinionInstance monster = new L2MinionInstance(IdFactory.getInstance().getNextId(), minionTemplate);
        monster.setCurrentHpMp(monster.getMaxHp(), monster.getMaxMp());
        monster.setHeading(this.getHeading());
        monster.setLeader(this);
        monster.spawnMe(this.getX() + L2Character.getRnd().nextInt(120), this.getY() + L2Character.getRnd().nextInt(120), this.getZ());
        if (Config.DEBUG) {
            _log.log(Level.SEVERE, "Spawned minion template " + minionTemplate.npcId + " with objid: " + monster.getObjectId() + " to boss " + this.getObjectId() + " ,at: " + monster.getX() + " x, " + monster.getY() + " y, " + monster.getZ() + " z");
        }
    }

    public void OnSpawn() {
        try {
            ClientScheduler.getInstance().scheduleLow(new SpawnTask(), 1000L);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    class SpawnTask
    implements Runnable {
        SpawnTask() {
        }

        public void run() {
            try {
                L2MonsterInstance.this.DoSpawn();
            }
            catch (Throwable e) {
                L2Attackable._log.log(Level.SEVERE, "", e);
            }
        }
    }
}

