/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.TradeController;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2TradeList;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.BuyList;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.PrivateBuyListSell;
import net.sf.l2j.gameserver.serverpackets.SellList;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public final class L2MerchantInstance
extends L2FolkInstance
implements Runnable {
    private static Logger _log = Logger.getLogger(L2MerchantInstance.class.getName());
    private static final Random _rnd = new Random();
    private static final int[] BidsTable = new int[]{0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 120, 140, 160, 180, 200, 220, 240, 260, 280, 300, 325, 350, 375, 400, 425, 450, 475, 500, 525, 550, 575, 600, 650, 700, 750, 800, 900, 1000, 1100, 1200, 1300, 1400, 1500, 1600, 1700, 1800, 1900, 2000, 2200, 2400, 2600, 2800, 3000, 3250, 3500, 3750, 4000, 4250, 4500, 4750, 5000, 5250, 5500, 5750, 6000, 6500, 7000, 7500, 8000, 9000, 10000, 11000, 12000, 13000, 14000, 15000, 16000, 17000, 18000, 19000, 20000, 22000, 24000, 26000, 28000, 30000, 32500, 35000, 37500, 40000, 42500, 45000, 47500, 50000, 52500, 55000, 57500, 60000, 65000, 70000, 75000, 80000, 90000, 100000};
    private static final ArrayList<LeaseBidder> biddersList = new ArrayList();
    private String leaseHolderName;
    private int leaseHolderId;
    private int leaseSellListId = TradeController.getInstance().getNextId();
    private int leaseBuyListId = TradeController.getInstance().getNextId();
    private ArrayList<L2ItemInstance> leaseList;
    private L2ItemInstance leaseAdena;
    private final Date swapLeaseHolderTime;
    private ScheduledFuture swapLeaseHolderTask;
    private String auctionCurrentPlayerName;
    private int auctionCurrentPlayerId;
    private int auctionCurrentBid;

    public L2MerchantInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.loadMerchant();
        if (this.leaseHolderId != 0) {
            this.loadItems(this.leaseHolderId);
        } else {
            this.leaseList = new ArrayList();
        }
        if (this.leaseAdena == null) {
            this.leaseAdena = ItemTable.getInstance().createItem(57);
            this.leaseAdena.setOwnerId(this.leaseHolderId);
            this.leaseAdena.setLocation(L2ItemInstance.ItemLocation.LEASE, template.npcId);
            this.leaseAdena.setCount(0);
            this.leaseAdena.updateDatabase();
        }
        Calendar c = Calendar.getInstance();
        c.set(7, 7);
        c.set(11, 23);
        c.set(12, 55);
        c.set(13, 0);
        while (c.compareTo(Calendar.getInstance()) <= 0) {
            c.add(5, 7);
        }
        this.swapLeaseHolderTime = c.getTime();
        this.swapLeaseHolderTask = ClientScheduler.getInstance().scheduleLow(this, (long)(100 + _rnd.nextInt(300000)) + this.swapLeaseHolderTime.getTime() - System.currentTimeMillis());
    }

    public synchronized void run() {
        if (this.swapLeaseHolderTime.before(new Date())) {
            this.swapLeaseHolder();
        }
    }

    public L2ItemInstance[] listLeaseItems() {
        return this.leaseList.toArray(new L2ItemInstance[this.leaseList.size()]);
    }

    public L2ItemInstance getLeaseAdena() {
        return this.leaseAdena;
    }

    public int getLeaseHolderId() {
        return this.leaseHolderId;
    }

    public L2ItemInstance getLeaseItemByObjectId(int object_id) {
        for (L2ItemInstance li : this.leaseList) {
            if (li.getObjectId() != object_id) continue;
            return li;
        }
        return null;
    }

    private static int findBidIndex(int bid) {
        bid /= 1000;
        for (int i = 0; i < BidsTable.length; ++i) {
            if (bid > BidsTable[i]) continue;
            return i;
        }
        return BidsTable.length;
    }

    public void onAction(L2PcInstance player) {
        if (Config.DEBUG) {
            _log.fine("Merchant activated");
        }
        player.setLastFolkNPC(this);
        super.onAction(player);
    }

    public String getHtmlPath(int npcId, int val) {
        String pom = "";
        pom = val == 0 ? "" + npcId : npcId + "-" + val;
        return "data/html/merchant/" + pom + ".htm";
    }

    private void showBuyWindow(L2PcInstance player, int val) {
        L2TradeList list;
        player.tempInvetoryDisable();
        if (Config.DEBUG) {
            _log.fine("Showing buylist");
        }
        if ((list = TradeController.getInstance().getBuyList(val)) != null) {
            BuyList bl = new BuyList(list, player.getAdena());
            player.sendPacket(bl);
        } else {
            _log.warning("no buylist with id:" + val);
        }
        player.sendPacket(new ActionFailed());
    }

    private void showSellWindow(L2PcInstance player) {
        if (Config.DEBUG) {
            _log.fine("Showing selllist");
        }
        SellList sl = new SellList(player);
        player.sendPacket(sl);
        if (Config.DEBUG) {
            _log.fine("Showing sell window");
        }
        player.sendPacket(new ActionFailed());
    }

    private void showLeaseBuyWindow(L2PcInstance player) {
        if (Config.DEBUG) {
            _log.fine("Showing lease buylist");
        }
        player.setLastFolkNPC(this);
        player.sendPacket(new PrivateBuyListSell(player, this));
        player.sendPacket(new ActionFailed());
    }

    private void showLeaseSellWindow(L2PcInstance player) {
        if (Config.DEBUG) {
            _log.fine("Showing lease selllist");
        }
        player.setLastFolkNPC(this);
        player.sendPacket(new SellList(player, this));
        player.sendPacket(new ActionFailed());
    }

    private void showManageWindow(L2PcInstance player, String error, int item_id, int enchant, int sell, int buy) {
        if (player.getObjectId() != this.leaseHolderId) {
            this.showLeaseWindow(player, error);
            return;
        }
        StringBuffer html1 = new StringBuffer("<html><body>");
        if (error != null) {
            html1.append("Error: " + error + "</br>");
        }
        String name = "???";
        int cur_sell = 0;
        int cur_buy = 0;
        L2Item item = ItemTable.getInstance().getTemplate(item_id);
        if (item != null) {
            name = item.getName();
        }
        for (L2ItemInstance li : this.leaseList) {
            if (li.getItemId() != item_id || li.getEnchantLevel() != enchant) continue;
            cur_sell = li.getPriceToSell();
            cur_buy = li.getPriceToBuy();
            break;
        }
        html1.append("<a action=\"bypass -h npc_%objectId%_Lease\">Lease</a></br>");
        html1.append("<a action=\"bypass -h npc_%objectId%_LSell\">Sell</a></br>");
        html1.append("<a action=\"bypass -h npc_%objectId%_LBuy\">Buy</a></br>");
        html1.append("<center>Manage items</center><br>");
        html1.append("<table>");
        html1.append("<tr><td>Item ID</td><td><edit var=\"id\" width=80></td><td width=100>" + name + "</td></tr>");
        html1.append("<tr><td>Enchant lelev</td><td><edit var=\"enchant\" width=80></td><td>" + enchant + "</td></tr>");
        html1.append("<tr><td>Price to sell</td><td><edit var=\"sell\" width=80></td><td>" + cur_sell + "</td></tr>");
        html1.append("<tr><td>Proice to buy</td><td><edit var=\"buy\" width=80></td><td>" + cur_buy + "</td></tr>");
        html1.append("</table><br>");
        html1.append("<button value=\"Set\" action=\"bypass -h npc_%objectId%_Items set $id $sell $buy $enchant\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></br>");
        html1.append("<button value=\"View\" action=\"bypass -h npc_%objectId%_Items view $id $enchant\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></br>");
        html1.append("<button value=\"Remove\" action=\"bypass -h npc_%objectId%_Items del $id $enchant\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></br>");
        html1.append("</body></html>");
        this.insertObjectIdAndShowChatWindow(player, html1.toString());
    }

    private void showLeaseWindow(L2PcInstance player, String error) {
        String bid;
        StringBuffer html1 = new StringBuffer("<html><body>");
        if (error != null) {
            html1.append("Error: " + error + "</br>");
        }
        html1.append("<center>Lease</center></br>");
        NumberFormat nf = NumberFormat.getInstance();
        int idx = 1 + L2MerchantInstance.findBidIndex(this.auctionCurrentBid);
        if (idx >= BidsTable.length) {
            html1.append("Auction closed</br>");
        } else {
            bid = nf.format(BidsTable[idx] * 1000);
            html1.append("Your bid: <button value=\"" + bid + "\" action=\"bypass -h npc_%objectId%_Lease " + BidsTable[idx] * 1000 + "\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></br>");
        }
        bid = nf.format(this.auctionCurrentBid);
        html1.append("Last bid: " + bid + " by " + this.auctionCurrentPlayerName + "</br></br>");
        html1.append("<a action=\"bypass -h npc_%objectId%_LSell\">Sell to leaseholder</a></br>");
        html1.append("<a action=\"bypass -h npc_%objectId%_LBuy\">Buy from leaseholder</a></br>");
        html1.append("</body></html>");
        this.insertObjectIdAndShowChatWindow(player, html1.toString());
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("Buy")) {
            int val = Integer.parseInt(command.substring(4));
            this.showBuyWindow(player, val);
        } else if (command.equals("Sell")) {
            this.showSellWindow(player);
        }
        if (command.startsWith("LBuy")) {
            this.showLeaseBuyWindow(player);
        } else if (command.equals("LSell")) {
            this.showLeaseSellWindow(player);
        } else if (command.startsWith("Lease")) {
            String err = null;
            if ((command = command.substring(5).trim()).length() > 0) {
                if (command.equals("next")) {
                    err = player.isGM() ? this.swapLeaseHolder() : "You are not GM";
                } else if (command.equals("manage")) {
                    if (player.getObjectId() == this.leaseHolderId) {
                        this.showManageWindow(player, null, 0, 0, 0, 0);
                        return;
                    }
                    err = "You are not the leaseholder";
                } else {
                    err = L2MerchantInstance.addBid(this, player, Integer.parseInt(command));
                }
            }
            this.showLeaseWindow(player, err);
        } else if (command.startsWith("Items")) {
            command = command.substring(5).trim();
            StringTokenizer st = new StringTokenizer(command);
            String action = st.nextToken();
            int item_id = 0;
            int sell = 0;
            int buy = 0;
            int enchant = 0;
            if (action.equals("set")) {
                String s_item_id = st.nextToken();
                String s_sell = st.nextToken();
                String s_buy = st.nextToken();
                item_id = Integer.parseInt(s_item_id);
                sell = Integer.parseInt(s_sell);
                buy = Integer.parseInt(s_buy);
                if (st.hasMoreTokens()) {
                    enchant = Integer.parseInt(st.nextToken());
                }
                this.setLeaseItemInfo(item_id, sell, buy, enchant);
            } else if (action.equals("del")) {
                String s_item_id = st.nextToken();
                item_id = Integer.parseInt(s_item_id);
                if (st.hasMoreTokens()) {
                    enchant = Integer.parseInt(st.nextToken());
                }
            } else if (action.equals("view")) {
                String s_item_id = st.nextToken();
                item_id = Integer.parseInt(s_item_id);
                if (st.hasMoreTokens()) {
                    enchant = Integer.parseInt(st.nextToken());
                }
            }
            this.showManageWindow(player, null, item_id, enchant, sell, buy);
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public void onActionShift(ClientThread client) {
        L2PcInstance player = client.getActiveChar();
        if (player.getAccessLevel() >= Config.GM_ACCESSLEVEL) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            if (this.isAutoAttackable(player)) {
                StatusUpdate su = new StatusUpdate(this.getObjectId());
                su.addAttribute(StatusUpdate.CUR_HP, (int)this.getCurrentHp());
                su.addAttribute(StatusUpdate.MAX_HP, this.getMaxHp());
                player.sendPacket(su);
            }
            NpcHtmlMessage html = new NpcHtmlMessage(1);
            StringBuffer html1 = new StringBuffer("<html><body><table border=0>");
            html1.append("<tr><td>Current Target:</td></tr>");
            html1.append("<tr><td><br></td></tr>");
            html1.append("<tr><td>Object ID: " + this.getObjectId() + "</td></tr>");
            html1.append("<tr><td>Template ID: " + this.getTemplate().npcId + "</td></tr>");
            html1.append("<tr><td><br></td></tr>");
            html1.append("<tr><td>HP: " + this.getCurrentHp() + "</td></tr>");
            html1.append("<tr><td>MP: " + this.getCurrentMp() + "</td></tr>");
            html1.append("<tr><td>Level: " + this.getLevel() + "</td></tr>");
            html1.append("<tr><td><br></td></tr>");
            html1.append("<tr><td>Class: " + this.getClass().getName() + "</td></tr>");
            html1.append("<tr><td><br></td></tr>");
            html1.append("</table><table><tr><td><button value=\"Edit NPC\" action=\"bypass -h admin_edit_npc " + this.getTemplate().npcId + "\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
            html1.append("<td><button value=\"Kill\" action=\"bypass -h admin_kill\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            html1.append("<tr><td><button value=\"Show DropList\" action=\"bypass -h admin_show_droplist " + this.getTemplate().npcId + "\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            html1.append("<td><button value=\"Delete\" action=\"bypass -h admin_delete\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            html1.append("</table>");
            if (player.isGM()) {
                html1.append("<button value=\"View Shop\" action=\"bypass -h admin_showShop " + this.getTemplate().npcId + "\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></br>");
                html1.append("<button value=\"Lease next week\" action=\"bypass -h npc_" + this.getObjectId() + "_Lease\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
                html1.append("<button value=\"Abort current leasing\" action=\"bypass -h npc_" + this.getObjectId() + "_Lease next\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
                html1.append("<button value=\"Manage items\" action=\"bypass -h npc_" + this.getObjectId() + "_Lease manage\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
            }
            html1.append("</body></html>");
            html.setHtml(html1.toString());
            player.sendPacket(html);
        } else {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            if (player.getObjectId() != this.leaseHolderId) {
                this.showLeaseWindow(player, null);
            } else {
                this.showManageWindow(player, null, 0, 0, 0, 0);
            }
        }
        player.sendPacket(new ActionFailed());
    }

    public L2ItemInstance findLeaseItem(int item_id, int enchant) {
        if (item_id == 57) {
            return this.leaseAdena;
        }
        for (L2ItemInstance li : this.leaseList) {
            if (li.getItemId() != item_id || li.getEnchantLevel() != enchant) continue;
            return li;
        }
        return null;
    }

    private synchronized void setLeaseItemInfo(int item_id, int sell, int buy, int enchant) {
        L2Item item = ItemTable.getInstance().getTemplate(item_id);
        if (item == null || !item.isSellable()) {
            return;
        }
        if (item.isStackable()) {
            enchant = 0;
        }
        for (L2ItemInstance li : this.leaseList) {
            if (li.getItemId() != item_id || li.getEnchantLevel() != enchant) continue;
            li.setPriceToSell(sell);
            li.setPriceToBuy(buy);
            li.updateDatabase();
            return;
        }
        L2ItemInstance inst = new L2ItemInstance(IdFactory.getInstance().getNextId(), item_id);
        inst.setOwnerId(this.leaseHolderId);
        inst.setLocation(L2ItemInstance.ItemLocation.LEASE, this.getTemplate().npcId);
        inst.setCount(0);
        inst.setEnchantLevel(enchant);
        inst.setPriceToSell(sell);
        inst.setPriceToBuy(buy);
        this.leaseList.add(inst);
        inst.updateDatabase();
    }

    private synchronized String swapLeaseHolder() {
        this.swapLeaseHolderTask.cancel(false);
        Calendar c = Calendar.getInstance();
        c.setTime(this.swapLeaseHolderTime);
        c.add(5, 7);
        this.swapLeaseHolderTime.setTime(c.getTime().getTime());
        this.swapLeaseHolderTask = ClientScheduler.getInstance().scheduleLow(this, (long)(100 + _rnd.nextInt(300000)) + this.swapLeaseHolderTime.getTime() - System.currentTimeMillis());
        int oldHolderId = this.leaseHolderId;
        this.leaseHolderName = this.auctionCurrentPlayerName;
        this.leaseHolderId = this.auctionCurrentPlayerId;
        this.auctionCurrentPlayerName = null;
        this.auctionCurrentPlayerId = 0;
        this.auctionCurrentBid = 0;
        if (oldHolderId == this.leaseHolderId) {
            L2MerchantInstance.removeBidder(this.getTemplate().npcId, this.leaseHolderId, BidderDbType.AUCTION);
            return null;
        }
        this.leaseList = new ArrayList();
        if (oldHolderId != 0) {
            L2MerchantInstance.removeBidder(this.getTemplate().npcId, oldHolderId, BidderDbType.LEASEHOLDER);
        }
        if (this.leaseHolderId != 0) {
            L2MerchantInstance.removeBidder(this.getTemplate().npcId, this.leaseHolderId, BidderDbType.AUCTION);
            L2MerchantInstance.addBidder(this.getTemplate().npcId, this.leaseHolderId, BidderDbType.LEASEHOLDER, 0, this.leaseHolderName);
        }
        if (oldHolderId != 0) {
            L2MerchantInstance.returnItems(this.getTemplate().npcId, oldHolderId);
            return null;
        }
        return null;
    }

    public static synchronized void playerEnter(L2PcInstance player) {
        for (LeaseBidder b : biddersList) {
            if (b.player_id != player.getObjectId()) continue;
            L2MerchantInstance.removeBidder(0, b.player_id, BidderDbType.RETURN_ADENA);
            player.addAdena(b.adena_to_return);
            biddersList.remove(b);
            break;
        }
    }

    private static synchronized String addBid(L2MerchantInstance merchant, L2PcInstance player, int adena) {
        boolean ok;
        int idx = L2MerchantInstance.findBidIndex(adena);
        if ((adena = BidsTable[idx] * 1000) <= merchant.auctionCurrentBid) {
            return merchant.auctionCurrentPlayerName + " already make a bid of " + merchant.auctionCurrentBid + " adena";
        }
        if (merchant.auctionCurrentPlayerId == player.getObjectId()) {
            if (player.getAdena() < (adena -= merchant.auctionCurrentBid)) {
                return "You need " + adena + " adena to make this bid";
            }
            boolean ok2 = L2MerchantInstance.updateBidder(merchant.getTemplate().npcId, player.getObjectId(), BidderDbType.AUCTION, merchant.auctionCurrentBid + adena);
            if (!ok2) {
                return "Cannot make the bid, please retry";
            }
            player.reduceAdena(adena);
            merchant.auctionCurrentBid += adena;
            return null;
        }
        if (player.getAdena() < adena) {
            return "You need " + adena + " adena to make this bid";
        }
        player.reduceAdena(adena);
        if (merchant.auctionCurrentPlayerId != 0) {
            ok = L2MerchantInstance.removeBidder(merchant.getTemplate().npcId, merchant.auctionCurrentPlayerId, BidderDbType.AUCTION);
            if (!ok) {
                return "Cannot make the bid, please retry";
            }
            L2PcInstance old = L2World.getInstance().getPlayer(merchant.auctionCurrentPlayerName);
            if (old != null && old.isOnline() != 0) {
                old.addAdena(merchant.auctionCurrentBid);
                merchant.auctionCurrentPlayerId = 0;
            } else {
                for (LeaseBidder b : biddersList) {
                    if (b.player_id != merchant.auctionCurrentPlayerId) continue;
                    ok = L2MerchantInstance.updateBidder(0, b.player_id, BidderDbType.RETURN_ADENA, b.adena_to_return + merchant.auctionCurrentBid);
                    if (!ok) {
                        return "Cannot make the bid, please retry";
                    }
                    b.adena_to_return += merchant.auctionCurrentBid;
                    merchant.auctionCurrentPlayerId = 0;
                }
                if (merchant.auctionCurrentPlayerId != 0) {
                    LeaseBidder b = new LeaseBidder();
                    b.player_id = merchant.auctionCurrentPlayerId;
                    b.adena_to_return = merchant.auctionCurrentBid;
                    ok = L2MerchantInstance.addBidder(0, merchant.auctionCurrentPlayerId, BidderDbType.RETURN_ADENA, merchant.auctionCurrentBid, merchant.auctionCurrentPlayerName);
                    if (!ok) {
                        return "Cannot make the bid, please retry";
                    }
                    biddersList.add(b);
                    merchant.auctionCurrentPlayerId = 0;
                }
            }
        }
        if (!(ok = L2MerchantInstance.addBidder(merchant.getTemplate().npcId, player.getObjectId(), BidderDbType.AUCTION, adena, player.getName()))) {
            return "Cannot make the bid, please retry";
        }
        merchant.auctionCurrentBid = adena;
        merchant.auctionCurrentPlayerId = player.getObjectId();
        merchant.auctionCurrentPlayerName = player.getName();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean addBidder(int merchant_id, int player_id, BidderDbType bt, int bid, String name) {
        boolean ok;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement1 = con.prepareStatement("INSERT INTO merchant_lease (merchant_id, player_id, bid, type, player_name) VALUES (?,?,?,?,?)");
            statement1.setInt(1, merchant_id);
            statement1.setInt(2, player_id);
            statement1.setInt(3, bid);
            statement1.setInt(4, bt.ordinal());
            statement1.setString(5, name);
            ok = statement1.executeUpdate() > 0;
            statement1.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean updateBidder(int merchant_id, int player_id, BidderDbType bt, int bid) {
        boolean ok;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement1 = con.prepareStatement("UPDATE merchant_lease SET bid=? WHERE merchant_id = ? AND player_id = ? AND type = ?");
            statement1.setInt(1, bid);
            statement1.setInt(2, merchant_id);
            statement1.setInt(3, player_id);
            statement1.setInt(4, bt.ordinal());
            ok = statement1.executeUpdate() > 0;
            statement1.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean removeBidder(int merchant_id, int player_id, BidderDbType bt) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement1 = con.prepareStatement("DELETE FROM merchant_lease WHERE merchant_id = ? AND player_id = ? AND type = ?");
            statement1.setInt(1, merchant_id);
            statement1.setInt(2, player_id);
            statement1.setInt(3, bt.ordinal());
            statement1.executeUpdate();
            statement1.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean returnItems(int merchant_id, int player_id) {
        boolean ok;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement1 = con.prepareStatement("UPDATE items SET loc='WAREHOUSE', loc_data=0  WHERE loc='LEASE' AND loc_data=? AND owner_id = ?");
            statement1.setInt(1, merchant_id);
            statement1.setInt(2, player_id);
            ok = statement1.executeUpdate() > 0;
            statement1.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBidders() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT merchant_id, player_id, bid, type, player_name FROM merchant_lease WHERE merchant_id = 0");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int objId = rset.getInt("player_id");
                int adena = rset.getInt("bid");
                int type = rset.getInt("type");
                if (type != BidderDbType.RETURN_ADENA.ordinal()) continue;
                LeaseBidder b = new LeaseBidder();
                b.player_id = objId;
                b.adena_to_return = adena;
                biddersList.add(b);
            }
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMerchant() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT merchant_id, player_id, bid, type, player_name FROM merchant_lease WHERE merchant_id = ?");
            statement.setInt(1, this.getTemplate().npcId);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int objId = rset.getInt("player_id");
                int bid = rset.getInt("bid");
                int type = rset.getInt("type");
                String name = rset.getString("player_name");
                if (type == BidderDbType.LEASEHOLDER.ordinal()) {
                    this.leaseHolderId = objId;
                    this.leaseHolderName = name;
                    continue;
                }
                if (type != BidderDbType.AUCTION.ordinal()) continue;
                this.auctionCurrentPlayerId = objId;
                this.auctionCurrentBid = bid;
                this.auctionCurrentPlayerName = name;
            }
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadItems(int player_id) {
        this.leaseList = new ArrayList();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT object_id FROM items WHERE loc='LEASE' and loc_data=? AND owner_id=?");
            statement.setInt(1, this.getTemplate().npcId);
            statement.setInt(2, player_id);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int object_id = rset.getInt("object_id");
                L2ItemInstance item = L2ItemInstance.restoreFromDb(object_id);
                if (item.getItemId() == 57) {
                    this.leaseAdena = item;
                    continue;
                }
                this.leaseList.add(item);
            }
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        L2MerchantInstance.loadBidders();
    }

    private static class LeaseBidder {
        int player_id;
        int adena_to_return;

        private LeaseBidder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BidderDbType {
        RETURN_ADENA,
        LEASEHOLDER,
        AUCTION;

    }
}

