/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.skills.Func;
import net.sf.l2j.gameserver.templates.L2Armor;
import net.sf.l2j.gameserver.templates.L2EtcItem;
import net.sf.l2j.gameserver.templates.L2Item;

public final class L2ItemInstance
extends L2Object {
    private static final Logger _log = Logger.getLogger(L2ItemInstance.class.getName());
    private int _owner_id;
    private int _count;
    private final int _itemId;
    private final L2Item _item;
    private ItemLocation _loc;
    private int _loc_data;
    private int _enchantLevel;
    private int _price_sell;
    private int _price_buy;
    public static final int CHARGED_NONE = 0;
    public static final int CHARGED_SOULSHOT = 1;
    public static final int CHARGED_SPIRITSHOT = 1;
    public static final int CHARGED_BLESSED_SOULSHOT = 2;
    public static final int CHARGED_BLESSED_SPIRITSHOT = 2;
    private int _chargedSoulshot = 0;
    private int _chargedSpiritshot = 0;
    public static final int UNCHANGED = 0;
    public static final int ADDED = 1;
    public static final int REMOVED = 3;
    public static final int MODIFIED = 2;
    private int _lastChange = 2;
    private boolean _existsInDb;
    private boolean _storedInDb;

    public L2ItemInstance(int objectId, int itemId) {
        super(objectId);
        this._itemId = itemId;
        this._item = ItemTable.getInstance().getTemplate(itemId);
        if (this._itemId == 0 || this._item == null) {
            throw new IllegalArgumentException();
        }
        this._count = 1;
        this._loc = ItemLocation.VOID;
    }

    public L2ItemInstance(int objectId, L2Item item) {
        super(objectId);
        this._itemId = item.getItemId();
        this._item = item;
        if (this._itemId == 0 || this._item == null) {
            throw new IllegalArgumentException();
        }
        this._count = 1;
        this._loc = ItemLocation.VOID;
    }

    public void setOwnerId(int owner_id) {
        if (owner_id == this._owner_id) {
            return;
        }
        this._owner_id = owner_id;
        this._storedInDb = false;
    }

    public int getOwnerId() {
        return this._owner_id;
    }

    public void setLocation(ItemLocation loc) {
        this.setLocation(loc, 0);
    }

    public void setLocation(ItemLocation loc, int loc_data) {
        if (loc == this._loc && loc_data == this._loc_data) {
            return;
        }
        this._loc = loc;
        this._loc_data = loc_data;
        this._storedInDb = false;
    }

    public int getCount() {
        return this._count;
    }

    public void setCount(int count) {
        if (this._count == count) {
            return;
        }
        this._count = count;
        this._storedInDb = false;
    }

    public boolean isEquipable() {
        return this._item.getBodyPart() != 0 && !(this._item instanceof L2EtcItem);
    }

    public boolean isEquipped() {
        return this._loc == ItemLocation.PAPERDOLL || this._loc == ItemLocation.PET_EQUIP;
    }

    public int getEquipSlot() {
        if (Config.ASSERT) assert (this._loc == ItemLocation.PAPERDOLL || this._loc == ItemLocation.PET_EQUIP);
        return this._loc_data;
    }

    public L2Item getItem() {
        return this._item;
    }

    public Enum getItemType() {
        return this._item.getItemType();
    }

    public int getItemId() {
        return this._itemId;
    }

    public int getReferencePrice() {
        return this._item.getReferencePrice();
    }

    public int getPriceToSell() {
        return this._price_sell;
    }

    public void setPriceToSell(int price) {
        this._price_sell = price;
        this._storedInDb = false;
    }

    public int getPriceToBuy() {
        return this._price_buy;
    }

    public void setPriceToBuy(int price) {
        this._price_buy = price;
        this._storedInDb = false;
    }

    public int getLastChange() {
        return this._lastChange;
    }

    public void setLastChange(int lastChange) {
        this._lastChange = lastChange;
    }

    public boolean isStackable() {
        return this._item.isStackable();
    }

    public void onAction(L2PcInstance player) {
        player.getAI().setIntention(CtrlIntention.AI_INTENTION_PICK_UP, this);
    }

    public int getEnchantLevel() {
        return this._enchantLevel;
    }

    public void setEnchantLevel(int enchantLevel) {
        if (this._enchantLevel == enchantLevel) {
            return;
        }
        this._enchantLevel = enchantLevel;
        this._storedInDb = false;
    }

    public int getPDef() {
        if (this._item instanceof L2Armor) {
            return ((L2Armor)this._item).getPDef();
        }
        return 0;
    }

    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    public int getChargedSoulshot() {
        return this._chargedSoulshot;
    }

    public int getChargedSpiritshot() {
        return this._chargedSpiritshot;
    }

    public void setChargedSoulshot(int type) {
        this._chargedSoulshot = type;
    }

    public void setChargedSpiritshot(int type) {
        this._chargedSpiritshot = type;
    }

    public Func[] getStatFuncs(L2Character player) {
        return this.getItem().getStatFuncs(this, player);
    }

    public void updateDatabase() {
        if (this._existsInDb) {
            if (this._owner_id == 0 || this._loc == ItemLocation.VOID || this._count == 0 && this._loc != ItemLocation.LEASE) {
                this.removeFromDb();
            } else {
                this.updateInDb();
            }
        } else {
            if (this._count == 0 && this._loc != ItemLocation.LEASE) {
                return;
            }
            if (this._loc == ItemLocation.VOID || this._owner_id == 0) {
                return;
            }
            this.insertIntoDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static L2ItemInstance restoreFromDb(int objectId) {
        L2ItemInstance inst = null;
        Connection con = null;
        try {
            L2Item item;
            int price_buy;
            int price_sell;
            int enchant_level;
            int loc_data;
            ItemLocation loc;
            int count;
            int owner_id;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT owner_id, object_id, item_id, count, enchant_level, loc, loc_data, price_sell, price_buy FROM items WHERE object_id = ?");
            statement.setInt(1, objectId);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                owner_id = rs.getInt("owner_id");
                int item_id = rs.getInt("item_id");
                count = rs.getInt("count");
                loc = ItemLocation.valueOf(rs.getString("loc"));
                loc_data = rs.getInt("loc_data");
                enchant_level = rs.getInt("enchant_level");
                price_sell = rs.getInt("price_sell");
                price_buy = rs.getInt("price_buy");
                item = ItemTable.getInstance().getTemplate(item_id);
                if (item == null) {
                    _log.severe("Item item_id=" + item_id + " not known, object_id=" + objectId);
                    L2ItemInstance l2ItemInstance = null;
                    return l2ItemInstance;
                }
            } else {
                _log.severe("Item object_id=" + objectId + " not found");
                L2ItemInstance l2ItemInstance = null;
                return l2ItemInstance;
            }
            inst = new L2ItemInstance(objectId, item);
            inst._existsInDb = true;
            inst._storedInDb = true;
            inst._owner_id = owner_id;
            inst._count = count;
            inst._enchantLevel = enchant_level;
            inst._loc = loc;
            inst._loc_data = loc_data;
            inst._price_sell = price_sell;
            inst._price_buy = price_buy;
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not restore item " + objectId + " from DB:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInDb() {
        if (Config.ASSERT) assert (this._existsInDb);
        if (this._storedInDb) {
            return;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE items SET owner_id=?,count=?,loc=?,loc_data=?,enchant_level=?,price_sell=?,price_buy=? WHERE object_id = ?");
            statement.setInt(1, this._owner_id);
            statement.setInt(2, this.getCount());
            statement.setString(3, this._loc.name());
            statement.setInt(4, this._loc_data);
            statement.setInt(5, this.getEnchantLevel());
            statement.setInt(6, this._price_sell);
            statement.setInt(7, this._price_buy);
            statement.setInt(8, this.getObjectId());
            statement.executeUpdate();
            this._existsInDb = true;
            this._storedInDb = true;
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not update item " + this.getObjectId() + " in DB:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoDb() {
        if (Config.ASSERT) assert (!this._existsInDb && this.getObjectId() != 0);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO items (owner_id,item_id,count,loc,loc_data,enchant_level,price_sell,price_buy,object_id) VALUES (?,?,?,?,?,?,?,?,?)");
            statement.setInt(1, this._owner_id);
            statement.setInt(2, this._itemId);
            statement.setInt(3, this.getCount());
            statement.setString(4, this._loc.name());
            statement.setInt(5, this._loc_data);
            statement.setInt(6, this.getEnchantLevel());
            statement.setInt(7, this._price_sell);
            statement.setInt(8, this._price_buy);
            statement.setInt(9, this.getObjectId());
            statement.executeUpdate();
            this._existsInDb = true;
            this._storedInDb = true;
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not insert item " + this.getObjectId() + " into DB:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDb() {
        if (Config.ASSERT) assert (this._existsInDb);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM items WHERE object_id=?");
            statement.setInt(1, this.getObjectId());
            statement.executeUpdate();
            this._existsInDb = false;
            this._storedInDb = false;
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not delete item " + this.getObjectId() + " in DB:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public String toString() {
        return "" + this._item;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ItemLocation {
        VOID,
        INVENTORY,
        PAPERDOLL,
        WAREHOUSE,
        CLANWH,
        PET,
        PET_EQUIP,
        LEASE;

    }
}

