/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.Territory;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class L2GroupSpawn
extends L2Spawn {
    private Constructor _constructor = Class.forName("net.sf.l2j.gameserver.model.L2ControllableMobInstance").getConstructors()[0];
    private L2NpcTemplate _template;

    public L2GroupSpawn(L2NpcTemplate mobTemplate) throws SecurityException, ClassNotFoundException {
        super(mobTemplate);
        this._template = mobTemplate;
        this.setAmount(1);
    }

    public L2NpcInstance doGroupSpawn() {
        L2NpcInstance mob = null;
        try {
            int newlocz;
            int newlocy;
            int newlocx;
            if (this._template.type.equalsIgnoreCase("L2Pet") || this._template.type.equalsIgnoreCase("L2Minion")) {
                return null;
            }
            Object[] parameters = new Object[]{IdFactory.getInstance().getNextId(), this._template};
            Object tmp = this._constructor.newInstance(parameters);
            if (!(tmp instanceof L2NpcInstance)) {
                return null;
            }
            mob = (L2NpcInstance)tmp;
            if (this.getLocx() == 0 && this.getLocy() == 0) {
                if (this.getLocation() == 0) {
                    return null;
                }
                int[] p = Territory.getInstance().getRandomPoint(this.getLocation());
                newlocx = p[0];
                newlocy = p[1];
                newlocz = p[2];
            } else {
                newlocx = this.getLocx();
                newlocy = this.getLocy();
                newlocz = this.getLocz();
            }
            mob.setCurrentHpMp(mob.getMaxHp(), mob.getMaxMp());
            if (this.getHeading() == -1) {
                mob.setHeading(L2Character.getRnd().nextInt(61794));
            } else {
                mob.setHeading(this.getHeading());
            }
            mob.setSpawn(this);
            mob.spawnMe(newlocx, newlocy, newlocz);
            mob.OnSpawn();
            if (Config.DEBUG) {
                _log.finest("spawned Mob ID: " + this._template.npcId + " ,at: " + mob.getX() + " x, " + mob.getY() + " y, " + mob.getZ() + " z");
            }
            return mob;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "NPC class not found", e);
            return null;
        }
    }
}

