/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.SkillTable;
import net.sf.l2j.gameserver.SkillTreeTable;
import net.sf.l2j.gameserver.model.ClassId;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2SkillLearn;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.AquireSkillList;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class L2FolkInstance
extends L2NpcInstance {
    private static Logger _log = Logger.getLogger(L2FolkInstance.class.getName());
    private final ClassId[] _classesToTeach;

    public L2FolkInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this._classesToTeach = template.getTeachInfo();
    }

    public void showSkillList(L2PcInstance player, ClassId classId) {
        if (Config.DEBUG) {
            _log.fine("SkillList activated on: " + this.getObjectId());
        }
        int npcId = this.getTemplate().npcId;
        L2SkillLearn[] skills = SkillTreeTable.getInstance().getAvailableSkills(player, classId);
        AquireSkillList asl = new AquireSkillList();
        for (int i = 0; i < skills.length; ++i) {
            L2SkillLearn s = skills[i];
            L2Skill sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
            if (sk == null || !sk.getCanLearn(player.getClassId()) || !sk.canTeachBy(npcId)) continue;
            int cost = SkillTreeTable.getInstance().getSkillCost(player, sk);
            asl.addSkill(s.getId(), s.getLevel(), s.getLevel(), cost, 0);
        }
        player.sendPacket(asl);
        player.sendPacket(new ActionFailed());
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("SkillList")) {
            if (Config.ALT_GAME_SKILL_LEARN) {
                String id = command.substring(9).trim();
                if (id.length() != 0) {
                    player.setSkillLearningClassId(ClassId.values()[Integer.parseInt(id)]);
                    this.showSkillList(player, ClassId.values()[Integer.parseInt(id)]);
                } else {
                    boolean own_class = false;
                    if (this._classesToTeach != null) {
                        for (ClassId cid : this._classesToTeach) {
                            if (!cid.equalsOrChildOf(player.getClassId())) continue;
                            own_class = true;
                            break;
                        }
                    }
                    String text = "<html>\n<body>\n<center>Skill learning:</center>\n<br>\n";
                    if (!own_class) {
                        String mages = player.getClassId().isMage() ? "fighters" : "mages";
                        text = text + "Skills of your class are the easiest to learn.<br>\nSkills of another class are harder.<br>\nSkills for another race are event more harder to learn.<br>\nYou can also learn skills of " + mages + ", and they are" + " the harders to learn!<br>\n" + "<br>\n";
                    }
                    for (ClassId cid : this._classesToTeach) {
                        if (cid.level() != player.getClassId().level() || SkillTreeTable.getInstance().getAvailableSkills(player, cid).length == 0) continue;
                        text = text + "<a action=\"bypass -h npc_%objectId%_SkillList " + cid.getId() + "\">Learn " + (Object)((Object)cid) + "'s class Skills</a><br>\n";
                    }
                    text = text + "</body>\n</html>";
                    this.insertObjectIdAndShowChatWindow(player, text);
                    player.sendPacket(new ActionFailed());
                }
            } else {
                player.setSkillLearningClassId(player.getClassId());
                this.showSkillList(player, player.getClassId());
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }
}

