/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.MagicEffectIcons;
import net.sf.l2j.gameserver.skills.EffectTemplate;
import net.sf.l2j.gameserver.skills.Env;
import net.sf.l2j.gameserver.skills.Func;
import net.sf.l2j.gameserver.skills.FuncTemplate;
import net.sf.l2j.gameserver.skills.Lambda;
import net.sf.l2j.gameserver.templates.L2Item;

public abstract class L2Effect {
    static final Logger _log = Logger.getLogger(L2Effect.class.getName());
    private static final Func[] _emptyFunctionSet = new Func[0];
    private final L2Character _effector;
    private final L2Character _effected;
    private final L2Skill _skill;
    private final L2Item _item;
    private final Lambda _lambda;
    private EffectState _state = EffectState.CREATED;
    private final int _period;
    private final FuncTemplate[] _funcTemplates;
    private int _count;
    private short _abnormalEffect;
    private ScheduledFuture _currentFuture;
    private EffectTask _currentTask;
    private final String _stackType;
    private final int _stackOrder;
    private boolean _inUse = false;

    protected L2Effect(Env env, EffectTemplate template) {
        this._skill = env._skill;
        this._item = env._item == null ? null : env._item.getItem();
        this._effected = env._target;
        this._effector = env._player;
        this._lambda = template._lambda;
        this._funcTemplates = template._funcTemplates;
        this._count = template._counter;
        this._period = template._period;
        this._abnormalEffect = template._abnormalEffect;
        this._stackType = template._stackType;
        this._stackOrder = template._stackOrder;
        this.scheduleEffect();
    }

    public boolean getInUse() {
        return this._inUse;
    }

    public void setInUse(boolean inUse) {
        this._inUse = inUse;
    }

    public String getStackType() {
        return this._stackType;
    }

    public int getStackOrder() {
        return this._stackOrder;
    }

    public final L2Skill getSkill() {
        return this._skill;
    }

    public final L2Character getEffector() {
        return this._effector;
    }

    public final L2Character getEffected() {
        return this._effected;
    }

    public final double calc() {
        Env env = new Env();
        env._player = this._effector;
        env._target = this._effected;
        env._skill = this._skill;
        return this._lambda.calc(env);
    }

    private synchronized void startEffectTask(int duration) {
        this.stopEffectTask();
        this._currentTask = new EffectTask(duration, -1);
        this._currentFuture = ClientScheduler.getInstance().scheduleLow(this._currentTask, duration);
        if (this._state == EffectState.ACTING) {
            this._effected.addEffect(this);
        }
        this.updateEffects(this._effected);
    }

    private synchronized void startEffectTaskAtFixedRate(int delay, int rate) {
        this.stopEffectTask();
        this._currentTask = new EffectTask(delay, rate);
        this._currentFuture = ClientScheduler.getInstance().scheduleLowAtFixedRate(this._currentTask, delay, rate);
        if (this._state == EffectState.ACTING) {
            this._effected.addEffect(this);
        }
        this.updateEffects(this._effected);
    }

    public final void exit() {
        this._state = EffectState.FINISHING;
        this.scheduleEffect();
    }

    private synchronized void stopEffectTask() {
        if (this._currentFuture != null) {
            this._currentFuture.cancel(false);
            this._currentFuture = null;
            this._currentTask = null;
            this._effected.removeEffect(this);
            this._effected.updateStats();
        }
    }

    public abstract EffectType getEffectType();

    public void onStart() {
        if (this._abnormalEffect != 0) {
            this.getEffected().startAbnormalEffect(this._abnormalEffect);
        }
    }

    public void onExit() {
        if (this._abnormalEffect != 0) {
            this.getEffected().stopAbnormalEffect(this._abnormalEffect);
        }
    }

    public abstract boolean onActionTime();

    public final void rescheduleEffect() {
        if (this._state != EffectState.ACTING) {
            this.scheduleEffect();
        } else {
            if (this._count > 1) {
                this.startEffectTaskAtFixedRate(5, this._period * 1000);
                return;
            }
            if (this._period > 0) {
                this.startEffectTask(this._period * 1000);
                return;
            }
        }
    }

    public final void scheduleEffect() {
        if (this._state == EffectState.CREATED) {
            this._state = EffectState.ACTING;
            this.onStart();
            if (this._count > 1) {
                this.startEffectTaskAtFixedRate(5, this._period * 1000);
                return;
            }
            if (this._period > 0) {
                this.startEffectTask(this._period * 1000);
                return;
            }
        }
        if (this._state == EffectState.ACTING) {
            if (this._count-- > 0 && this.onActionTime()) {
                return;
            }
            this._state = EffectState.FINISHING;
        }
        if (this._state == EffectState.FINISHING) {
            this.onExit();
            this.stopEffectTask();
        }
    }

    public void updateEffects(L2Character effectedChar) {
        effectedChar.updateStats();
    }

    public Func[] getStatFuncs() {
        if (this._funcTemplates == null) {
            return _emptyFunctionSet;
        }
        ArrayList<Func> funcs = new ArrayList<Func>();
        for (FuncTemplate t : this._funcTemplates) {
            Env env = new Env();
            env._player = this.getEffector();
            env._target = this.getEffected();
            env._skill = this.getSkill();
            Func f = t.getFunc(env, this);
            if (f == null) continue;
            funcs.add(f);
        }
        if (funcs.size() == 0) {
            return _emptyFunctionSet;
        }
        return funcs.toArray(new Func[funcs.size()]);
    }

    public final void addIcon(MagicEffectIcons mi) {
        EffectTask task = this._currentTask;
        ScheduledFuture future = this._currentFuture;
        if (task == null || future == null) {
            return;
        }
        if (this._state == EffectState.FINISHING || this._state == EffectState.CREATED) {
            return;
        }
        L2Skill sk = this.getSkill();
        if (task.rate > 0) {
            mi.addEffect(sk.getId(), this.getLevel(), -1);
        } else {
            mi.addEffect(sk.getId(), this.getLevel(), (int)future.getDelay(TimeUnit.MILLISECONDS));
        }
    }

    protected int getLevel() {
        return this.getSkill().getLevel();
    }

    public final class EffectTask
    implements Runnable {
        protected final int delay;
        protected final int rate;

        EffectTask(int delay, int rate) {
            this.delay = delay;
            this.rate = rate;
        }

        public void run() {
            try {
                L2Effect.this.scheduleEffect();
            }
            catch (Throwable e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EffectType {
        BUFF,
        CHARGE,
        DMG_OVER_TIME,
        HEAL_OVER_TIME,
        MANA_DMG_OVER_TIME,
        MANA_HEAL_OVER_TIME,
        RELAXING,
        STUN,
        ROOT,
        SLEEP,
        HATE,
        FAKE_DEATH,
        CONFUSION,
        CONFUSE_MOB_ONLY,
        MUTE,
        FEAR,
        SILENT_MOVE,
        SEED,
        PARALYZE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EffectState {
        CREATED,
        ACTING,
        FINISHING;

    }
}

