/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2CharacterAI;
import net.sf.l2j.gameserver.ai.L2DoorAI;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.DoorStatusUpdate;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.ValidateLocation;
import net.sf.l2j.gameserver.templates.L2CharTemplate;
import net.sf.l2j.gameserver.templates.L2Weapon;
import net.sf.l2j.util.L2ObjectSet;

public class L2DoorInstance
extends L2Character {
    protected static Logger _log = Logger.getLogger(L2DoorInstance.class.getName());
    private final int _doorId;
    private final String _name;
    private int _open;
    private boolean _unlockable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2CharacterAI getAI() {
        if (this._ai == null) {
            L2DoorInstance l2DoorInstance = this;
            synchronized (l2DoorInstance) {
                if (this._ai == null) {
                    this._ai = new L2DoorAI(new AIAccessor());
                }
            }
        }
        return this._ai;
    }

    public boolean hasAI() {
        return this._ai != null;
    }

    public L2DoorInstance(int objectId, L2CharTemplate template, int doorId, String name, boolean unlockable) {
        super(objectId, template);
        this._doorId = doorId;
        this._name = name;
    }

    public final boolean isUnlockable() {
        return this._unlockable;
    }

    public final int getLevel() {
        return 1;
    }

    public int getDoorId() {
        return this._doorId;
    }

    public int getOpen() {
        return this._open;
    }

    public void setOpen(int open) {
        this._open = open;
    }

    public int getDamage() {
        int dmg = 6 - (int)Math.ceil(this.getCurrentHp() / (double)this.getMaxHp() * 6.0);
        if (dmg > 6) {
            return 6;
        }
        if (dmg < 0) {
            return 0;
        }
        return dmg;
    }

    public boolean isEnemyOf(L2Character cha) {
        return true;
    }

    public boolean isAutoAttackable(L2Character attacker) {
        if (this.isUnlockable()) {
            return true;
        }
        if (attacker instanceof L2PcInstance) {
            return !L2Siege.isDefender(((L2PcInstance)attacker).getClanId()) && L2Siege.getSiege() > 0;
        }
        return false;
    }

    public void updateAbnormalEffect() {
    }

    protected int getDistanceToWatchObject(L2Object object) {
        if (!(object instanceof L2PcInstance)) {
            return 0;
        }
        return 2000;
    }

    protected int getDistanceToForgetObject(L2Object object) {
        if (!(object instanceof L2PcInstance)) {
            return 0;
        }
        return 4000;
    }

    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    public void onAction(L2PcInstance player) {
        if (this != player.getTarget()) {
            if (Config.DEBUG) {
                _log.fine("new target selected:" + this.getObjectId());
            }
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel());
            player.sendPacket(my);
            if (this.isAutoAttackable(player)) {
                DoorStatusUpdate su = new DoorStatusUpdate(this);
                player.sendPacket(su);
            }
            player.sendPacket(new ValidateLocation(this));
        } else {
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel());
            player.sendPacket(my);
            if (this.isAutoAttackable(player)) {
                if (Math.abs(player.getZ() - this.getZ()) < 400) {
                    player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
                } else {
                    player.sendPacket(new ActionFailed());
                }
            }
            if (!this.isAutoAttackable(player)) {
                player.sendPacket(new ActionFailed());
            }
        }
    }

    public void onActionShift(ClientThread client) {
        L2PcInstance player = client.getActiveChar();
        if (player.getAccessLevel() >= 100) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel());
            player.sendPacket(my);
            if (this.isAutoAttackable(player)) {
                DoorStatusUpdate su = new DoorStatusUpdate(this);
                player.sendPacket(su);
            }
            NpcHtmlMessage html = new NpcHtmlMessage(1);
            StringBuffer html1 = new StringBuffer("<html><body><table border=0>");
            html1.append("<tr><td>S.Y.L. Says:</td></tr>");
            html1.append("<tr><td>Current HP  " + this.getCurrentHp() + "</td></tr>");
            html1.append("<tr><td>Max HP      " + this.getMaxHp() + "</td></tr>");
            html1.append("<tr><td>Object ID: " + this.getObjectId() + "</td></tr>");
            html1.append("<tr><td><br></td></tr>");
            html1.append("<tr><td><br></td></tr>");
            html1.append("<tr><td>Class: " + this.getClass().getName() + "</td></tr>");
            html1.append("<tr><td><br></td></tr>");
            html1.append("<tr><td><button value=\"Kill\" action=\"bypass -h admin_kill\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            html1.append("<tr><td><button value=\"Delete\" action=\"bypass -h admin_delete\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            html1.append("</table></body></html>");
            html.setHtml(html1.toString());
            player.sendPacket(html);
        }
        player.sendPacket(new ActionFailed());
    }

    public void broadcastStatusUpdate() {
        L2ObjectSet<L2PcInstance> knownPlayers = this.getKnownPlayers();
        if (knownPlayers == null || knownPlayers.isEmpty()) {
            return;
        }
        DoorStatusUpdate su = new DoorStatusUpdate(this);
        for (L2PcInstance player : knownPlayers) {
            player.sendPacket(su);
        }
    }

    public void onOpen() {
        ClientScheduler.getInstance().scheduleLow(new CloseTask(), 60000L);
    }

    public void onClose() {
        this.closeMe();
    }

    public final void closeMe() {
        this.setOpen(1);
        this.broadcastStatusUpdate();
    }

    public final void openMe() {
        this.setOpen(0);
        this.broadcastStatusUpdate();
    }

    class CloseTask
    implements Runnable {
        CloseTask() {
        }

        public void run() {
            try {
                L2DoorInstance.this.onClose();
            }
            catch (Throwable e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        protected AIAccessor() {
        }

        public L2DoorInstance getActor() {
            return L2DoorInstance.this;
        }

        public void moveTo(int x, int y, int z, int offset) {
        }

        public void moveTo(int x, int y, int z) {
        }

        public void stopMove(L2CharPosition pos) {
        }

        public void doAttack(L2Character target) {
        }

        public void doCast(L2Skill skill) {
        }
    }
}

