/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.SkillTable;
import net.sf.l2j.gameserver.TaskPriority;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.MagicSkillUser;

public class L2CubicInstance {
    protected static Logger _log = Logger.getLogger(L2CubicInstance.class.getName());
    public static final int STORM_CUBIC = 1;
    public static final int VAMPIRIC_CUBIC = 2;
    public static final int LIFE_CUBIC = 3;
    public static final int VIPER_CUBIC = 4;
    public static final int POLTERGEIST_CUBIC = 5;
    public static final int BINDING_CUBIC = 6;
    public static final int AQUA_CUBIC = 7;
    public static final int SPARK_CUBIC = 8;
    protected L2PcInstance _owner;
    protected L2Character _target;
    protected int _id;
    protected int _level = 1;
    protected ArrayList<Integer> _skills = new ArrayList();
    private Future _disappearTask;
    private Future _actionTask;

    public L2CubicInstance(L2PcInstance owner, int id, int level) {
        this._owner = owner;
        this._id = id;
        this._level = level;
        this._disappearTask = ClientScheduler.getInstance().scheduleLow(new Disappear(), 900000L);
        switch (this._id) {
            case 1: {
                this._skills.add(4049);
                break;
            }
            case 2: {
                this._skills.add(4050);
                break;
            }
            case 3: {
                this._skills.add(4051);
                this.doAction(this._owner);
                break;
            }
            case 4: {
                this._skills.add(4052);
                break;
            }
            case 5: {
                this._skills.add(4053);
                this._skills.add(4054);
                this._skills.add(4055);
                break;
            }
            case 6: {
                this._skills.add(4164);
                break;
            }
            case 7: {
                this._skills.add(4165);
                break;
            }
            case 8: {
                this._skills.add(4166);
            }
        }
    }

    public void doAction(L2Character target) {
        if (this._target == target) {
            return;
        }
        this.stopAction();
        this._target = target;
        switch (this._id) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this._actionTask = ClientScheduler.getInstance().scheduleAtFixedRate(new Action(), TaskPriority.PR_LOW, 0L, 20000L);
                break;
            }
            case 3: {
                this._actionTask = ClientScheduler.getInstance().scheduleAtFixedRate(new Heal(), TaskPriority.PR_LOW, 0L, 20000L);
            }
        }
    }

    public int getId() {
        return this._id;
    }

    public void setLevel(int level) {
        this._level = level;
    }

    protected void stopAction() {
        this._target = null;
        if (this._actionTask != null) {
            this._actionTask.cancel(true);
            this._actionTask = null;
        }
    }

    protected void cancelDisappear() {
        if (this._disappearTask != null) {
            this._disappearTask.cancel(true);
            this._disappearTask = null;
        }
    }

    private class Disappear
    implements Runnable {
        Disappear() {
        }

        public void run() {
            L2CubicInstance.this.stopAction();
            L2CubicInstance.this._owner.delCubic(L2CubicInstance.this._id);
            L2CubicInstance.this._owner.broadcastUserInfo();
        }
    }

    private class Heal
    implements Runnable {
        Heal() {
        }

        public void run() {
            if (L2CubicInstance.this._owner.isDead()) {
                L2CubicInstance.this.stopAction();
                L2CubicInstance.this._owner.delCubic(L2CubicInstance.this._id);
                L2CubicInstance.this._owner.broadcastUserInfo();
                L2CubicInstance.this.cancelDisappear();
                return;
            }
            if (L2CubicInstance.this._owner.getCurrentHp() < (double)L2CubicInstance.this._owner.getMaxHp()) {
                try {
                    Random rnd = new Random();
                    int x = rnd.nextInt(2);
                    if (x == 0) {
                        int y = rnd.nextInt(L2CubicInstance.this._skills.size());
                        L2Skill skill = SkillTable.getInstance().getInfo(L2CubicInstance.this._skills.get(y), L2CubicInstance.this._level);
                        if (skill != null) {
                            L2Object[] targets = new L2Character[]{L2CubicInstance.this._owner};
                            skill.useSkill(L2CubicInstance.this._owner, targets);
                            MagicSkillUser msu = new MagicSkillUser(L2CubicInstance.this._owner, L2CubicInstance.this._owner, skill.getId(), L2CubicInstance.this._level, 0, 0);
                            L2CubicInstance.this._owner.broadcastPacket(msu);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class Action
    implements Runnable {
        Action() {
        }

        public void run() {
            if (L2CubicInstance.this._owner.isDead() || L2CubicInstance.this._target.isDead()) {
                L2CubicInstance.this.stopAction();
                if (L2CubicInstance.this._owner.isDead()) {
                    L2CubicInstance.this._owner.delCubic(L2CubicInstance.this._id);
                    L2CubicInstance.this._owner.broadcastUserInfo();
                    L2CubicInstance.this.cancelDisappear();
                }
                return;
            }
            if (L2CubicInstance.this._target != null) {
                try {
                    Random rnd = new Random();
                    int x = rnd.nextInt(2);
                    if (x == 0) {
                        int y = rnd.nextInt(L2CubicInstance.this._skills.size());
                        L2Skill skill = SkillTable.getInstance().getInfo(L2CubicInstance.this._skills.get(y), L2CubicInstance.this._level);
                        if (skill != null) {
                            L2Object[] targets = new L2Character[]{L2CubicInstance.this._target};
                            skill.useSkill(L2CubicInstance.this._owner, targets);
                            MagicSkillUser msu = new MagicSkillUser(L2CubicInstance.this._owner, L2CubicInstance.this._target, skill.getId(), L2CubicInstance.this._level, 0, 0);
                            L2CubicInstance.this._owner.broadcastPacket(msu);
                        }
                    }
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, "", e);
                }
            }
        }
    }
}

