/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.ClassId;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.quest.Quest;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.ValidateLocation;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public final class L2ClassMasterInstance
extends L2FolkInstance {
    private static Logger _log = Logger.getLogger(L2ClassMasterInstance.class.getName());

    public L2ClassMasterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    public void onAction(L2PcInstance player) {
        if (this.getObjectId() != player.getTargetId()) {
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
            if (Config.DEBUG) {
                _log.fine("ClassMaster selected:" + this.getObjectId());
            }
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            player.sendPacket(new ValidateLocation(this));
        } else {
            double distance = this.getDistance(player.getX(), player.getY());
            if (distance > 150.0) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
                return;
            }
            if (Config.DEBUG) {
                _log.fine("ClassMaster activated");
            }
            ClassId classId = player.getClassId();
            int jobLevel = 0;
            int level = player.getLevel();
            switch (classId) {
                case fighter: 
                case mage: 
                case elvenFighter: 
                case elvenMage: 
                case darkFighter: 
                case darkMage: 
                case orcFighter: 
                case orcMage: 
                case dwarvenFighter: {
                    jobLevel = 1;
                    break;
                }
                case elvenScout: 
                case elvenKnight: 
                case elvenWizard: 
                case oracle: 
                case knight: 
                case warrior: 
                case rogue: 
                case wizard: 
                case cleric: 
                case palusKnight: 
                case assassin: 
                case darkWizard: 
                case shillienOracle: 
                case orcRaider: 
                case orcMonk: 
                case orcShaman: 
                case scavenger: 
                case artisan: {
                    jobLevel = 2;
                    break;
                }
                default: {
                    jobLevel = 3;
                }
            }
            if (!Config.ALLOW_CLASS_MASTERS) {
                jobLevel = 3;
            }
            if ((level >= 20 && jobLevel == 1 || level >= 40 && jobLevel == 2) && Config.ALLOW_CLASS_MASTERS) {
                this.showChatWindow(player, classId.getId());
            } else {
                NpcHtmlMessage html = new NpcHtmlMessage(1);
                StringBuffer sb = new StringBuffer();
                sb.append("<html><head><body>");
                switch (jobLevel) {
                    case 1: {
                        sb.append("Come back here when you reached level 20 to change your class.<br>");
                        break;
                    }
                    case 2: {
                        sb.append("Come back here when you reached level 40 to change your class.<br>");
                        break;
                    }
                    case 3: {
                        sb.append("There is no class changes for you any more.<br>");
                    }
                }
                for (Quest q : Quest.findAllEvents()) {
                    sb.append("Event: <a action=\"bypass -h Quest " + q.getName() + "\">" + q.getDescr() + "</a><br>");
                }
                sb.append("</body></html>");
                html.setHtml(sb.toString());
                player.sendPacket(html);
            }
            player.sendPacket(new ActionFailed());
        }
    }

    public String getHtmlPath(int npcId, int val) {
        return "data/html/classmaster/" + val + ".htm";
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("change_class")) {
            int val = Integer.parseInt(command.substring(13));
            this.changeClass(player, val);
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    private void changeClass(L2PcInstance player, int val) {
        if (Config.DEBUG) {
            _log.fine("Changing class to ClassId:" + val);
        }
        player.setClassId(val);
        if (Config.DEBUG) {
            _log.fine("name:" + player.getName());
        }
        if (Config.DEBUG) {
            _log.fine("level:" + player.getLevel());
        }
        if (Config.DEBUG) {
            _log.fine("classId:" + (Object)((Object)player.getClassId()));
        }
        player.broadcastUserInfo();
    }
}

