/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.Future;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ClanTable;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.SkillTable;
import net.sf.l2j.gameserver.ai.L2CastleGuardAI;
import net.sf.l2j.gameserver.ai.L2CharacterAI;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.CreatureSay;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.NpcInfo;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;
import net.sf.l2j.gameserver.templates.L2Weapon;
import net.sf.l2j.gameserver.templates.StatsSet;

public final class L2CastleGuardInstance
extends L2Character {
    private int _clanid;
    private String _group = "none";
    protected Future _decayTask;
    protected int templateid;
    public int x;
    public int y;
    public int z;
    protected int hp = 100;
    protected int mp = 100;
    protected int patk = 100;
    protected int pspd = 100;
    protected int pdef = 100;
    protected int matk = 100;
    protected int mspd = 100;
    protected int mdef = 100;
    protected int magery = 100;
    protected boolean pspdcontrol;
    protected boolean pdefcontrol;
    protected boolean matkcontrol;
    protected boolean mspdcontrol;
    protected boolean mdefcontrol;
    protected boolean magerycontrol;
    protected boolean hpcontrol;
    protected boolean mpcontrol;
    protected boolean patkcontrol;
    protected String name;
    public static ArrayList<Integer> _castleGuards;
    public static final int JUST_HIRED = 0;
    public static final int ATTACK = 1;

    public L2CastleGuardInstance(Integer objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.restoreFromDB();
        this.setTemplate(this.setUpTemplate(template));
        _castleGuards = new ArrayList();
        _castleGuards.add(objectId);
        this.x = this.getX();
        this.y = this.getY();
        this.z = this.getZ();
        this.templateid = template.npcId;
    }

    public boolean isAttackable() {
        return true;
    }

    public final L2NpcTemplate getTemplate() {
        return (L2NpcTemplate)this._template;
    }

    public final int getLevel() {
        return this.getTemplate().level;
    }

    protected int getDistanceToForgetObject(L2Object object) {
        return 6000;
    }

    protected int getDistanceToWatchObject(L2Object object) {
        return 4000;
    }

    public boolean isAutoAttackable(L2Character attacker) {
        return true;
    }

    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    public void updateAbnormalEffect() {
        for (L2PcInstance player : this.getKnownPlayers()) {
            player.sendPacket(new NpcInfo(this, (L2Character)player));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2CharacterAI getAI() {
        if (this._ai == null) {
            L2CastleGuardInstance l2CastleGuardInstance = this;
            synchronized (l2CastleGuardInstance) {
                if (this._ai == null) {
                    this._ai = new L2CastleGuardAI(new L2Character.AIAccessor(this));
                }
            }
        }
        return this._ai;
    }

    public void setClanId(L2Clan clan) {
        this._clanid = clan.getClanId();
    }

    public int getClanId() {
        return this._clanid;
    }

    public int getMagery() {
        return this.magery;
    }

    public void setGroup(String group) {
        this._group = group;
    }

    public String getGroup() {
        return this._group;
    }

    public void say(int n) {
        HashMap texts = null;
        L2Clan clan = ClanTable.getInstance().getClan(this.getClanId());
        String[] text = new String[]{"Ready to serve, My Lord", "I'm here to protect the life of sir " + clan.getLeaderName(), "I'll obey the orders of the " + clan.getName() + " clan"};
        texts.put(0, text);
        String[] text2 = new String[]{"Go Go Go", "For the honor of the " + clan.getName()};
        texts.put(1, text2);
        text = (String[])texts.get(n);
        Random rnd = new Random();
        int random = rnd.nextInt(text.length);
        CreatureSay cs = new CreatureSay(this.getObjectId(), 0, this.getName(), text[random]);
        for (L2PcInstance player : this.getKnownPlayers()) {
            if (!(this.getDistance(player.getX(), player.getY()) < 1250.0)) continue;
            player.sendPacket(cs);
        }
    }

    protected synchronized void doDie(L2Character killer) {
        this._decayTask = ClientScheduler.getInstance().scheduleLow(new L2Character.DecayTask(this), 180000L);
        super.doDie(killer);
    }

    public L2NpcTemplate setUpTemplate(L2NpcTemplate template) {
        StatsSet npcDat = new StatsSet();
        int id = template.npcId;
        npcDat.set("npcId", id);
        int level = template.level;
        npcDat.set("level", level);
        npcDat.set("baseShldDef", 0);
        npcDat.set("baseShldRate", 0);
        npcDat.set("baseCritRate", 38);
        npcDat.set("name", template.name);
        npcDat.set("collision_radius", template.collisionRadius);
        npcDat.set("collision_height", template.collisionHeight);
        npcDat.set("sex", template.sex);
        npcDat.set("type", template.type);
        npcDat.set("baseAtkRange", template.baseAtkRange);
        npcDat.set("revardExp", template.revardExp);
        npcDat.set("revardSp", template.revardSp);
        npcDat.set("basePAtkSpd", this.pspd / 1000 * template.basePAtkSpd);
        npcDat.set("baseMAtkSpd", this.mspd / 1000 * template.baseMAtkSpd);
        npcDat.set("aggroRange", template.aggroRange);
        npcDat.set("rhand", template.rhand);
        npcDat.set("lhand", template.lhand);
        npcDat.set("armor", template.armor);
        npcDat.set("baseRunSpd", template.baseRunSpd);
        npcDat.set("baseHpReg", 0.01);
        npcDat.set("baseMpReg", 0.01);
        npcDat.set("baseSTR", 30);
        npcDat.set("baseCON", 30);
        npcDat.set("baseDEX", 30);
        npcDat.set("baseINT", 30);
        npcDat.set("baseWIT", 30);
        npcDat.set("baseMEN", 30);
        npcDat.set("baseHpMax", (float)(this.hp / 1000) * template.baseHpMax);
        npcDat.set("baseMpMax", (float)(this.mp / 1000) * template.baseMpMax);
        npcDat.set("basePAtk", this.patk / 1000 * template.basePAtk);
        npcDat.set("basePDef", this.pdef / 1000 * template.basePDef);
        npcDat.set("baseMAtk", this.matk / 1000 * template.baseMAtk);
        npcDat.set("baseMDef", this.mdef / 1000 * template.baseMDef);
        npcDat.set("factionId", template.factionId);
        npcDat.set("factionRange", template.factionRange);
        npcDat.set("isUndead", template.isUndead);
        L2NpcTemplate newtemplate = new L2NpcTemplate(npcDat);
        return newtemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreFromDB() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT object_id, x, y, z, clan_id, hp, mp, patk, pspd, pdef, matk, mspd, mdef, magery, name, hpcontrol, mpcontrol, patkcontrol, pspdcontrol, pdefcontrol, matkcontrol, mspdcontrol, mdefcontrol, magerycontrol, template_id, group FROM castle_guards WHERE object_id=?");
            statement.setInt(1, this.getObjectId());
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                this.x = rset.getInt("x");
                this.y = rset.getInt("y");
                this.z = rset.getInt("z");
                this._clanid = rset.getInt("clan_id");
                this._group = rset.getString("group");
                this.hp = rset.getInt("hp");
                this.mp = rset.getInt("mp");
                this.patk = rset.getInt("patk");
                this.pspd = rset.getInt("pspd");
                this.pdef = rset.getInt("pdef");
                this.matk = rset.getInt("matk");
                this.mspd = rset.getInt("mspd");
                this.mdef = rset.getInt("mdef");
                this.magery = rset.getInt("magery");
                this.name = rset.getString("name");
                this.templateid = rset.getInt("template_id");
                statement = con.prepareStatement("SELECT npcid, skillid, level FROM castle_guards_skills WHERE npcid=" + this.getObjectId());
                rset = statement.executeQuery();
                while (rset.next()) {
                    L2Skill skill = SkillTable.getInstance().getInfo(rset.getInt("skillid"), rset.getInt("level"));
                    super.addSkill(skill);
                }
            }
        }
        catch (Exception e) {
            _log.warning("could not restore castle guard data:" + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT object_id from castle_guards WHERE object_id=?");
            statement.setInt(1, this.getObjectId());
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                statement = con.prepareStatement("UPDATE castle_guards SET object_id=?, x=?, y=?, z=?, clan_id=?, hp=?, mp=?, patk=?, pspd=?, pdef=?, matk=?, mspd=?, mdef=?, magery=?, name=?, hpcontrol=?, mpcontrol=?, patkcontrol=?, pspdcontrol=?, pdefcontrol=?, matkcontrol=?, mspdcontrol=?, mdefcontrol=?, magerycontrol=? WHERE object_id=?");
                statement.setInt(25, this.getObjectId());
            } else {
                statement = con.prepareStatement("INSERT INTO castle_guards (object_id,x,y,z,clan_id,hp,mp,patk,pspd,pdef,matk,mspd,mdef,magery,name,hpcontrol,mpcontrol,patkcontrol,pspdcontrol,pdefcontrol,matkcontrol,mspdcontrol,mdefcontrol,magerycontrol,template_id,group) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                statement.setInt(25, this.templateid);
                statement.setString(26, this._group);
            }
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, this.getX());
            statement.setInt(3, this.getY());
            statement.setInt(4, this.getZ());
            statement.setInt(5, this.getClanId());
            statement.setInt(6, this.hp);
            statement.setInt(7, this.mp);
            statement.setInt(8, this.patk);
            statement.setInt(9, this.pspd);
            statement.setInt(10, this.pdef);
            statement.setInt(11, this.matk);
            statement.setInt(12, this.mspd);
            statement.setInt(13, this.mdef);
            statement.setInt(14, this.magery);
            statement.setString(15, this.name);
            statement.setBoolean(16, this.hpcontrol);
            statement.setBoolean(17, this.mpcontrol);
            statement.setBoolean(18, this.patkcontrol);
            statement.setBoolean(19, this.pspdcontrol);
            statement.setBoolean(20, this.pdefcontrol);
            statement.setBoolean(21, this.matkcontrol);
            statement.setBoolean(22, this.mspdcontrol);
            statement.setBoolean(23, this.mdefcontrol);
            statement.setBoolean(24, this.magerycontrol);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("could not store castle guard data:" + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public void onActionShift(ClientThread client) {
        L2PcInstance player = client.getActiveChar();
        if (player.getAccessLevel() >= Config.GM_ACCESSLEVEL || player.getClanId() == this.getClanId() && (player.getClanPrivileges() >= Config.CG_VIEWSTATS || player.isClanLeader())) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            if (this.isAutoAttackable(player)) {
                StatusUpdate su = new StatusUpdate(this.getObjectId());
                su.addAttribute(StatusUpdate.CUR_HP, (int)this.getCurrentHp());
                su.addAttribute(StatusUpdate.MAX_HP, this.getMaxHp());
                player.sendPacket(su);
            }
            NpcHtmlMessage html = new NpcHtmlMessage(1);
            StringBuffer html1 = new StringBuffer("<html><body bgcolor=#000000>");
            html1.append("<center><h1>" + this.getName() + "</h1></center>");
            html1.append("<table border=0 width=\"100%\">");
            html1.append("<tr><td>Anatomy</td><td>" + this.hp / 10 + "." + this.hp % 1000 + "</td>");
            if (this.hpcontrol) {
                html1.append("<td><button value=\"down\" action=\"bypass -h forth_tooglehp\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            } else {
                html1.append("<td><button value=\"up\" action=\"bypass -h forth_tooglehp\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            }
            html1.append("<tr><td>Wisdom</td><td>" + this.mp / 10 + "." + this.mp % 1000 + "</td>");
            if (this.mpcontrol) {
                html1.append("<td><button value=\"down\" action=\"bypass -h forth_tooglemp\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            } else {
                html1.append("<td><button value=\"up\" action=\"bypass -h forth_tooglemp\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            }
            html1.append("<tr><td>Weapon skill</td><td>" + this.patk / 10 + "." + this.patk % 1000 + "</td>");
            if (this.hpcontrol) {
                html1.append("<td><button value=\"down\" action=\"bypass -h forth_tooglepath\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            } else {
                html1.append("<td><button value=\"up\" action=\"bypass -h forth_tooglepatk\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            }
            html1.append("<tr><td>Armor</td><td>" + this.pdef / 10 + "." + this.pdef % 1000 + "</td>");
            if (this.pdefcontrol) {
                html1.append("<td><button value=\"down\" action=\"bypass -h forth_tooglepdef\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            } else {
                html1.append("<td><button value=\"up\" action=\"bypass -h forth_tooglepdef\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            }
            html1.append("<tr><td>Dextery</td><td>" + this.pspd / 10 + "." + this.pspd % 1000 + "</td>");
            if (this.pspdcontrol) {
                html1.append("<td><button value=\"down\" action=\"bypass -h forth_tooglepspd\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            } else {
                html1.append("<td><button value=\"up\" action=\"bypass -h forth_tooglepspd\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            }
            html1.append("<tr><td>Magic Power</td><td>" + this.matk / 10 + "." + this.matk % 1000 + "</td>");
            if (this.matkcontrol) {
                html1.append("<td><button value=\"down\" action=\"bypass -h forth_tooglematk\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            } else {
                html1.append("<td><button value=\"up\" action=\"bypass -h forth_tooglematk\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            }
            html1.append("<tr><td>Casting Speed</td><td>" + this.mspd / 10 + "." + this.mspd % 1000 + "</td>");
            if (this.mspdcontrol) {
                html1.append("<td><button value=\"down\" action=\"bypass -h forth_tooglemspd\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            } else {
                html1.append("<td><button value=\"up\" action=\"bypass -h forth_tooglemspd\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            }
            html1.append("<tr><td>Resisting Spells</td><td>" + this.mdef / 10 + "." + this.mdef % 1000 + "</td>");
            if (this.mdefcontrol) {
                html1.append("<td><button value=\"down\" action=\"bypass -h forth_tooglemdef\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            } else {
                html1.append("<td><button value=\"up\" action=\"bypass -h forth_tooglemdef\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            }
            html1.append("<tr><td>Magery</td><td>" + this.magery / 10 + "." + this.magery % 1000 + "</td>");
            if (this.magerycontrol) {
                html1.append("<td><button value=\"down\" action=\"bypass -h forth_tooglemagery\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            } else {
                html1.append("<td><button value=\"up\" action=\"bypass -h forth_tooglemagery\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
            }
            html1.append("</table>");
            html.setHtml(html1.toString());
            player.sendPacket(html);
        }
    }

    public void statsUp(int damage, int level) {
        Random rnd = new Random();
        int n = rnd.nextInt(28000 / (damage * level * Config.CG_STATUPPROB));
        if (n == 0) {
            this.doStatsUp();
        }
    }

    public void doStatsUp() {
        int i = 0;
        int j = -1;
        if (this.hpcontrol) {
            ++i;
        }
        if (this.mpcontrol) {
            ++i;
        }
        if (this.patkcontrol) {
            ++i;
        }
        if (this.pspdcontrol) {
            ++i;
        }
        if (this.pdefcontrol) {
            ++i;
        }
        if (this.matkcontrol) {
            ++i;
        }
        if (this.mspdcontrol) {
            ++i;
        }
        if (this.mdefcontrol) {
            ++i;
        }
        if (this.magerycontrol) {
            ++i;
        }
        Random rnd = new Random();
        if (i >= 0) {
            j = rnd.nextInt(i - 1);
        }
        if (this.hpcontrol) {
            if (j == 0) {
                this.hp += Config.CG_STATUPGAIN;
            }
            --i;
        }
        if (this.mpcontrol) {
            if (j == 0) {
                this.mp += Config.CG_STATUPGAIN;
            }
            --i;
        }
        if (this.patkcontrol) {
            if (j == 0) {
                this.patk += Config.CG_STATUPGAIN;
            }
            --i;
        }
        if (this.pspdcontrol) {
            if (j == 0) {
                this.pspd += Config.CG_STATUPGAIN;
            }
            --i;
        }
        if (this.pdefcontrol) {
            if (j == 0) {
                this.pdef += Config.CG_STATUPGAIN;
            }
            --i;
        }
        if (this.matkcontrol) {
            if (j == 0) {
                this.matk += Config.CG_STATUPGAIN;
            }
            --i;
        }
        if (this.mspdcontrol) {
            if (j == 0) {
                this.mspd += Config.CG_STATUPGAIN;
            }
            --i;
        }
        if (this.mdefcontrol) {
            if (j == 0) {
                this.mdef += Config.CG_STATUPGAIN;
            }
            --i;
        }
        if (this.magerycontrol) {
            if (j == 0) {
                this.magery += Config.CG_STATUPGAIN;
            }
            --i;
        }
    }

    public L2Skill addSkill(L2Skill newSkill) {
        L2Skill oldSkill = super.addSkill(newSkill);
        this.storeSkill(newSkill, oldSkill);
        return oldSkill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSkill(L2Skill newSkill, L2Skill oldSkill) {
        Connection con = null;
        try {
            PreparedStatement statement;
            con = L2DatabaseFactory.getInstance().getConnection();
            if (oldSkill != null) {
                statement = con.prepareStatement("UPDATE castle_guards_skills SET npcid=?, skillid=?, level=? WHERE npcid=?");
                statement.setInt(4, this.getObjectId());
            } else {
                statement = con.prepareStatement("INSERT INTO castle_guards_skills (npcid, skillid, level) VALUES (?,?,?)");
            }
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, newSkill.getId());
            statement.setInt(3, newSkill.getLevel());
            statement.execute();
        }
        catch (Exception e) {
            _log.warning("could not store castle guard skill:" + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public void maybeLearnSkill(L2PcInstance player, L2Skill skill) {
        Random rnd;
        int n;
        if (player.getClanId() == this.getClanId() && (n = (rnd = new Random()).nextInt(1000 / this.magery - 1)) == 0) {
            this.addSkill(skill);
        }
    }
}

