/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.logging.Logger;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L2BoxInstance
extends L2NpcInstance {
    private static Logger _log = Logger.getLogger(L2BoxInstance.class.getName());
    private static final int MAX_ITEMS_PER_PAGE = 25;
    private static final String INSERT_GRANT = "INSERT INTO boxaccess (charname,spawn) VALUES(?,?)";
    private static final String DELETE_GRANT = "DELETE FROM boxaccess WHERE charname=? AND spawn=?";
    private static final String LIST_GRANT = "SELECT charname FROM boxaccess WHERE spawn=?";
    private static final String VARIABLE_PREFIX = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public L2BoxInstance(int objectId, L2NpcTemplate _template) {
        super(objectId, _template);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        String playerName = player.getName();
        boolean access = this.hasAccess(playerName);
        if (command.startsWith("Withdraw")) {
            if (access) {
                this.showWithdrawWindow(player, command.substring(9));
            }
        } else if (command.startsWith("Deposit")) {
            if (access) {
                this.showDepositWindow(player, command.substring(8));
            }
        } else if (command.startsWith("InBox")) {
            if (access) {
                this.putInBox(player, command.substring(6));
            }
        } else if (command.startsWith("OutBox")) {
            if (access) {
                this.takeOutBox(player, command.substring(7));
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        String pom = "";
        pom = val == 0 ? "" + npcId : npcId + "-" + val;
        return "data/html/custom/" + pom + ".htm";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAccess(String player) {
        Connection con = null;
        boolean result = false;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement st = con.prepareStatement("SELECT spawn, charname FROM boxaccess WHERE charname=? AND spawn=?");
            st.setString(1, player);
            st.setInt(2, this.getSpawn().getId());
            ResultSet rs = st.executeQuery();
            if (rs.next()) {
                result = true;
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            _log.info("hasAccess failed: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAccess() {
        Connection con = null;
        ArrayList<String> acl = new ArrayList<String>();
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement st = con.prepareStatement(LIST_GRANT);
            st.setInt(1, this.getSpawn().getId());
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                acl.add(rs.getString("charname"));
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            _log.info("getAccess failed: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        return acl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean grantAccess(String player, boolean what) {
        Connection con = null;
        boolean result = false;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            String _query = what ? INSERT_GRANT : DELETE_GRANT;
            PreparedStatement st = con.prepareStatement(_query);
            st.setString(1, player);
            st.setInt(2, this.getSpawn().getId());
            st.execute();
            st.close();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return result;
    }

    private void showWithdrawWindow(L2PcInstance player, String command) {
        String drawername = "trash";
        if (command == null) {
            return;
        }
        String[] cmd = command.split(" ");
        int startPos = 0;
        if (cmd != null) {
            drawername = cmd[0];
        }
        if (cmd.length > 1) {
            startPos = Integer.parseInt(cmd[1]);
        }
        NpcHtmlMessage html = new NpcHtmlMessage(1);
        int nitems = 0;
        TreeSet<L2BoxItem> _items = this.getItems(drawername);
        if (startPos >= _items.size()) {
            startPos = 0;
        }
        String button = "<button value=\"Withdraw\" width=80 height=15 action=\"bypass -h npc_" + this.getObjectId() + "_OutBox " + drawername;
        String next = "<button value=\"next\" width=50 height=15 action=\"bypass -h npc_" + this.getObjectId() + "_Withdraw " + drawername + " " + (startPos + 25) + "\">";
        String back = "<button value=\"back\" width=50 height=15 action=\"bypass -h npc_" + this.getObjectId() + "_Chat 0\">";
        String content = "<html><body>Drawer " + drawername + ":<br>" + next + " " + back + "<table width=\"100%\">";
        content = content + "<tr><td>Item</td><td>Count</td><td>Withdraw</td></tr>";
        for (L2BoxItem i : _items) {
            if (++nitems < startPos) continue;
            String varname = VARIABLE_PREFIX.charAt(nitems - startPos) + String.valueOf(i.itemid);
            content = content + "<tr><td>" + i.name + "</td><td align=\"right\">" + i.count + "</td>";
            content = content + "<td><edit var=\"" + varname + "\" width=30></td></tr>";
            button = button + " ," + varname + " $" + varname;
            if (nitems - startPos < 25) continue;
            break;
        }
        button = button + "\">";
        content = content + "</table><br>" + button + "</body></html>";
        _log.fine("setHtml(" + content + "); items=" + nitems);
        html.setHtml(content);
        player.sendPacket(html);
        player.sendPacket(new ActionFailed());
    }

    private void showDepositWindow(L2PcInstance player, String command) {
        String drawername = "trash";
        if (command == null) {
            return;
        }
        String[] cmd = command.split(" ");
        int startPos = 0;
        if (cmd != null) {
            drawername = cmd[0];
        }
        if (cmd.length > 1) {
            startPos = Integer.parseInt(cmd[1]);
        }
        NpcHtmlMessage html = new NpcHtmlMessage(1);
        int nitems = 0;
        TreeSet<L2BoxItem> _items = new TreeSet<L2BoxItem>();
        for (L2ItemInstance i : player.getInventory().getItems()) {
            if (i.getItemId() == 57 || i.isEquipped()) continue;
            L2BoxItem bi = new L2BoxItem(i.getItemId(), i.getCount(), i.getItem().getName(), i.getObjectId(), i.getEnchantLevel());
            _items.add(bi);
        }
        if (startPos >= _items.size()) {
            startPos = 0;
        }
        String button = "<button value=\"Deposit\" width=80 height=15 action=\"bypass -h npc_" + this.getObjectId() + "_InBox " + drawername;
        String next = "<button value=\"next\" width=50 height=15 action=\"bypass -h npc_" + this.getObjectId() + "_Deposit " + drawername + " " + (startPos + 25) + "\">";
        String back = "<button value=\"back\" width=50 height=15 action=\"bypass -h npc_" + this.getObjectId() + "_Chat 0\">";
        String content = "<html><body>Drawer " + drawername + ":<br>" + next + " " + back + "<table width=\"100%\">";
        content = content + "<tr><td>Item</td><td>Count</td><td>Deposit</td></tr>";
        for (L2BoxItem i : _items) {
            if (++nitems < startPos) continue;
            String varname = VARIABLE_PREFIX.charAt(nitems - startPos) + String.valueOf(i.itemid);
            content = content + "<tr><td>" + i.name + "</td><td align=\"right\">" + i.count + "</td>";
            content = content + "<td><edit var=\"" + varname + "\" width=30></td></tr>";
            button = button + " ," + varname + " $" + varname;
            if (nitems - startPos < 25) continue;
            break;
        }
        button = button + "\">";
        content = content + "</table><br>" + button + "</body></html>";
        _log.fine("setHtml(" + content + "); items=" + nitems);
        html.setHtml(content);
        player.sendPacket(html);
        player.sendPacket(new ActionFailed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeSet<L2BoxItem> getItems(String drawer) {
        TreeSet<L2BoxItem> it = new TreeSet<L2BoxItem>();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, spawn, npcid, drawer, itemid, name, count, enchant FROM boxes where spawn=? and npcid=? and drawer=?");
            statement.setInt(1, this.getSpawn().getId());
            statement.setInt(2, this.getNpcId());
            statement.setString(3, drawer);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                _log.fine("found: itemid=" + rs.getInt("itemid") + ", count=" + rs.getInt("count"));
                it.add(new L2BoxItem(rs.getInt("itemid"), rs.getInt("count"), rs.getString("name"), rs.getInt("id"), rs.getInt("enchant")));
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.info("getItems failed: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return it;
    }

    private void putInBox(L2PcInstance player, String command) {
        String[] cmd = command.split(",");
        if (cmd.length <= 1) {
            return;
        }
        String drawername = cmd[0];
        for (int i = 1; i < cmd.length; ++i) {
            String[] part = cmd[i].split(" ");
            if (part == null || part.length < 2) continue;
            try {
                int id = Integer.parseInt(part[0].substring(1));
                int count = Integer.parseInt(part[1]);
                if (count <= 0) continue;
                int realCount = player.getInventory().findItemByItemId(id).getCount();
                if (count < realCount) {
                    realCount = count;
                }
                L2ItemInstance item = player.getInventory().destroyItemByItemId(id, realCount);
                L2ItemInstance newItem = ItemTable.getInstance().createItem(id);
                newItem.setCount(realCount);
                newItem.setEnchantLevel(item.getEnchantLevel());
                this.putItemInBox(player, drawername, newItem);
                continue;
            }
            catch (Exception e) {
                _log.fine("putInBox " + command + " failed: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putItemInBox(L2PcInstance player, String drawer, L2ItemInstance item) {
        String charname = player.getName();
        Connection con = null;
        int foundId = 0;
        int foundCount = 0;
        try {
            PreparedStatement statement;
            con = L2DatabaseFactory.getInstance().getConnection();
            if (item.isStackable()) {
                PreparedStatement st2 = con.prepareStatement("SELECT id,count FROM boxes where spawn=? and npcid=? and drawer=? and itemid=?");
                st2.setInt(1, this.getSpawn().getId());
                st2.setInt(2, this.getNpcId());
                st2.setString(3, drawer);
                st2.setInt(4, item.getItemId());
                ResultSet rs = st2.executeQuery();
                if (rs.next()) {
                    foundId = rs.getInt("id");
                    foundCount = rs.getInt("count");
                }
                rs.close();
                st2.close();
            }
            if (foundCount == 0) {
                statement = con.prepareStatement("INSERT INTO boxes (spawn,npcid,drawer,itemid,name,count,enchant) VALUES(?,?,?,?,?,?,?)");
                statement.setInt(1, this.getSpawn().getId());
                statement.setInt(2, this.getNpcId());
                statement.setString(3, drawer);
                statement.setInt(4, item.getItemId());
                statement.setString(5, item.getItem().getName());
                statement.setInt(6, item.getCount());
                statement.setInt(7, item.getEnchantLevel());
                statement.execute();
                statement.close();
            } else {
                statement = con.prepareStatement("UPDATE boxes SET count=? WHERE id=?");
                statement.setInt(1, foundCount + item.getCount());
                statement.setInt(2, foundId);
                statement.execute();
                statement.close();
            }
        }
        catch (Exception e) {
            _log.info("could not store item to box " + this.getSpawn().getId() + "-" + drawer + " for char " + charname);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    private void takeOutBox(L2PcInstance player, String command) {
        String[] cmd = command.split(",");
        if (cmd.length <= 1) {
            return;
        }
        String drawername = cmd[0];
        L2BoxItem bi = null;
        for (int i = 1; i < cmd.length; ++i) {
            String[] part = cmd[i].split(" ");
            if (part == null || part.length < 2) continue;
            try {
                int id = Integer.parseInt(part[0].substring(1));
                int count = Integer.parseInt(part[1]);
                if (count <= 0) continue;
                L2ItemInstance item = ItemTable.getInstance().createItem(id);
                item.setCount(count);
                bi = this.takeItemOutBox(player, drawername, item);
                if (bi.count <= 0) continue;
                item.setCount(bi.count);
                item.setEnchantLevel(bi.enchant);
                player.getInventory().addItem(item);
                continue;
            }
            catch (Exception e) {
                _log.fine("takeOutBox " + command + " failed: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private L2BoxItem takeItemOutBox(L2PcInstance player, String drawer, L2ItemInstance item) {
        String charname = player.getName();
        Connection con = null;
        L2BoxItem bi = new L2BoxItem();
        bi.count = 0;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id,count,enchant FROM boxes WHERE spawn=? AND npcid=? AND drawer=? AND itemid=? AND count>=?");
            statement.setInt(1, this.getSpawn().getId());
            statement.setInt(2, this.getNpcId());
            statement.setString(3, drawer);
            statement.setInt(4, item.getItemId());
            statement.setInt(5, item.getCount());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                if (rs.getInt("count") == item.getCount()) {
                    bi.count = item.getCount();
                    bi.itemid = item.getItemId();
                    bi.enchant = rs.getInt("enchant");
                    PreparedStatement st2 = con.prepareStatement("DELETE FROM boxes WHERE id=?");
                    st2.setInt(1, rs.getInt("id"));
                    st2.execute();
                    st2.close();
                    break;
                }
                if (rs.getInt("count") <= item.getCount()) continue;
                bi.count = item.getCount();
                bi.itemid = item.getItemId();
                bi.enchant = rs.getInt("enchant");
                PreparedStatement st2 = con.prepareStatement("UPDATE boxes SET count=? WHERE id=?");
                st2.setInt(1, rs.getInt("count") - bi.count);
                st2.setInt(2, rs.getInt("id"));
                st2.execute();
                st2.close();
                break;
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.info("could not delete/update item, box " + this.getSpawn().getId() + "-" + drawer + " for char " + charname + ": " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return bi;
    }

    private class L2BoxItem
    implements Comparable {
        public int itemid;
        public int id;
        public int count;
        public int enchant;
        public String name;

        public L2BoxItem() {
        }

        public L2BoxItem(int _itemid, int _count, String _name, int _id, int _enchant) {
            this.itemid = _itemid;
            this.count = _count;
            this.name = _name;
            this.id = _id;
            this.enchant = _enchant;
        }

        public int compareTo(Object o) {
            int r = this.name.compareToIgnoreCase(((L2BoxItem)o).name);
            if (r != 0) {
                return r;
            }
            if (this.id < ((L2BoxItem)o).id) {
                return -1;
            }
            return 1;
        }
    }
}

