/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.EventDroplist;
import net.sf.l2j.gameserver.GameServer;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.ai.CtrlEvent;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2AttackableAI;
import net.sf.l2j.gameserver.ai.L2CharacterAI;
import net.sf.l2j.gameserver.model.L2CastleGuardInstance;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2DoorInstance;
import net.sf.l2j.gameserver.model.L2DropData;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2MonsterInstance;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2Party;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2PlayableInstance;
import net.sf.l2j.gameserver.model.L2SiegeGuardInstance;
import net.sf.l2j.gameserver.model.L2Summon;
import net.sf.l2j.gameserver.model.L2SummonInstance;
import net.sf.l2j.gameserver.model.quest.QuestState;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;
import net.sf.l2j.util.L2ObjectSet;

public class L2Attackable
extends L2NpcInstance {
    static Logger _log = Logger.getLogger(L2Attackable.class.getName());
    private ConcurrentHashMap<L2Character, AggroInfo> _aggroList;
    private boolean _spoiled;
    private L2ItemInstance[] _sweepItems;

    public L2Attackable(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2CharacterAI getAI() {
        if (this._ai == null) {
            L2Attackable l2Attackable = this;
            synchronized (l2Attackable) {
                if (this._ai == null) {
                    this._ai = new L2AttackableAI(new L2Character.AIAccessor(this));
                }
            }
        }
        return this._ai;
    }

    protected int getDistanceToWatchObject(L2Object object) {
        if (object instanceof L2FolkInstance || !(object instanceof L2Character)) {
            return 0;
        }
        if (object instanceof L2PlayableInstance) {
            return 1500;
        }
        if (this.getAggroRange() > this.getFactionRange()) {
            return this.getAggroRange();
        }
        if (this.getFactionRange() > 200) {
            return this.getFactionRange();
        }
        return 200;
    }

    protected int getDistanceToForgetObject(L2Object object) {
        if (this._aggroList != null && this._aggroList.get(object) != null) {
            return 3000;
        }
        return 2 * this.getDistanceToWatchObject(object);
    }

    public boolean getCondition2(L2Character target) {
        if (target instanceof L2FolkInstance || target instanceof L2DoorInstance) {
            return false;
        }
        if (target.isAlikeDead() || this.getDistance(target.getX(), target.getY()) > (double)this.getAggroRange() || Math.abs(this.getZ() - target.getZ()) > 100) {
            return false;
        }
        if (target instanceof L2PcInstance) {
            return !((L2PcInstance)target).isInvul();
        }
        return true;
    }

    public void removeKnownObject(L2Object object) {
        super.removeKnownObject(object);
        if (this._aggroList != null && object instanceof L2Character) {
            this._aggroList.remove(object);
            if (this._aggroList.isEmpty()) {
                this._aggroList = null;
            }
        }
        L2ObjectSet<L2PcInstance> known = this.getKnownPlayers();
        if (this.getAI() != null && (known == null || known.isEmpty())) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        }
    }

    public void reduceCurrentHp(double damage, L2Character attacker) {
        this.reduceCurrentHp(damage, attacker, true);
    }

    public void reduceCurrentHp(double damage, L2Character attacker, boolean awake) {
        if (this instanceof L2SiegeGuardInstance && attacker instanceof L2SiegeGuardInstance) {
            return;
        }
        if (this instanceof L2MonsterInstance && attacker instanceof L2MonsterInstance) {
            return;
        }
        if (this instanceof L2MonsterInstance && attacker instanceof L2CastleGuardInstance) {
            L2CastleGuardInstance guard = (L2CastleGuardInstance)attacker;
            guard.statsUp((int)damage, this.getLevel());
        }
        if (attacker != null) {
            this.addDamage(attacker, (int)damage);
        }
        super.reduceCurrentHp(damage, attacker, awake);
    }

    protected void doDie(L2Character killer) {
        try {
            this.calculateRewards(killer);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
        try {
            L2PcInstance player;
            QuestState[] quests;
            if (killer instanceof L2PcInstance && (quests = (player = (L2PcInstance)killer).getQuestsForKills(this.getTemplate().npcId)) != null) {
                for (QuestState qs : quests) {
                    qs.getQuest().notifyKill(this.getTemplate().npcId, qs);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
        super.doDie(killer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateRewards(L2Character lastAttacker) {
        if (this._aggroList == null) {
            return;
        }
        int npcID = this.getTemplate().npcId;
        ConcurrentHashMap<L2Character, AggroInfo> concurrentHashMap = this._aggroList;
        synchronized (concurrentHashMap) {
            if (!this._aggroList.isEmpty()) {
                for (AggroInfo info : this._aggroList.values()) {
                    L2Summon temp;
                    float penalty = 0.0f;
                    L2Character attacker = info.attacker;
                    int damage = info.damage;
                    L2Party attackerParty = null;
                    if (attacker instanceof L2PcInstance) {
                        L2PcInstance temp2 = (L2PcInstance)attacker;
                        if (temp2.isInParty()) {
                            attackerParty = temp2.getParty();
                        }
                    } else if (attacker instanceof L2SummonInstance && (temp = (L2Summon)attacker).isInParty()) {
                        attackerParty = temp.getParty();
                    }
                    if (npcID <= 0 || damage <= 1) {
                        this._aggroList.remove(attacker);
                        continue;
                    }
                    if (attackerParty == null) {
                        if (attacker instanceof L2SummonInstance) {
                            penalty = ((L2SummonInstance)attacker).getExpPenalty();
                            if (this._aggroList.containsKey(((L2SummonInstance)attacker).getOwner())) {
                                L2PcInstance owner = ((L2SummonInstance)attacker).getOwner();
                                damage += this._aggroList.get((Object)owner).damage;
                                this._aggroList.remove(owner);
                            }
                        }
                        if (attacker instanceof L2PcInstance && ((L2PcInstance)attacker).getPet() instanceof L2SummonInstance && this._aggroList.containsKey(((L2PcInstance)attacker).getPet())) {
                            L2SummonInstance summon = (L2SummonInstance)((L2PcInstance)attacker).getPet();
                            penalty = summon.getExpPenalty();
                            damage += this._aggroList.get((Object)summon).damage;
                            this._aggroList.remove(summon);
                        }
                        if (damage > this.getMaxHp()) {
                            damage = this.getMaxHp();
                        }
                        int diff = attacker.getLevel() - this.getLevel();
                        if (attacker instanceof L2SummonInstance) {
                            diff = ((L2SummonInstance)attacker).getOwner().getLevel() - this.getLevel();
                        }
                        int xp = 0;
                        int sp = 0;
                        if (attacker.knowsObject(this)) {
                            int[] tmp = this.calculateExpAndSp(diff, damage);
                            xp = tmp[0];
                            xp = (int)((float)xp * (1.0f - penalty));
                            sp = tmp[1];
                        }
                        attacker.addExpAndSp(xp, sp);
                        this._aggroList.remove(attacker);
                        continue;
                    }
                    int partyDmg = 0;
                    float partyMul = 1.0f;
                    ArrayList<L2PcInstance> members = attackerParty.getPartyMembers();
                    ArrayList<L2Character> rewardedMembers = new ArrayList<L2Character>();
                    for (L2PcInstance pl : members) {
                        AggroInfo ai = this._aggroList.get(pl);
                        if (ai != null) {
                            partyDmg += ai.damage;
                            this._aggroList.remove(pl);
                        }
                        if (pl.getPet() instanceof L2SummonInstance && this._aggroList.containsKey(pl.getPet())) {
                            partyDmg += this._aggroList.get((Object)pl.getPet()).damage;
                            rewardedMembers.add(pl.getPet());
                            this._aggroList.remove(pl.getPet());
                        }
                        if (pl.isDead()) continue;
                        rewardedMembers.add(pl);
                    }
                    if (partyDmg < this.getMaxHp()) {
                        float partyDmgF = partyDmg;
                        float getMaxHpf = this.getMaxHp();
                        partyMul = partyDmgF / getMaxHpf;
                    }
                    if (partyDmg > this.getMaxHp()) {
                        partyDmg = this.getMaxHp();
                    }
                    int diff = attackerParty.getLevel() - this.getLevel();
                    int[] tmp = this.calculateExpAndSp(diff, partyDmg);
                    int xp = tmp[0];
                    xp = (int)((float)xp * (1.0f - penalty));
                    int sp = tmp[1];
                    xp = (int)((float)xp * partyMul);
                    sp = (int)((float)sp * partyMul);
                    if (partyDmg <= 0) continue;
                    attackerParty.distributeXpAndSp(xp, sp, rewardedMembers, lastAttacker);
                }
            }
        }
        this._aggroList = null;
        this.doItemDrop(lastAttacker);
        if (this.hasSpoil()) {
            this.doSweepDrop(lastAttacker);
        }
    }

    private void addDamage(L2Character attacker, int damage) {
        this.addDamageHate(attacker, damage, damage);
    }

    public void addDamageHate(L2Character attacker, int damage, int aggro) {
        if (this instanceof L2SiegeGuardInstance && attacker instanceof L2SiegeGuardInstance) {
            return;
        }
        if (this instanceof L2MonsterInstance && attacker instanceof L2MonsterInstance) {
            return;
        }
        if (attacker == null) {
            return;
        }
        if (this._aggroList == null) {
            this._aggroList = new ConcurrentHashMap();
            AggroInfo ai = new AggroInfo(attacker);
            ai.damage = damage;
            ai.hate = aggro;
            this._aggroList.put(attacker, ai);
        } else {
            AggroInfo ai = this._aggroList.get(attacker);
            if (ai != null) {
                ai.damage += damage;
                ai.hate += aggro;
            } else {
                ai = new AggroInfo(attacker);
                ai.damage = damage;
                ai.hate = aggro;
                this._aggroList.put(attacker, ai);
            }
        }
        if (aggro > 0 && this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (damage > 0) {
            this.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, attacker);
        }
    }

    public L2Character getMostHated() {
        if (this._aggroList == null || this.isAlikeDead()) {
            return null;
        }
        L2Character mostHated = null;
        int maxHate = 0;
        for (AggroInfo ai : this._aggroList.values()) {
            if (ai.attacker.isAlikeDead() || !this.knowsObject(ai.attacker) || !ai.attacker.isVisible()) {
                ai.hate = 0;
            }
            if (ai.hate <= maxHate) continue;
            mostHated = ai.attacker;
            maxHate = ai.hate;
        }
        return mostHated;
    }

    public int getHating(L2Character target) {
        if (this._aggroList == null) {
            return 0;
        }
        AggroInfo ai = this._aggroList.get(target);
        if (ai == null) {
            return 0;
        }
        if (!ai.attacker.isVisible()) {
            this._aggroList.remove(target);
            return 0;
        }
        if (ai.attacker.isAlikeDead()) {
            ai.hate = 0;
            return 0;
        }
        return ai.hate;
    }

    public void doSweepDrop(L2Character lastAttacker) {
        if (lastAttacker.getLevel() - this.getLevel() > 9) {
            return;
        }
        List<L2DropData> drops = this.getTemplate().getDropData();
        if (Config.DEBUG) {
            _log.finer("this npc has " + drops.size() + " drops defined");
        }
        ArrayList<L2ItemInstance> spoiled = new ArrayList<L2ItemInstance>();
        for (L2DropData drop2 : drops) {
            int roll;
            if (!drop2.isSweep() || !((float)(roll = L2Character.getRnd().nextInt(1000000)) < (float)drop2.getChance() * Config.RATE_DROP_SPOIL)) continue;
            L2ItemInstance dropit = ItemTable.getInstance().createItem(drop2.getItemId());
            int min = drop2.getMinDrop();
            int max = drop2.getMaxDrop();
            int itemCount = 0;
            itemCount = min < max ? L2Character.getRnd().nextInt(max - min) + min : 1;
            if (dropit.getItemId() == 57) {
                itemCount = (int)((float)itemCount * Config.RATE_DROP_ADENA);
            }
            if (itemCount != 0) {
                dropit.setCount(itemCount);
                if (Config.DEBUG) {
                    _log.fine("Item id to spoil: " + drop2.getItemId() + " amount: " + dropit.getCount());
                }
                spoiled.add(dropit);
                continue;
            }
            _log.warning("Roll produced 0 items to drop... Cancelling");
        }
        if (spoiled.size() > 0) {
            this._sweepItems = spoiled.toArray(new L2ItemInstance[spoiled.size()]);
        }
    }

    public void doEventDrop(L2Character lastAttacker) {
        if (lastAttacker.getLevel() - this.getLevel() > 9) {
            return;
        }
        for (EventDroplist.DateDrop drop2 : EventDroplist.getInstance().getAllDrops()) {
            int roll = L2Character.getRnd().nextInt(1000000);
            if (roll >= drop2.chance) continue;
            Random generator = new Random();
            int number = generator.nextInt(drop2.items.length);
            int itemID = drop2.items[number];
            L2ItemInstance dropit = ItemTable.getInstance().createItem(itemID);
            int min = drop2.min;
            int max = drop2.max;
            int itemCount = 0;
            itemCount = min < max ? L2Character.getRnd().nextInt(max - min) + min : 1;
            dropit.setCount(itemCount);
            if (Config.DEBUG) {
                _log.fine("Item id to drop: " + number + " amount: " + dropit.getCount());
            }
            if (GameServer.autoLootEnabled() && lastAttacker instanceof L2PcInstance) {
                ((L2PcInstance)lastAttacker).doAutoLoot(dropit);
                continue;
            }
            int z = this.getZ();
            if (lastAttacker.getZ() > z) {
                z = lastAttacker.getZ();
            }
            dropit.dropMe(this, this.getX(), this.getY(), z += 200);
        }
    }

    public void doItemDrop(L2Character lastAttacker) {
        this.doEventDrop(lastAttacker);
        ArrayList<L2DropData> drops = new ArrayList<L2DropData>();
        drops.addAll(this.getTemplate().getDropData());
        if (Config.DEBUG) {
            _log.finer("this npc has " + drops.size() + " drops defined");
        }
        if (lastAttacker instanceof L2PcInstance) {
            L2PcInstance player = (L2PcInstance)lastAttacker;
            player.fillQuestDrops(this, drops);
        }
        for (L2DropData drop2 : drops) {
            int roll;
            if (drop2.isSweep() || !((float)(roll = L2Character.getRnd().nextInt(1000000)) < (float)drop2.getChance() * Config.RATE_DROP_ITEMS)) continue;
            L2ItemInstance dropit = ItemTable.getInstance().createItem(drop2.getItemId());
            int min = drop2.getMinDrop();
            int max = drop2.getMaxDrop();
            int itemCount = 0;
            itemCount = min < max ? L2Character.getRnd().nextInt(max - min) + min : 1;
            if (dropit.getItemId() == 57) {
                itemCount = (int)((float)itemCount * Config.RATE_DROP_ADENA);
            }
            if (itemCount != 0) {
                dropit.setCount(itemCount);
                if (Config.DEBUG) {
                    _log.fine("Item id to drop: " + drop2.getItemId() + " amount: " + dropit.getCount());
                }
                if (GameServer.autoLootEnabled() && lastAttacker instanceof L2PcInstance) {
                    ((L2PcInstance)lastAttacker).doAutoLoot(dropit);
                    continue;
                }
                if (drop2.isQuestDrop()) {
                    ((L2PcInstance)lastAttacker).doAutoLoot(dropit);
                    continue;
                }
                int z = this.getZ();
                if (lastAttacker.getZ() > z) {
                    z = lastAttacker.getZ();
                }
                dropit.dropMe(this, this.getX(), this.getY(), z += 200);
                continue;
            }
            _log.warning("Roll produced 0 items to drop... Cancelling");
        }
    }

    public L2ItemInstance getActiveWeapon() {
        return null;
    }

    public boolean noTarget() {
        return this._aggroList == null || this._aggroList.isEmpty();
    }

    public boolean containsTarget(L2Character player) {
        if (this._aggroList == null) {
            return false;
        }
        return this._aggroList.containsKey(player);
    }

    public void clearAggroList() {
        this._aggroList = null;
    }

    public boolean isSweepActive() {
        return this._sweepItems != null;
    }

    public synchronized L2ItemInstance[] takeSweep() {
        L2ItemInstance[] sweep = this._sweepItems;
        this._sweepItems = null;
        return sweep;
    }

    public void activateSpoil() {
        this._spoiled = true;
    }

    public boolean hasSpoil() {
        return this._spoiled;
    }

    private int[] calculateExpAndSp(int diff, int damage) {
        double xp = 0.0;
        double sp = 0.0;
        if (Config.ALT_GAME_EXPONENT_XP != 0.0f || Config.ALT_GAME_EXPONENT_SP != 0.0f) {
            xp = (double)this.getExpReward() * (double)damage / (double)this.getMaxHp();
            if (Config.ALT_GAME_EXPONENT_XP != 0.0f) {
                xp *= Math.pow(2.0, (float)(-diff) / Config.ALT_GAME_EXPONENT_XP);
            }
            sp = (double)this.getSpReward() * (double)damage / (double)this.getMaxHp();
            if (Config.ALT_GAME_EXPONENT_SP != 0.0f) {
                sp *= Math.pow(2.0, (float)(-diff) / Config.ALT_GAME_EXPONENT_SP);
            }
        } else {
            if (diff > 0 && diff <= 9) {
                xp = (double)this.getExpReward() * (double)damage / (double)this.getMaxHp();
                sp = (double)this.getSpReward() * (double)damage / (double)this.getMaxHp();
                xp -= (double)diff * xp / 10.0;
                sp -= (double)diff * sp / 10.0;
            } else if (diff <= 0) {
                xp = (double)this.getExpReward() * (double)damage / (double)this.getMaxHp();
                sp = (double)this.getSpReward() * (double)damage / (double)this.getMaxHp();
            } else if (diff > 9) {
                xp = 0.0;
                sp = 0.0;
            }
            if (xp <= 0.0) {
                xp = 0.0;
                sp = 0.0;
            } else if (sp <= 0.0 && xp > 0.0) {
                sp = 0.0;
            }
        }
        int[] tmp = new int[]{(int)xp, (int)sp};
        return tmp;
    }

    public boolean isAttackable() {
        return true;
    }

    public final class AggroInfo {
        L2Character attacker;
        int hate;
        int damage;

        AggroInfo(L2Character attacker) {
            this.attacker = attacker;
        }

        public boolean equals(Object obj) {
            return this == obj || this.attacker == this.attacker;
        }

        public int hashCode() {
            return this.attacker.getObjectId();
        }
    }
}

